/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.capability.ex;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.caps.IExplosive;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.content.reg.BlockReg;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CapabilityExplosiveStack
implements IExplosive,
ICapabilitySerializable<NBTTagCompound> {
    private final ItemStack stack;
    private NBTTagCompound custom_ex_data;

    public CapabilityExplosiveStack(ItemStack stack) {
        this.stack = stack;
    }

    protected int getExplosiveID() {
        if (this.stack == null) {
            return 0;
        }
        return this.stack.func_77952_i();
    }

    @Override
    @Nullable
    public IExplosiveData getExplosiveData() {
        return ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData(this.getExplosiveID());
    }

    @Override
    @Nullable
    public NBTTagCompound getCustomBlastData() {
        if (this.custom_ex_data == null) {
            this.custom_ex_data = new NBTTagCompound();
        }
        return this.custom_ex_data;
    }

    public void setCustomData(NBTTagCompound data) {
        this.custom_ex_data = data;
    }

    @Override
    @Nullable
    public ItemStack toStack() {
        if (this.stack == null) {
            return new ItemStack(BlockReg.blockExplosive, 1, 0);
        }
        ItemStack re = this.stack.func_77946_l();
        re.func_190920_e(1);
        return re;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound save = new NBTTagCompound();
        if (!this.getCustomBlastData().func_82582_d()) {
            save.func_74782_a("custom_ex_data", (NBTBase)this.getCustomBlastData());
        }
        return save;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("custom_ex_data")) {
            this.custom_ex_data = nbt.func_74775_l("custom_ex_data");
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == ICBMClassicAPI.EXPLOSIVE_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == ICBMClassicAPI.EXPLOSIVE_CAPABILITY) {
            return (T)this;
        }
        return null;
    }
}

