/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.utils;

import com.litewolf101.utils.IStructure;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class StructureHandler
extends WorldGenerator
implements IStructure {
    public String structureName;

    public StructureHandler(String name) {
        this.structureName = name;
    }

    public String getStructureName(StructureHandler handler) {
        return handler.structureName;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        this.generateStructureRotNone(worldIn, position);
        this.generateStructureRot90(worldIn, position);
        this.generateStructureRot180(worldIn, position);
        this.generateStructureRot270(worldIn, position);
        this.generateStructureRotRandom(worldIn, rand, position);
        return true;
    }

    public void generateStructureRotNone(World world, BlockPos pos) {
        ResourceLocation location;
        MinecraftServer mcServer = world.func_73046_m();
        TemplateManager manager = worldServer.func_184163_y();
        Template template = manager.func_189942_b(mcServer, location = new ResourceLocation("illagers_plus", this.structureName));
        if (template != null) {
            IBlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 3);
            template.func_186260_a(world, pos, settings.func_186220_a(Rotation.NONE));
        }
    }

    public void generateStructureRot90(World world, BlockPos pos) {
        ResourceLocation location;
        MinecraftServer mcServer = world.func_73046_m();
        TemplateManager manager = worldServer.func_184163_y();
        Template template = manager.func_189942_b(mcServer, location = new ResourceLocation("illagers_plus", this.structureName));
        if (template != null) {
            IBlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 3);
            template.func_186260_a(world, pos, settings.func_186220_a(Rotation.CLOCKWISE_90));
        }
    }

    public void generateStructureRot180(World world, BlockPos pos) {
        ResourceLocation location;
        MinecraftServer mcServer = world.func_73046_m();
        TemplateManager manager = worldServer.func_184163_y();
        Template template = manager.func_189942_b(mcServer, location = new ResourceLocation("illagers_plus", this.structureName));
        if (template != null) {
            IBlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 3);
            template.func_186260_a(world, pos, settings.func_186220_a(Rotation.CLOCKWISE_180));
        }
    }

    public void generateStructureRot270(World world, BlockPos pos) {
        ResourceLocation location;
        MinecraftServer mcServer = world.func_73046_m();
        TemplateManager manager = worldServer.func_184163_y();
        Template template = manager.func_189942_b(mcServer, location = new ResourceLocation("illagers_plus", this.structureName));
        if (template != null) {
            IBlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 3);
            template.func_186260_a(world, pos, settings.func_186220_a(Rotation.COUNTERCLOCKWISE_90));
        }
    }

    public void generateStructureRotRandom(World world, Random random, BlockPos pos) {
        ResourceLocation location;
        MinecraftServer mcServer = world.func_73046_m();
        TemplateManager manager = worldServer.func_184163_y();
        Template template = manager.func_189942_b(mcServer, location = new ResourceLocation("illagers_plus", this.structureName));
        if (template != null) {
            IBlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 3);
            template.func_186260_a(world, pos, settings.func_186220_a(this.randomRotation(random)));
        }
    }

    public Rotation randomRotation(Random random) {
        Rotation rotation = Rotation.NONE;
        int rand = random.nextInt(3);
        if (rand == 1) {
            rotation = Rotation.CLOCKWISE_90;
        } else if (rand == 2) {
            rotation = Rotation.CLOCKWISE_180;
        } else if (rand == 3) {
            rotation = Rotation.COUNTERCLOCKWISE_90;
        }
        return rotation;
    }

    public Rotation getStructureRotation() {
        return settings.func_186215_c();
    }

    public static enum RotationType {
        NONE,
        DEGREES90,
        DEGREES180,
        DEGREES270,
        RANDOM;

    }
}

