/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.world;

import com.google.common.collect.Maps;
import com.litewolf101.objects.entities.EntityArcher;
import com.litewolf101.objects.entities.EntityEnchanter;
import com.litewolf101.objects.entities.EntityFurantur;
import com.litewolf101.objects.entities.EntityHoarder;
import com.litewolf101.objects.entities.EntityIllagerKing;
import com.litewolf101.objects.entities.EntityNecromancer;
import com.litewolf101.utils.IllagerPlusLootTable;
import com.litewolf101.utils.IllagersPlusConfig;
import com.litewolf101.utils.StructureHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityIllusionIllager;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCustomStructures
implements IWorldGenerator {
    private final Map<String, AxisAlignedBB> StructureMap = Maps.newHashMap();
    public static final StructureHandler ILLAGER_TOWER_F1 = new StructureHandler("illager_tower_f1");
    public static final StructureHandler ILLAGER_TOWER_F2_A = new StructureHandler("illager_tower_f2_a");
    public static final StructureHandler ILLAGER_TOWER_F2_B = new StructureHandler("illager_tower_f2_b");
    public static final StructureHandler ILLAGER_TOWER_F3_A = new StructureHandler("illager_tower_f3_a");
    public static final StructureHandler ILLAGER_TOWER_F3_B = new StructureHandler("illager_tower_f3_b");
    public static final StructureHandler ILLAGER_TOWER_F3_C = new StructureHandler("illager_tower_f3_c");
    public static final StructureHandler ILLAGER_TOWER_F4_A = new StructureHandler("illager_tower_f4_a");
    public static final StructureHandler ILLAGER_TOWER_F4_B = new StructureHandler("illager_tower_f4_b");
    public static final StructureHandler ILLAGER_TOWER_F5 = new StructureHandler("illager_tower_f5");
    public static final StructureHandler ILLAGER_TOWER_F6 = new StructureHandler("illager_tower_f6");
    public static final StructureHandler ILLAGER_ARCHER_TOWER = new StructureHandler("illager_archer_tower");
    public static final StructureHandler ILLAGER_CENTRE = new StructureHandler("illager_centre");
    public static final StructureHandler ANIMAL_PEN = new StructureHandler("animal_pen");
    public static final StructureHandler FIREWORKS_DISPLAY = new StructureHandler("fireworks_display");
    public static final StructureHandler FLOWER_BED = new StructureHandler("flower_bed");
    public static final StructureHandler ILLAGER_DUMMY_1 = new StructureHandler("illager_dummy_1");
    public static final StructureHandler ILLAGER_DUMMY_2 = new StructureHandler("illager_dummy_2");
    public static final StructureHandler ILLAGER_FARM = new StructureHandler("illager_farm");
    public static final StructureHandler ILLAGER_STORAGE = new StructureHandler("illager_storage");
    public static final StructureHandler ILLAGER_WELL = new StructureHandler("illager_well");
    public static final StructureHandler LOG_PILE = new StructureHandler("log_pile");
    public static final StructureHandler UNDYING_TOTEM = new StructureHandler("undying_totem");

    public void addStructureBB(StructureHandler handler, AxisAlignedBB bb) {
        AxisAlignedBB adjustForRotationalBB = bb.func_72317_d(-this.biggestStructureSize(bb), 0.0, -this.biggestStructureSize(bb)).func_72314_b(2.0 * this.biggestStructureSize(bb), 0.0, 2.0 * this.biggestStructureSize(bb));
        if (handler != null) {
            this.StructureMap.put(handler.structureName, adjustForRotationalBB);
        }
    }

    public double biggestStructureSize(AxisAlignedBB bb) {
        double x = bb.field_72336_d;
        double z = bb.field_72334_f;
        return x >= z ? x : z;
    }

    public AxisAlignedBB getStructureBB(StructureHandler handler) {
        for (Map.Entry<String, AxisAlignedBB> entry : this.StructureMap.entrySet()) {
            if (!handler.structureName.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.generateIllagerTower(world, random, chunkX, chunkZ, IllagersPlusConfig.illager_tower_freq, (Block)Blocks.field_150349_c, Biomes.field_76772_c.func_150562_l());
                this.generateIllagerTower(world, random, chunkX, chunkZ, IllagersPlusConfig.illager_tower_freq, (Block)Blocks.field_150349_c, Biomes.field_150585_R.func_150562_l());
                this.generateIllagerCentre(world, random, chunkX, chunkZ, IllagersPlusConfig.illager_centre_freq, (Block)Blocks.field_150349_c, Biomes.field_76772_c.func_150562_l());
                this.generateIllagerArcherTower(world, random, chunkX, chunkZ, IllagersPlusConfig.illager_archer_tower_freq, (Block)Blocks.field_150349_c, Biomes.field_76772_c.func_150562_l());
                this.generateIllagerArcherTower(world, random, chunkX, chunkZ, IllagersPlusConfig.illager_archer_tower_freq, (Block)Blocks.field_150349_c, Biomes.field_76767_f.func_150562_l());
                this.generateIllagerArcherTower(world, random, chunkX, chunkZ, IllagersPlusConfig.illager_archer_tower_freq, (Block)Blocks.field_150349_c, Biomes.field_150588_X.func_150562_l());
                this.generateIllagerArcherTower(world, random, chunkX, chunkZ, IllagersPlusConfig.illager_archer_tower_freq, (Block)Blocks.field_150349_c, Biomes.field_76768_g.func_150562_l());
                this.generateIllagerArcherTower(world, random, chunkX, chunkZ, IllagersPlusConfig.illager_archer_tower_freq, (Block)Blocks.field_150354_m, Biomes.field_76769_d.func_150562_l());
                break;
            }
            case 1: {
                break;
            }
        }
    }

    private void generateStructure(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chance, Block topBlock, Class<?> ... classes) {
        ArrayList classesList = new ArrayList(Arrays.asList(classes));
        int x = chunkX * 16;
        int z = chunkZ * 16;
        int y = WorldGenCustomStructures.calculateGenerationHeight(world, x, z, topBlock);
        BlockPos pos = new BlockPos(x, y, z);
        Class<?> biome = world.field_73011_w.getBiomeForCoords(pos).getClass();
        if (world.func_175624_G() != WorldType.field_77138_c && classesList.contains(biome) && random.nextInt(chance) == 0) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private void generateStructure(StructureHandler structure, StructureHandler.RotationType rotationType, World world, Random random, int chunkX, int chunkZ, int chance, Block topBlock, Class<?> ... classes) {
        ArrayList classesList = new ArrayList(Arrays.asList(classes));
        int x = chunkX * 16;
        int z = chunkZ * 16;
        int y = WorldGenCustomStructures.calculateGenerationHeight(world, x, z, topBlock);
        BlockPos pos = new BlockPos(x, y, z);
        Class<?> biome = world.field_73011_w.getBiomeForCoords(pos).getClass();
        if (world.func_175624_G() != WorldType.field_77138_c && classesList.contains(biome) && random.nextInt(chance) == 0) {
            if (rotationType == StructureHandler.RotationType.NONE) {
                structure.generateStructureRotNone(world, pos);
            } else if (rotationType == StructureHandler.RotationType.DEGREES90) {
                structure.generateStructureRot90(world, pos);
            } else if (rotationType == StructureHandler.RotationType.DEGREES180) {
                structure.generateStructureRot180(world, pos);
            } else if (rotationType == StructureHandler.RotationType.DEGREES270) {
                structure.generateStructureRot270(world, pos);
            } else if (rotationType == StructureHandler.RotationType.RANDOM) {
                structure.generateStructureRotRandom(world, random, pos);
            }
        }
    }

    private void generateStructure(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chance, Block topBlock) {
        int x = chunkX * 16;
        int z = chunkZ * 16;
        int y = WorldGenCustomStructures.calculateGenerationHeight(world, x, z, topBlock);
        BlockPos pos = new BlockPos(x, y, z);
        if (world.func_175624_G() != WorldType.field_77138_c && random.nextInt(chance) == 0) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private void generateStructure(StructureHandler structure, StructureHandler.RotationType rotationType, World world, Random random, int chunkX, int chunkZ, int chance, Block topBlock) {
        int x = chunkX * 16;
        int z = chunkZ * 16;
        int y = WorldGenCustomStructures.calculateGenerationHeight(world, x, z, topBlock);
        BlockPos pos = new BlockPos(x, y, z);
        if (world.func_175624_G() != WorldType.field_77138_c && random.nextInt(chance) == 0) {
            if (rotationType == StructureHandler.RotationType.NONE) {
                structure.generateStructureRotNone(world, pos);
            } else if (rotationType == StructureHandler.RotationType.DEGREES90) {
                structure.generateStructureRot90(world, pos);
            } else if (rotationType == StructureHandler.RotationType.DEGREES180) {
                structure.generateStructureRot180(world, pos);
            } else if (rotationType == StructureHandler.RotationType.DEGREES270) {
                structure.generateStructureRot270(world, pos);
            } else if (rotationType == StructureHandler.RotationType.RANDOM) {
                structure.generateStructureRotRandom(world, random, pos);
            }
        }
    }

    private void generateIllagerTower(World world, Random random, int chunkX, int chunkZ, int chance, Block topBlock, Class<?> ... classes) {
        ArrayList classesList = new ArrayList(Arrays.asList(classes));
        int x = chunkX * 16;
        int z = chunkZ * 16;
        int y = WorldGenCustomStructures.calculateGenerationHeight(world, x, z, topBlock);
        BlockPos pos = new BlockPos(x, y, z);
        Class<?> biome = world.field_73011_w.getBiomeForCoords(pos).getClass();
        if (world.func_175624_G() != WorldType.field_77138_c && classesList.contains(biome) && random.nextInt(chance) == 0 && this.compareFloor(world, pos, 24, 24, ILLAGER_TOWER_F1.getStructureRotation(), topBlock)) {
            this.HandleIllagerTower(world, random, pos);
        }
    }

    private static void spawnArcher(World world, BlockPos pos) {
        EntityArcher archer = new EntityArcher(world);
        archer.func_110163_bv();
        archer.func_174828_a(pos, 0.0f, 0.0f);
        archer.func_180482_a(world.func_175649_E(new BlockPos((Entity)archer)), null);
        world.func_72838_d((Entity)archer);
    }

    private static void spawnEnchanter(World world, BlockPos pos) {
        EntityEnchanter enchanter = new EntityEnchanter(world);
        enchanter.func_110163_bv();
        enchanter.func_174828_a(pos, 0.0f, 0.0f);
        enchanter.func_180482_a(world.func_175649_E(new BlockPos((Entity)enchanter)), null);
        world.func_72838_d((Entity)enchanter);
    }

    private static void spawnFurantur(World world, BlockPos pos) {
        EntityFurantur furantur = new EntityFurantur(world);
        furantur.func_110163_bv();
        furantur.func_174828_a(pos, 0.0f, 0.0f);
        furantur.func_180482_a(world.func_175649_E(new BlockPos((Entity)furantur)), null);
        world.func_72838_d((Entity)furantur);
    }

    private static void spawnHoarder(World world, BlockPos pos) {
        EntityHoarder hoarder = new EntityHoarder(world);
        hoarder.func_110163_bv();
        hoarder.func_174828_a(pos, 0.0f, 0.0f);
        hoarder.func_180482_a(world.func_175649_E(new BlockPos((Entity)hoarder)), null);
        world.func_72838_d((Entity)hoarder);
    }

    private static void spawnIllagerKing(World world, BlockPos pos) {
        EntityIllagerKing king = new EntityIllagerKing(world);
        king.func_110163_bv();
        king.func_174828_a(pos, 0.0f, 0.0f);
        king.func_180482_a(world.func_175649_E(new BlockPos((Entity)king)), null);
        world.func_72838_d((Entity)king);
    }

    private static void spawnNecromancer(World world, BlockPos pos) {
        EntityNecromancer necromancer = new EntityNecromancer(world);
        necromancer.func_110163_bv();
        necromancer.func_174828_a(pos, 0.0f, 0.0f);
        necromancer.func_180482_a(world.func_175649_E(new BlockPos((Entity)necromancer)), null);
        world.func_72838_d((Entity)necromancer);
    }

    private static void spawnVindicator(World world, BlockPos pos) {
        EntityVindicator vindicator = new EntityVindicator(world);
        vindicator.func_110163_bv();
        vindicator.func_174828_a(pos, 0.0f, 0.0f);
        vindicator.func_180482_a(world.func_175649_E(new BlockPos((Entity)vindicator)), (IEntityLivingData)null);
        world.func_72838_d((Entity)vindicator);
    }

    private static void spawnEvoker(World world, BlockPos pos) {
        EntityEvoker evoker = new EntityEvoker(world);
        evoker.func_110163_bv();
        evoker.func_174828_a(pos, 0.0f, 0.0f);
        evoker.func_180482_a(world.func_175649_E(new BlockPos((Entity)evoker)), (IEntityLivingData)null);
        world.func_72838_d((Entity)evoker);
    }

    private static void spawnIllusioner(World world, BlockPos pos) {
        EntityIllusionIllager illusioner = new EntityIllusionIllager(world);
        illusioner.func_110163_bv();
        illusioner.func_174828_a(pos, 0.0f, 0.0f);
        illusioner.func_180482_a(world.func_175649_E(new BlockPos((Entity)illusioner)), (IEntityLivingData)null);
        world.func_72838_d((Entity)illusioner);
    }

    private void generateIllagerArcherTower(World world, Random random, int chunkX, int chunkZ, int chance, Block topBlock, Class<?> ... classes) {
        ArrayList classesList = new ArrayList(Arrays.asList(classes));
        int x = chunkX * 16;
        int z = chunkZ * 16;
        int y = WorldGenCustomStructures.calculateGenerationHeight(world, x, z, topBlock);
        BlockPos pos = new BlockPos(x, y, z);
        Class<?> biome = world.field_73011_w.getBiomeForCoords(pos).getClass();
        if (world.func_175624_G() != WorldType.field_77138_c && classesList.contains(biome) && random.nextInt(chance) == 0 && this.compareFloor(world, pos, 14, 14, ILLAGER_ARCHER_TOWER.getStructureRotation(), topBlock)) {
            ILLAGER_ARCHER_TOWER.generateStructureRotRandom(world, random, pos.func_177984_a());
            if (ILLAGER_ARCHER_TOWER.getStructureRotation() == Rotation.NONE) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_ARCHER_TOWER, pos.func_177982_a(7, 9, 5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(4.5, 9.0, 4.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(4.5, 9.0, 8.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(8.5, 9.0, 8.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(8.5, 9.0, 4.5));
            } else if (ILLAGER_ARCHER_TOWER.getStructureRotation() == Rotation.CLOCKWISE_90) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_ARCHER_TOWER, pos.func_177982_a(-5, 9, 7));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-4.5, 9.0, 4.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-8.5, 9.0, 4.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-8.5, 9.0, 8.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-4.5, 9.0, 8.5));
            } else if (ILLAGER_ARCHER_TOWER.getStructureRotation() == Rotation.CLOCKWISE_180) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_ARCHER_TOWER, pos.func_177982_a(-7, 9, -5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-4.5, 9.0, -4.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-4.5, 9.0, -8.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-8.5, 9.0, -8.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-8.5, 9.0, -4.5));
            } else if (ILLAGER_ARCHER_TOWER.getStructureRotation() == Rotation.COUNTERCLOCKWISE_90) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_ARCHER_TOWER, pos.func_177982_a(5, 9, -7));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(4.5, 9.0, -4.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(8.5, 9.0, -4.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(8.5, 9.0, -8.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(4.5, 9.0, -8.5));
            }
        }
    }

    private boolean compareFloor(World world, BlockPos pos, int xSize, int zSize, Rotation rotation, Block block) {
        int checkZ;
        int checkX;
        int checkNum = 0;
        if (rotation == Rotation.NONE) {
            for (checkX = pos.func_177958_n(); checkX <= pos.func_177958_n() + xSize; ++checkX) {
                for (checkZ = pos.func_177952_p(); checkZ <= pos.func_177952_p() + zSize; ++checkZ) {
                    if (world.func_180495_p(new BlockPos(checkX, pos.func_177956_o(), checkZ)).func_177230_c() != block && !(world.func_180495_p(new BlockPos(checkX, pos.func_177956_o(), checkZ)).func_177230_c() instanceof BlockBush)) continue;
                    ++checkNum;
                }
            }
        } else if (rotation == Rotation.CLOCKWISE_90) {
            for (checkX = pos.func_177958_n(); checkX >= pos.func_177958_n() - xSize; --checkX) {
                for (checkZ = pos.func_177952_p(); checkZ <= pos.func_177952_p() + zSize; ++checkZ) {
                    if (world.func_180495_p(new BlockPos(checkX, pos.func_177956_o(), checkZ)).func_177230_c() != block && !(world.func_180495_p(new BlockPos(checkX, pos.func_177956_o(), checkZ)).func_177230_c() instanceof BlockBush)) continue;
                    ++checkNum;
                }
            }
        } else if (rotation == Rotation.CLOCKWISE_180) {
            for (checkX = pos.func_177958_n(); checkX >= pos.func_177958_n() - xSize; --checkX) {
                for (checkZ = pos.func_177952_p(); checkZ >= pos.func_177952_p() - zSize; --checkZ) {
                    if (world.func_180495_p(new BlockPos(checkX, pos.func_177956_o(), checkZ)).func_177230_c() != block && !(world.func_180495_p(new BlockPos(checkX, pos.func_177956_o(), checkZ)).func_177230_c() instanceof BlockBush)) continue;
                    ++checkNum;
                }
            }
        }
        if (rotation == Rotation.COUNTERCLOCKWISE_90) {
            for (checkX = pos.func_177958_n(); checkX <= pos.func_177958_n() + xSize; ++checkX) {
                for (checkZ = pos.func_177952_p(); checkZ >= pos.func_177952_p() - zSize; --checkZ) {
                    if (world.func_180495_p(new BlockPos(checkX, pos.func_177956_o(), checkZ)).func_177230_c() != block && !(world.func_180495_p(new BlockPos(checkX, pos.func_177956_o(), checkZ)).func_177230_c() instanceof BlockBush)) continue;
                    ++checkNum;
                }
            }
        }
        return checkNum >= xSize * zSize;
    }

    private void HandleIllagerTower(World world, Random random, BlockPos pos) {
        Random random1 = new Random();
        int F2_RAND = random.nextInt(10);
        int F3_RAND = random1.nextInt(10);
        ILLAGER_TOWER_F1.generateStructureRotRandom(world, random, pos);
        if (ILLAGER_TOWER_F1.getStructureRotation() == Rotation.NONE) {
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(9, 1, 26));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(9, 1, 27));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(9, 2, 26));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(9, 2, 27));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(22, 1, 26));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(22, 1, 27));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(22, 2, 26));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(22, 2, 27));
            WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(13, 1, 7));
            WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(18, 1, 7));
            WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(11, 1, 13));
            WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(20, 1, 13));
            WorldGenCustomStructures.spawnEnchanter(world, pos.func_177963_a(15.5, 1.0, 22.0));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(14.5, 1.0, 22.0));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(16.5, 1.0, 22.0));
            if (F2_RAND <= 5) {
                ILLAGER_TOWER_F2_A.generateStructureRotNone(world, pos.func_177981_b(12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 13, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(25, 13, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(23, 13, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(22, 13, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 14, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(25, 14, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(23, 14, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(22, 14, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 15, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(25, 15, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(23, 15, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(22, 15, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 16, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(25, 16, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(23, 16, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(22, 16, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(26, 13, 5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(20, 13, 7));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(20, 13, 8));
                WorldGenCustomStructures.spawnHoarder(world, pos.func_177963_a(23.0, 13.0, 7.5));
                WorldGenCustomStructures.spawnNecromancer(world, pos.func_177982_a(24, 13, 23));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177982_a(13, 13, 9));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(17, 18, 9));
                ILLAGER_TOWER_F3_A.generateStructureRotNone(world, pos.func_177981_b(24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TREES, pos.func_177982_a(23, 25, 16));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(11, 25, 7));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TNT_TRAP, pos.func_177982_a(24, 30, 24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(15, 30, 18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(15, 30, 19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(18, 30, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(19, 30, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(8, 30, 7));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(13, 25, 7));
                WorldGenCustomStructures.spawnEnchanter(world, pos.func_177982_a(10, 25, 17));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(13, 30, 14));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(14, 30, 13));
                ILLAGER_TOWER_F4_A.generateStructureRotNone(world, pos.func_177981_b(36));
            } else {
                ILLAGER_TOWER_F2_B.generateStructureRotNone(world, pos.func_177981_b(12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(15, 13, 5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(16, 13, 5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(11, 13, 13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(12, 13, 13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(20, 13, 13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(19, 13, 13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(5, 18, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 18, 15));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(5, 13, 5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(26, 13, 5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(5, 13, 26));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(26, 13, 26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(5, 18, 5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(26, 18, 5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(5, 18, 26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(26, 18, 26));
                if (F3_RAND <= 5) {
                    ILLAGER_TOWER_F3_B.generateStructureRotNone(world, pos.func_177981_b(24));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(5, 25, 10));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(5, 26, 10));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(10, 25, 8));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(10, 26, 8));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_MECHANICS, pos.func_177982_a(6, 26, 21));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(24, 25, 26));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(23, 25, 26));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(26, 25, 24));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(26, 25, 23));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(22, 25, 5));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(23, 25, 5));
                } else {
                    ILLAGER_TOWER_F3_C.generateStructureRotNone(world, pos.func_177981_b(24));
                }
                ILLAGER_TOWER_F4_B.generateStructureRotNone(world, pos.func_177981_b(36));
            }
            ILLAGER_TOWER_F5.generateStructureRotNone(world, pos.func_177981_b(48));
            WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(15, 51, 8));
            WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(16, 51, 8));
            WorldGenCustomStructures.spawnIllusioner(world, pos.func_177963_a(15.5, 49.0, 15.5));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(14, 51, 9));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(17, 51, 9));
            ILLAGER_TOWER_F6.generateStructureRotNone(world, pos.func_177981_b(58));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(13, 59, 18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(13, 59, 19));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(13, 60, 18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(13, 60, 19));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(15, 59, 21));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(16, 59, 21));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 59, 18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 59, 19));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 60, 18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 60, 19));
            WorldGenCustomStructures.spawnIllagerKing(world, pos.func_177963_a(15.5, 60.0, 14.5));
        }
        if (ILLAGER_TOWER_F1.getStructureRotation() == Rotation.CLOCKWISE_90) {
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-26, 1, 9));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-27, 1, 9));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-26, 2, 9));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-27, 2, 9));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-26, 1, 22));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-27, 1, 22));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-26, 2, 22));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-27, 2, 22));
            WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-7, 1, 13));
            WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-7, 1, 18));
            WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-13, 1, 11));
            WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-13, 1, 20));
            WorldGenCustomStructures.spawnEnchanter(world, pos.func_177963_a(-22.0, 1.0, 15.5));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-22.0, 1.0, 14.5));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-22.0, 1.0, 16.5));
            if (F2_RAND <= 5) {
                ILLAGER_TOWER_F2_A.generateStructureRot90(world, pos.func_177981_b(12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 13, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 13, 25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 13, 23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 13, 22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 14, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 14, 25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 14, 23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 14, 22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 15, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 15, 25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 15, 23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 15, 22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 16, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 16, 25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 16, 23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 16, 22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(-5, 13, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(-7, 13, 20));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(-8, 13, 20));
                WorldGenCustomStructures.spawnHoarder(world, pos.func_177963_a(-7.5, 13.0, 23.0));
                WorldGenCustomStructures.spawnNecromancer(world, pos.func_177982_a(-23, 13, 24));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177982_a(-9, 13, 13));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-9, 18, 17));
                ILLAGER_TOWER_F3_A.generateStructureRot90(world, pos.func_177981_b(24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TREES, pos.func_177982_a(-16, 25, 23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-7, 25, 11));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TNT_TRAP, pos.func_177982_a(-24, 30, 24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-18, 30, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-19, 30, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-15, 30, 18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-15, 30, 19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-7, 30, 8));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-7, 25, 13));
                WorldGenCustomStructures.spawnEnchanter(world, pos.func_177982_a(-17, 25, 10));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-14, 30, 13));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-13, 30, 14));
                ILLAGER_TOWER_F4_A.generateStructureRot90(world, pos.func_177981_b(36));
            } else {
                ILLAGER_TOWER_F2_B.generateStructureRot90(world, pos.func_177981_b(12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-5, 13, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-5, 13, 16));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-13, 13, 11));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-13, 13, 12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-13, 13, 20));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-13, 13, 19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-15, 18, 5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-15, 18, 26));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-5, 13, 5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-5, 13, 26));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-26, 13, 5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-26, 13, 26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-5, 18, 5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-5, 18, 26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-26, 18, 5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-26, 18, 26));
                if (F3_RAND <= 5) {
                    ILLAGER_TOWER_F3_B.generateStructureRot90(world, pos.func_177981_b(24));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-10, 25, 5));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-10, 26, 5));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-8, 25, 10));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-8, 26, 10));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_MECHANICS, pos.func_177982_a(-21, 26, 6));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-26, 25, 24));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-26, 25, 23));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-24, 25, 26));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-23, 25, 26));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(-5, 25, 22));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(-5, 25, 23));
                } else {
                    ILLAGER_TOWER_F3_C.generateStructureRot90(world, pos.func_177981_b(24));
                }
                ILLAGER_TOWER_F4_B.generateStructureRot90(world, pos.func_177981_b(36));
            }
            ILLAGER_TOWER_F5.generateStructureRot90(world, pos.func_177981_b(48));
            WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-8, 51, 15));
            WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-8, 51, 16));
            WorldGenCustomStructures.spawnIllusioner(world, pos.func_177963_a(-15.5, 49.0, 15.5));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-9, 51, 14));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-9, 51, 17));
            ILLAGER_TOWER_F6.generateStructureRot90(world, pos.func_177981_b(58));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 59, 13));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-19, 59, 13));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 60, 13));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-19, 60, 13));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-21, 59, 15));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-21, 59, 16));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 59, 18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-19, 59, 18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 60, 18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-19, 60, 18));
            WorldGenCustomStructures.spawnIllagerKing(world, pos.func_177963_a(-14.5, 60.0, 15.5));
        }
        if (ILLAGER_TOWER_F1.getStructureRotation() == Rotation.CLOCKWISE_180) {
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-9, 1, -26));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-9, 1, -27));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-9, 2, -26));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-9, 2, -27));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-22, 1, -26));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-22, 1, -27));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-22, 2, -26));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-22, 2, -27));
            WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-13, 1, -7));
            WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-18, 1, -7));
            WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-11, 1, -13));
            WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-20, 1, -13));
            WorldGenCustomStructures.spawnEnchanter(world, pos.func_177963_a(-15.5, 1.0, -22.0));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-14.5, 1.0, -22.0));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-16.5, 1.0, -22.0));
            if (F2_RAND <= 5) {
                ILLAGER_TOWER_F2_A.generateStructureRot180(world, pos.func_177981_b(12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 13, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-25, 13, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-23, 13, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-22, 13, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 14, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-25, 14, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-23, 14, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-22, 14, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 15, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-25, 15, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-23, 15, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-22, 15, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 16, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-25, 16, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-23, 16, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-22, 16, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(-26, 13, -5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(-20, 13, -7));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(-20, 13, -8));
                WorldGenCustomStructures.spawnHoarder(world, pos.func_177963_a(-23.0, 13.0, -7.5));
                WorldGenCustomStructures.spawnNecromancer(world, pos.func_177982_a(-24, 13, -23));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177982_a(-13, 13, -9));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-17, 18, -9));
                ILLAGER_TOWER_F3_A.generateStructureRot180(world, pos.func_177981_b(24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TREES, pos.func_177982_a(-23, 25, -16));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-11, 25, -7));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TNT_TRAP, pos.func_177982_a(-24, 30, -24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-15, 30, -18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-15, 30, -19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-18, 30, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-19, 30, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-8, 30, -7));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-13, 25, -7));
                WorldGenCustomStructures.spawnEnchanter(world, pos.func_177982_a(-10, 25, -17));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-13, 30, -14));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-14, 30, -13));
                ILLAGER_TOWER_F4_A.generateStructureRot180(world, pos.func_177981_b(36));
            } else {
                ILLAGER_TOWER_F2_B.generateStructureRot180(world, pos.func_177981_b(12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-15, 13, -5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-16, 13, -5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-11, 13, -13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-12, 13, -13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-20, 13, -13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-19, 13, -13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-5, 18, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 18, -15));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-5, 13, -5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-26, 13, -5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-5, 13, -26));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-26, 13, -26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-5, 18, -5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-26, 18, -5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-5, 18, -26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-26, 18, -26));
                if (F3_RAND <= 5) {
                    ILLAGER_TOWER_F3_B.generateStructureRot180(world, pos.func_177981_b(24));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-5, 25, -10));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-5, 26, -10));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-10, 25, -8));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-10, 26, -8));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_MECHANICS, pos.func_177982_a(-6, 26, -21));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-24, 25, -26));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-23, 25, -26));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-26, 25, -24));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-26, 25, -23));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(-22, 25, -5));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(-23, 25, -5));
                } else {
                    ILLAGER_TOWER_F3_C.generateStructureRot180(world, pos.func_177981_b(24));
                }
                ILLAGER_TOWER_F4_B.generateStructureRot180(world, pos.func_177981_b(36));
            }
            ILLAGER_TOWER_F5.generateStructureRot180(world, pos.func_177981_b(48));
            WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-15, 51, -8));
            WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-16, 51, -8));
            WorldGenCustomStructures.spawnIllusioner(world, pos.func_177963_a(-15.5, 49.0, -15.5));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-14, 51, -9));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-17, 51, -9));
            ILLAGER_TOWER_F6.generateStructureRot180(world, pos.func_177981_b(58));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-13, 59, -18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-13, 59, -19));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-13, 60, -18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-13, 60, -19));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-15, 59, -21));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-16, 59, -21));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 59, -18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 59, -19));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 60, -18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 60, -19));
            WorldGenCustomStructures.spawnIllagerKing(world, pos.func_177963_a(-15.5, 60.0, -14.5));
        }
        if (ILLAGER_TOWER_F1.getStructureRotation() == Rotation.COUNTERCLOCKWISE_90) {
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(26, 1, -9));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(27, 1, -9));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(26, 2, -9));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(27, 2, -9));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(26, 1, -22));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(27, 1, -22));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(26, 2, -22));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(27, 2, -22));
            WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(7, 1, -13));
            WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(7, 1, -18));
            WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(13, 1, -11));
            WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(13, 1, -20));
            WorldGenCustomStructures.spawnEnchanter(world, pos.func_177963_a(22.0, 1.0, -15.5));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(22.0, 1.0, -14.5));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(22.0, 1.0, -16.5));
            if (F2_RAND <= 5) {
                ILLAGER_TOWER_F2_A.generateStructureRot270(world, pos.func_177981_b(12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 13, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 13, -25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 13, -23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 13, -22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 14, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 14, -25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 14, -23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 14, -22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 15, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 15, -25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 15, -23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 15, -22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 16, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 16, -25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 16, -23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 16, -22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(5, 13, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(7, 13, -20));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(8, 13, -20));
                WorldGenCustomStructures.spawnHoarder(world, pos.func_177963_a(7.5, 13.0, -23.0));
                WorldGenCustomStructures.spawnNecromancer(world, pos.func_177982_a(23, 13, -24));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177982_a(9, 13, -13));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(9, 18, -17));
                ILLAGER_TOWER_F3_A.generateStructureRot270(world, pos.func_177981_b(24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TREES, pos.func_177982_a(16, 25, -23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(7, 25, -11));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TNT_TRAP, pos.func_177982_a(24, 30, -24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(18, 30, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(19, 30, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(15, 30, -18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(15, 30, -19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(7, 30, -8));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(7, 25, -13));
                WorldGenCustomStructures.spawnEnchanter(world, pos.func_177982_a(17, 25, -10));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(14, 30, -13));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(13, 30, -14));
                ILLAGER_TOWER_F4_A.generateStructureRot270(world, pos.func_177981_b(36));
            } else {
                ILLAGER_TOWER_F2_B.generateStructureRot270(world, pos.func_177981_b(12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(5, 13, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(5, 13, -16));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(13, 13, -11));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(13, 13, -12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(13, 13, -20));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(13, 13, -19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(15, 18, -5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(15, 18, -26));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(5, 13, -5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(5, 13, -26));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(26, 13, -5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(26, 13, -26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(5, 18, -5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(5, 18, -26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(26, 18, -5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(26, 18, -26));
                if (F3_RAND <= 5) {
                    ILLAGER_TOWER_F3_B.generateStructureRot270(world, pos.func_177981_b(24));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(10, 25, -5));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(10, 26, -5));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(8, 25, -10));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(8, 26, -10));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_MECHANICS, pos.func_177982_a(21, 26, -6));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(26, 25, -24));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(26, 25, -23));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(24, 25, -26));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(23, 25, -26));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(5, 25, -22));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(5, 25, -23));
                } else {
                    ILLAGER_TOWER_F3_C.generateStructureRot270(world, pos.func_177981_b(24));
                }
                ILLAGER_TOWER_F4_B.generateStructureRot270(world, pos.func_177981_b(36));
            }
            ILLAGER_TOWER_F5.generateStructureRot270(world, pos.func_177981_b(48));
            WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(8, 51, -15));
            WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(8, 51, -16));
            WorldGenCustomStructures.spawnIllusioner(world, pos.func_177963_a(15.5, 49.0, -15.5));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(9, 51, -14));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(9, 51, -17));
            ILLAGER_TOWER_F6.generateStructureRot270(world, pos.func_177981_b(58));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 59, -13));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(19, 59, -13));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 60, -13));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(19, 60, -13));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(21, 59, -15));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(21, 59, -16));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 59, -18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(19, 59, -18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 60, -18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(19, 60, -18));
            WorldGenCustomStructures.spawnIllagerKing(world, pos.func_177963_a(14.5, 60.0, -15.5));
        }
    }

    private void generateIllagerCentre(World world, Random random, int chunkX, int chunkZ, int chance, Block topBlock, Class<?> ... classes) {
        ArrayList classesList = new ArrayList(Arrays.asList(classes));
        int x = chunkX * 16;
        int z = chunkZ * 16;
        int y = WorldGenCustomStructures.calculateGenerationHeight(world, x, z, topBlock);
        BlockPos pos = new BlockPos(x, y, z);
        Class<?> biome = world.field_73011_w.getBiomeForCoords(pos).getClass();
        if (world.func_175624_G() != WorldType.field_77138_c && classesList.contains(biome) && random.nextInt(chance) == 0 && this.compareFloor(world, pos, 9, 10, ILLAGER_CENTRE.getStructureRotation(), topBlock)) {
            ILLAGER_CENTRE.generateStructureRotNone(world, pos);
            if (ILLAGER_CENTRE.getStructureRotation() == Rotation.NONE) {
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(15, 1, 9));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(15, 1, 10));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(9, 1, 16));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(8, 1, 16));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(2, 1, 9));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(2, 1, 10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(9, 9, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(9, 9, 10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(8, 9, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(8, 9, 10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(9, 10, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(9, 10, 10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(8, 10, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(8, 10, 10));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(7, 1, 8));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(7, 1, 11));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(10, 1, 8));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(10, 1, 11));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177963_a(8.5, 1.0, 9.5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(5, 9, 6));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(12, 9, 6));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(5, 9, 13));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(12, 9, 13));
            } else if (ILLAGER_CENTRE.getStructureRotation() == Rotation.CLOCKWISE_90) {
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-9, 1, 15));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-10, 1, 15));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-16, 1, 9));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-16, 1, 8));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-9, 1, 2));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-10, 1, 2));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-9, 9, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-10, 9, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-9, 9, 8));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-10, 9, 8));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-9, 10, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-10, 10, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-9, 10, 8));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-10, 10, 8));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-8, 1, 7));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-11, 1, 7));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-8, 1, 10));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-11, 1, 10));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177963_a(-9.5, 1.0, 8.5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-6, 9, 5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-6, 9, 12));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-13, 9, 5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-13, 9, 12));
            } else if (ILLAGER_CENTRE.getStructureRotation() == Rotation.CLOCKWISE_180) {
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-15, 1, -9));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-15, 1, -10));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-9, 1, -16));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-8, 1, -16));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-2, 1, -9));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-2, 1, -10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-9, 9, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-9, 9, -10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-8, 9, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-8, 9, -10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-9, 10, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-9, 10, -10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-8, 10, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-8, 10, -10));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-7, 1, -8));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-7, 1, -11));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-10, 1, -8));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-10, 1, -11));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177963_a(-8.5, 1.0, -9.5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-5, 9, -6));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-12, 9, -6));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-5, 9, -13));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-12, 9, -13));
            } else if (ILLAGER_CENTRE.getStructureRotation() == Rotation.COUNTERCLOCKWISE_90) {
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(9, 1, -15));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(10, 1, -15));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(16, 1, -9));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(16, 1, -8));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(9, 1, -2));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(10, 1, -2));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(9, 9, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(10, 9, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(9, 9, -8));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(10, 9, -8));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(9, 10, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(10, 10, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(9, 10, -8));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(10, 10, -8));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(8, 1, -7));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(11, 1, -7));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(8, 1, -10));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(11, 1, -10));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177963_a(9.5, 1.0, -8.5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(6, 9, -5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(6, 9, -12));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(13, 9, -5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(13, 9, -12));
            }
            this.createIllagerCentreDecor(ILLAGER_FARM, 6.0, 2.0, 6.0, world, random, pos, topBlock);
            this.createIllagerCentreDecor(ANIMAL_PEN, 4.0, 5.0, 4.0, world, random, pos, topBlock);
            this.createIllagerCentreDecor(FIREWORKS_DISPLAY, 3.0, 2.0, 4.0, world, random, pos, topBlock);
            this.createIllagerCentreDecor(FLOWER_BED, 6.0, 2.0, 3.0, world, random, pos, topBlock);
            this.createIllagerCentreDecor(ILLAGER_DUMMY_1, 3.0, 3.0, 1.0, world, random, pos, topBlock);
            this.createIllagerCentreDecor(ILLAGER_DUMMY_2, 3.0, 3.0, 2.0, world, random, pos, topBlock);
            this.createIllagerCentreDecor(ILLAGER_STORAGE, 4.0, 4.0, 4.0, world, random, pos, topBlock);
            this.createIllagerCentreDecor(ILLAGER_WELL, 4.0, 14.0, 4.0, world, random, pos, topBlock);
            this.createIllagerCentreDecor(LOG_PILE, 3.0, 3.0, 3.0, world, random, pos, topBlock);
            this.createIllagerCentreDecor(UNDYING_TOTEM, 9.0, 11.0, 3.0, world, random, pos, topBlock);
        }
    }

    private void createIllagerCentreDecor(StructureHandler handler, double xSize, double ySize, double zSize, World world, Random random, BlockPos pos, Block topBlock) {
        int x = random.nextInt(120) - 60;
        int z = random.nextInt(120) - 60;
        BlockPos decorpos = new BlockPos(pos.func_177958_n() + x, WorldGenCustomStructures.calculateGenerationHeight(world, pos.func_177958_n() + x, pos.func_177952_p() + z, topBlock), pos.func_177952_p() + z);
        AxisAlignedBB avoidanceBB = new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 28), (double)(pos.func_177956_o() + 29), (double)(pos.func_177952_p() + 29));
        this.addStructureBB(handler, new AxisAlignedBB(decorpos).func_72314_b(xSize, ySize, zSize));
        if (!this.getStructureBB(handler).func_72326_a(avoidanceBB) && world.func_180495_p(decorpos.func_177977_b()).func_185904_a() != Material.field_151586_h) {
            if (handler.structureName.equals("illager_well")) {
                handler.generateStructureRotRandom(world, random, decorpos.func_177979_c(9));
            } else if (handler.structureName.equals("animal_pen") || handler.structureName.equals("illager_farm") || handler.structureName.equals("fireworks_display")) {
                handler.generateStructureRotRandom(world, random, decorpos);
            } else {
                handler.generateStructureRotRandom(world, random, decorpos.func_177984_a());
            }
        }
    }

    private static void setLoot(World world, Random random, ResourceLocation lootTable, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityChest) {
            ((TileEntityChest)tileEntity).func_189404_a(lootTable, random.nextLong());
        } else {
            System.err.println("Unable to generate loot:[" + lootTable + "] at " + pos);
        }
    }

    private static int calculateGenerationHeight(World world, int x, int z, Block topBlock) {
        int y = world.func_72800_K();
        boolean foundGround = false;
        while (!foundGround && y-- >= world.func_181545_F() + 1) {
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = block == topBlock;
        }
        return y;
    }

    public static void genCommandStructureFeatures(ICommandSender sender, String name, String rotation, World world, BlockPos pos, Random random) {
        if (name.equals("illager_archer_tower")) {
            if (rotation.equals("rotateNone")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_ARCHER_TOWER, pos.func_177982_a(7, 8, 5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(4.5, 9.0, 4.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(4.5, 9.0, 8.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(8.5, 9.0, 8.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(8.5, 9.0, 4.5));
            } else if (rotation.equals("rotate90")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_ARCHER_TOWER, pos.func_177982_a(-5, 8, 7));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-4.5, 9.0, 4.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-8.5, 9.0, 4.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-8.5, 9.0, 8.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-4.5, 9.0, 8.5));
            } else if (rotation.equals("rotate180")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_ARCHER_TOWER, pos.func_177982_a(-7, 8, -5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-4.5, 9.0, -4.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-4.5, 9.0, -8.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-8.5, 9.0, -8.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-8.5, 9.0, -4.5));
            } else if (rotation.equals("rotate270")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_ARCHER_TOWER, pos.func_177982_a(5, 8, -7));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(4.5, 9.0, -4.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(8.5, 9.0, -4.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(8.5, 9.0, -8.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(4.5, 9.0, -8.5));
            }
        } else if (name.equals("illager_centre")) {
            if (rotation.equals("rotateNone")) {
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(15, 1, 9));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(15, 1, 10));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(9, 1, 16));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(8, 1, 16));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(2, 1, 9));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(2, 1, 10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(9, 9, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(9, 9, 10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(8, 9, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(8, 9, 10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(9, 10, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(9, 10, 10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(8, 10, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(8, 10, 10));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(7, 1, 8));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(7, 1, 11));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(10, 1, 8));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(10, 1, 11));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177963_a(8.5, 1.0, 9.5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(5, 9, 6));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(12, 9, 6));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(5, 9, 13));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(12, 9, 13));
            } else if (rotation.equals("rotate90")) {
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-9, 1, 15));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-10, 1, 15));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-16, 1, 9));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-16, 1, 8));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-9, 1, 2));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-10, 1, 2));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-9, 9, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-10, 9, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-9, 9, 8));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-10, 9, 8));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-9, 10, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-10, 10, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-9, 10, 8));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-10, 10, 8));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-8, 1, 7));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-11, 1, 7));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-8, 1, 10));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-11, 1, 10));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177963_a(-9.5, 1.0, 8.5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-6, 9, 5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-6, 9, 12));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-13, 9, 5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-13, 9, 12));
            } else if (rotation.equals("rotate180")) {
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-15, 1, -9));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-15, 1, -10));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-9, 1, -16));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-8, 1, -16));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-2, 1, -9));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-2, 1, -10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-9, 9, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-9, 9, -10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-8, 9, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-8, 9, -10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-9, 10, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-9, 10, -10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-8, 10, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(-8, 10, -10));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-7, 1, -8));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-7, 1, -11));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-10, 1, -8));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-10, 1, -11));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177963_a(-8.5, 1.0, -9.5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-5, 9, -6));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-12, 9, -6));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-5, 9, -13));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-12, 9, -13));
            } else if (rotation.equals("rotate270")) {
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(9, 1, -15));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(10, 1, -15));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(16, 1, -9));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(16, 1, -8));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(9, 1, -2));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(10, 1, -2));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(9, 9, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(10, 9, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(9, 9, -8));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(10, 9, -8));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(9, 10, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(10, 10, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(9, 10, -8));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_CENTRE, pos.func_177982_a(10, 10, -8));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(8, 1, -7));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(11, 1, -7));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(8, 1, -10));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(11, 1, -10));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177963_a(9.5, 1.0, -8.5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(6, 9, -5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(6, 9, -12));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(13, 9, -5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(13, 9, -12));
            }
        } else if (name.equals("illager_tower_f1")) {
            if (rotation.equals("rotateNone")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(9, 1, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(9, 1, 27));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(9, 2, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(9, 2, 27));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(22, 1, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(22, 1, 27));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(22, 2, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(22, 2, 27));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(13, 1, 7));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(18, 1, 7));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(11, 1, 13));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(20, 1, 13));
                WorldGenCustomStructures.spawnEnchanter(world, pos.func_177963_a(15.5, 1.0, 22.0));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(14.5, 1.0, 22.0));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(16.5, 1.0, 22.0));
            } else if (rotation.equals("rotate90")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-26, 1, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-27, 1, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-26, 2, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-27, 2, 9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-26, 1, 22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-27, 1, 22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-26, 2, 22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-27, 2, 22));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-7, 1, 13));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-7, 1, 18));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-13, 1, 11));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-13, 1, 20));
                WorldGenCustomStructures.spawnEnchanter(world, pos.func_177963_a(-22.0, 1.0, 15.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-22.0, 1.0, 14.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-22.0, 1.0, 16.5));
            } else if (rotation.equals("rotate180")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-9, 1, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-9, 1, -27));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-9, 2, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-9, 2, -27));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-22, 1, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-22, 1, -27));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-22, 2, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-22, 2, -27));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-13, 1, -7));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-18, 1, -7));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-11, 1, -13));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-20, 1, -13));
                WorldGenCustomStructures.spawnEnchanter(world, pos.func_177963_a(-15.5, 1.0, -22.0));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-14.5, 1.0, -22.0));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-16.5, 1.0, -22.0));
            } else if (rotation.equals("rotate270")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(26, 1, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(27, 1, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(26, 2, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(27, 2, -9));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(26, 1, -22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(27, 1, -22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(26, 2, -22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(27, 2, -22));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(7, 1, -13));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(7, 1, -18));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(13, 1, -11));
                WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(13, 1, -20));
                WorldGenCustomStructures.spawnEnchanter(world, pos.func_177963_a(22.0, 1.0, -15.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(22.0, 1.0, -14.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(22.0, 1.0, -16.5));
            }
        } else if (name.equals("illager_tower_f2_a")) {
            if (rotation.equals("rotateNone")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 13, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(25, 13, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(23, 13, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(22, 13, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 14, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(25, 14, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(23, 14, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(22, 14, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 15, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(25, 15, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(23, 15, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(22, 15, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 16, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(25, 16, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(23, 16, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(22, 16, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(26, 13, 5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(20, 13, 7));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(20, 13, 8));
                WorldGenCustomStructures.spawnHoarder(world, pos.func_177963_a(23.0, 13.0, 7.5));
                WorldGenCustomStructures.spawnNecromancer(world, pos.func_177982_a(24, 13, 23));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177982_a(13, 13, 9));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(17, 18, 9));
            } else if (rotation.equals("rotate90")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 13, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 13, 25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 13, 23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 13, 22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 14, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 14, 25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 14, 23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 14, 22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 15, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 15, 25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 15, 23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 15, 22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 16, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 16, 25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 16, 23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 16, 22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(-5, 13, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(-7, 13, 20));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(-8, 13, 20));
                WorldGenCustomStructures.spawnHoarder(world, pos.func_177963_a(-7.5, 13.0, 23.0));
                WorldGenCustomStructures.spawnNecromancer(world, pos.func_177982_a(-23, 13, 24));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177982_a(-9, 13, 13));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-9, 18, 17));
            } else if (rotation.equals("rotate180")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 13, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-25, 13, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-23, 13, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-22, 13, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 14, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-25, 14, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-23, 14, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-22, 14, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 15, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-25, 15, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-23, 15, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-22, 15, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 16, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-25, 16, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-23, 16, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-22, 16, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(-26, 13, -5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(-20, 13, -7));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(-20, 13, -8));
                WorldGenCustomStructures.spawnHoarder(world, pos.func_177963_a(-23.0, 13.0, -7.5));
                WorldGenCustomStructures.spawnNecromancer(world, pos.func_177982_a(-24, 13, -23));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177982_a(-13, 13, -9));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-17, 18, -9));
            } else if (rotation.equals("rotate270")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 13, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 13, -25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 13, -23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 13, -22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 14, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 14, -25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 14, -23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 14, -22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 15, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 15, -25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 15, -23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 15, -22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 16, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 16, -25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 16, -23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 16, -22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(5, 13, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(7, 13, -20));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(8, 13, -20));
                WorldGenCustomStructures.spawnHoarder(world, pos.func_177963_a(7.5, 13.0, -23.0));
                WorldGenCustomStructures.spawnNecromancer(world, pos.func_177982_a(23, 13, -24));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177982_a(9, 13, -13));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(9, 18, -17));
            }
        } else if (name.equals("illager_tower_f2_b")) {
            if (rotation.equals("rotateNone")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(15, 13, 5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(16, 13, 5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(11, 13, 13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(12, 13, 13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(20, 13, 13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(19, 13, 13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(5, 18, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 18, 15));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(5, 13, 5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(26, 13, 5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(5, 13, 26));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(26, 13, 26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(5, 18, 5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(26, 18, 5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(5, 18, 26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(26, 18, 26));
            } else if (rotation.equals("rotate90")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-5, 13, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-5, 13, 16));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-13, 13, 11));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-13, 13, 12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-13, 13, 20));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-13, 13, 19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-15, 18, 5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-15, 18, 26));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-5, 13, 5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-5, 13, 26));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-26, 13, 5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-26, 13, 26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-5, 18, 5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-5, 18, 26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-26, 18, 5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-26, 18, 26));
            } else if (rotation.equals("rotate180")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-15, 13, -5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-16, 13, -5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-11, 13, -13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-12, 13, -13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-20, 13, -13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-19, 13, -13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-5, 18, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 18, -15));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-5, 13, -5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-26, 13, -5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-5, 13, -26));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-26, 13, -26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-5, 18, -5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-26, 18, -5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-5, 18, -26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-26, 18, -26));
            } else if (rotation.equals("rotate270")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(5, 13, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(5, 13, -16));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(13, 13, -11));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(13, 13, -12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(13, 13, -20));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(13, 13, -19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(15, 18, -5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(15, 18, -26));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(5, 13, -5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(5, 13, -26));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(26, 13, -5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(26, 13, -26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(5, 18, -5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(5, 18, -26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(26, 18, -5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(26, 18, -26));
            }
        } else if (name.equals("illager_tower_f3_a")) {
            if (rotation.equals("rotateNone")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TREES, pos.func_177982_a(23, 25, 16));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(11, 25, 7));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TNT_TRAP, pos.func_177982_a(24, 30, 24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(15, 30, 18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(15, 30, 19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(18, 30, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(19, 30, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(8, 30, 7));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(13, 25, 7));
                WorldGenCustomStructures.spawnEnchanter(world, pos.func_177982_a(10, 25, 17));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(13, 30, 14));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(14, 30, 13));
            } else if (rotation.equals("rotate90")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TREES, pos.func_177982_a(-16, 25, 23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-7, 25, 11));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TNT_TRAP, pos.func_177982_a(-24, 30, 24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-18, 30, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-19, 30, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-15, 30, 18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-15, 30, 19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-7, 30, 8));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-7, 25, 13));
                WorldGenCustomStructures.spawnEnchanter(world, pos.func_177982_a(-17, 25, 10));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-14, 30, 13));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-13, 30, 14));
            } else if (rotation.equals("rotate180")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TREES, pos.func_177982_a(-23, 25, -16));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-11, 25, -7));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TNT_TRAP, pos.func_177982_a(-24, 30, -24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-15, 30, -18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-15, 30, -19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-18, 30, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-19, 30, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-8, 30, -7));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-13, 25, -7));
                WorldGenCustomStructures.spawnEnchanter(world, pos.func_177982_a(-10, 25, -17));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-13, 30, -14));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-14, 30, -13));
            } else if (rotation.equals("rotate270")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TREES, pos.func_177982_a(16, 25, -23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(7, 25, -11));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TNT_TRAP, pos.func_177982_a(24, 30, -24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(18, 30, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(19, 30, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(15, 30, -18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(15, 30, -19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(7, 30, -8));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(7, 25, -13));
                WorldGenCustomStructures.spawnEnchanter(world, pos.func_177982_a(17, 25, -10));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(14, 30, -13));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(13, 30, -14));
            }
        } else if (name.equals("illager_tower_f3_b")) {
            if (rotation.equals("rotateNone")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(5, 25, 10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(5, 26, 10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(10, 25, 8));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(10, 26, 8));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_MECHANICS, pos.func_177982_a(6, 26, 21));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(24, 25, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(23, 25, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(26, 25, 24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(26, 25, 23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(22, 25, 5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(23, 25, 5));
            } else if (rotation.equals("rotate90")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-10, 25, 5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-10, 26, 5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-8, 25, 10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-8, 26, 10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_MECHANICS, pos.func_177982_a(-21, 26, 6));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-26, 25, 24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-26, 25, 23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-24, 25, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-23, 25, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(-5, 25, 22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(-5, 25, 23));
            } else if (rotation.equals("rotate180")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-5, 25, -10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-5, 26, -10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-10, 25, -8));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-10, 26, -8));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_MECHANICS, pos.func_177982_a(-6, 26, -21));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-24, 25, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-23, 25, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-26, 25, -24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-26, 25, -23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(-22, 25, -5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(-23, 25, -5));
            } else if (rotation.equals("rotate270")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(10, 25, -5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(10, 26, -5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(8, 25, -10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(8, 26, -10));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_MECHANICS, pos.func_177982_a(21, 26, -6));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(26, 25, -24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(26, 25, -23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(24, 25, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(23, 25, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(5, 25, -22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(5, 25, -23));
            }
        } else if (name.equals("illager_tower_f5")) {
            if (rotation.equals("rotateNone")) {
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(15, 51, 8));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(16, 51, 8));
                WorldGenCustomStructures.spawnIllusioner(world, pos.func_177963_a(15.5, 49.0, 15.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(14, 51, 9));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(17, 51, 9));
            } else if (rotation.equals("rotate90")) {
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-8, 51, 15));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-8, 51, 16));
                WorldGenCustomStructures.spawnIllusioner(world, pos.func_177963_a(-15.5, 49.0, 15.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-9, 51, 14));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-9, 51, 17));
            } else if (rotation.equals("rotate180")) {
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-15, 51, -8));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-16, 51, -8));
                WorldGenCustomStructures.spawnIllusioner(world, pos.func_177963_a(-15.5, 49.0, -15.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-14, 51, -9));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-17, 51, -9));
            } else if (rotation.equals("rotate270")) {
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(8, 51, -15));
                WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(8, 51, -16));
                WorldGenCustomStructures.spawnIllusioner(world, pos.func_177963_a(15.5, 49.0, -15.5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(9, 51, -14));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(9, 51, -17));
            }
        } else if (name.equals("illager_tower_f6")) {
            if (rotation.equals("rotateNone")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(13, 59, 18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(13, 59, 19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(13, 60, 18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(13, 60, 19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(15, 59, 21));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(16, 59, 21));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 59, 18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 59, 19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 60, 18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 60, 19));
                WorldGenCustomStructures.spawnIllagerKing(world, pos.func_177963_a(15.5, 60.0, 14.5));
            } else if (rotation.equals("rotate90")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 59, 13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-19, 59, 13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 60, 13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-19, 60, 13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-21, 59, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-21, 59, 16));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 59, 18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-19, 59, 18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 60, 18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-19, 60, 18));
                WorldGenCustomStructures.spawnIllagerKing(world, pos.func_177963_a(-14.5, 60.0, 15.5));
            } else if (rotation.equals("rotate180")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-13, 59, -18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-13, 59, -19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-13, 60, -18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-13, 60, -19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-15, 59, -21));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-16, 59, -21));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 59, -18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 59, -19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 60, -18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 60, -19));
                WorldGenCustomStructures.spawnIllagerKing(world, pos.func_177963_a(-15.5, 60.0, -14.5));
            } else if (rotation.equals("rotate270")) {
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 59, -13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(19, 59, -13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 60, -13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(19, 60, -13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(21, 59, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(21, 59, -16));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 59, -18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(19, 59, -18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 60, -18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(19, 60, -18));
                WorldGenCustomStructures.spawnIllagerKing(world, pos.func_177963_a(14.5, 60.0, -15.5));
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "[ERROR:] " + name + " does not have any loot/entities."));
        }
    }

    public static void genCommandIllagerTower(World world, Random random, BlockPos pos, String rotation) {
        Random random1 = new Random();
        int F2_RAND = random.nextInt(10);
        int F3_RAND = random1.nextInt(10);
        if (rotation.equals("rotateNone")) {
            ILLAGER_TOWER_F1.generateStructureRotNone(world, pos);
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(9, 1, 26));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(9, 1, 27));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(9, 2, 26));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(9, 2, 27));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(22, 1, 26));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(22, 1, 27));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(22, 2, 26));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(22, 2, 27));
            WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(13, 1, 7));
            WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(18, 1, 7));
            WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(11, 1, 13));
            WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(20, 1, 13));
            WorldGenCustomStructures.spawnEnchanter(world, pos.func_177963_a(15.5, 1.0, 22.0));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(14.5, 1.0, 22.0));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(16.5, 1.0, 22.0));
            if (F2_RAND <= 5) {
                ILLAGER_TOWER_F2_A.generateStructureRotNone(world, pos.func_177981_b(12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 13, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(25, 13, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(23, 13, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(22, 13, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 14, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(25, 14, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(23, 14, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(22, 14, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 15, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(25, 15, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(23, 15, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(22, 15, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 16, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(25, 16, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(23, 16, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(22, 16, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(26, 13, 5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(20, 13, 7));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(20, 13, 8));
                WorldGenCustomStructures.spawnHoarder(world, pos.func_177963_a(23.0, 13.0, 7.5));
                WorldGenCustomStructures.spawnNecromancer(world, pos.func_177982_a(24, 13, 23));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177982_a(13, 13, 9));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(17, 18, 9));
                ILLAGER_TOWER_F3_A.generateStructureRotNone(world, pos.func_177981_b(24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TREES, pos.func_177982_a(23, 25, 16));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(11, 25, 7));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TNT_TRAP, pos.func_177982_a(24, 30, 24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(15, 30, 18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(15, 30, 19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(18, 30, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(19, 30, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(8, 30, 7));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(13, 25, 7));
                WorldGenCustomStructures.spawnEnchanter(world, pos.func_177982_a(10, 25, 17));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(13, 30, 14));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(14, 30, 13));
                ILLAGER_TOWER_F4_A.generateStructureRotNone(world, pos.func_177981_b(36));
            } else {
                ILLAGER_TOWER_F2_B.generateStructureRotNone(world, pos.func_177981_b(12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(15, 13, 5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(16, 13, 5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(11, 13, 13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(12, 13, 13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(20, 13, 13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(19, 13, 13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(5, 18, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 18, 15));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(5, 13, 5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(26, 13, 5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(5, 13, 26));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(26, 13, 26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(5, 18, 5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(26, 18, 5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(5, 18, 26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(26, 18, 26));
                if (F3_RAND <= 5) {
                    ILLAGER_TOWER_F3_B.generateStructureRotNone(world, pos.func_177981_b(24));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(5, 25, 10));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(5, 26, 10));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(10, 25, 8));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(10, 26, 8));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_MECHANICS, pos.func_177982_a(6, 26, 21));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(24, 25, 26));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(23, 25, 26));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(26, 25, 24));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(26, 25, 23));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(22, 25, 5));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(23, 25, 5));
                } else {
                    ILLAGER_TOWER_F3_C.generateStructureRotNone(world, pos.func_177981_b(24));
                }
                ILLAGER_TOWER_F4_B.generateStructureRotNone(world, pos.func_177981_b(36));
            }
            ILLAGER_TOWER_F5.generateStructureRotNone(world, pos.func_177981_b(48));
            WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(15, 51, 8));
            WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(16, 51, 8));
            WorldGenCustomStructures.spawnIllusioner(world, pos.func_177963_a(15.5, 49.0, 15.5));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(14, 51, 9));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(17, 51, 9));
            ILLAGER_TOWER_F6.generateStructureRotNone(world, pos.func_177981_b(58));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(13, 59, 18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(13, 59, 19));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(13, 60, 18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(13, 60, 19));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(15, 59, 21));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(16, 59, 21));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 59, 18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 59, 19));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 60, 18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 60, 19));
            WorldGenCustomStructures.spawnIllagerKing(world, pos.func_177963_a(15.5, 60.0, 14.5));
        }
        if (rotation.equals("rotate90")) {
            ILLAGER_TOWER_F1.generateStructureRot90(world, pos);
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-26, 1, 9));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-27, 1, 9));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-26, 2, 9));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-27, 2, 9));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-26, 1, 22));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-27, 1, 22));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-26, 2, 22));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-27, 2, 22));
            WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-7, 1, 13));
            WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-7, 1, 18));
            WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-13, 1, 11));
            WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-13, 1, 20));
            WorldGenCustomStructures.spawnEnchanter(world, pos.func_177963_a(-22.0, 1.0, 15.5));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-22.0, 1.0, 14.5));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-22.0, 1.0, 16.5));
            if (F2_RAND <= 5) {
                ILLAGER_TOWER_F2_A.generateStructureRot90(world, pos.func_177981_b(12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 13, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 13, 25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 13, 23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 13, 22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 14, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 14, 25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 14, 23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 14, 22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 15, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 15, 25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 15, 23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 15, 22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 16, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 16, 25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 16, 23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 16, 22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(-5, 13, 26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(-7, 13, 20));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(-8, 13, 20));
                WorldGenCustomStructures.spawnHoarder(world, pos.func_177963_a(-7.5, 13.0, 23.0));
                WorldGenCustomStructures.spawnNecromancer(world, pos.func_177982_a(-23, 13, 24));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177982_a(-9, 13, 13));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-9, 18, 17));
                ILLAGER_TOWER_F3_A.generateStructureRot90(world, pos.func_177981_b(24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TREES, pos.func_177982_a(-16, 25, 23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-7, 25, 11));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TNT_TRAP, pos.func_177982_a(-24, 30, 24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-18, 30, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-19, 30, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-15, 30, 18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-15, 30, 19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-7, 30, 8));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-7, 25, 13));
                WorldGenCustomStructures.spawnEnchanter(world, pos.func_177982_a(-17, 25, 10));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-14, 30, 13));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-13, 30, 14));
                ILLAGER_TOWER_F4_A.generateStructureRot90(world, pos.func_177981_b(36));
            } else {
                ILLAGER_TOWER_F2_B.generateStructureRot90(world, pos.func_177981_b(12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-5, 13, 15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-5, 13, 16));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-13, 13, 11));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-13, 13, 12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-13, 13, 20));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-13, 13, 19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-15, 18, 5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-15, 18, 26));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-5, 13, 5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-5, 13, 26));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-26, 13, 5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-26, 13, 26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-5, 18, 5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-5, 18, 26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-26, 18, 5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-26, 18, 26));
                if (F3_RAND <= 5) {
                    ILLAGER_TOWER_F3_B.generateStructureRot90(world, pos.func_177981_b(24));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-10, 25, 5));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-10, 26, 5));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-8, 25, 10));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-8, 26, 10));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_MECHANICS, pos.func_177982_a(-21, 26, 6));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-26, 25, 24));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-26, 25, 23));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-24, 25, 26));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-23, 25, 26));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(-5, 25, 22));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(-5, 25, 23));
                } else {
                    ILLAGER_TOWER_F3_C.generateStructureRot90(world, pos.func_177981_b(24));
                }
                ILLAGER_TOWER_F4_B.generateStructureRot90(world, pos.func_177981_b(36));
            }
            ILLAGER_TOWER_F5.generateStructureRot90(world, pos.func_177981_b(48));
            WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-8, 51, 15));
            WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-8, 51, 16));
            WorldGenCustomStructures.spawnIllusioner(world, pos.func_177963_a(-15.5, 49.0, 15.5));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-9, 51, 14));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-9, 51, 17));
            ILLAGER_TOWER_F6.generateStructureRot90(world, pos.func_177981_b(58));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 59, 13));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-19, 59, 13));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 60, 13));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-19, 60, 13));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-21, 59, 15));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-21, 59, 16));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 59, 18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-19, 59, 18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 60, 18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-19, 60, 18));
            WorldGenCustomStructures.spawnIllagerKing(world, pos.func_177963_a(-14.5, 60.0, 15.5));
        }
        if (rotation.equals("rotate180")) {
            ILLAGER_TOWER_F1.generateStructureRot180(world, pos);
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-9, 1, -26));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-9, 1, -27));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-9, 2, -26));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-9, 2, -27));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-22, 1, -26));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-22, 1, -27));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-22, 2, -26));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-22, 2, -27));
            WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-13, 1, -7));
            WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-18, 1, -7));
            WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-11, 1, -13));
            WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(-20, 1, -13));
            WorldGenCustomStructures.spawnEnchanter(world, pos.func_177963_a(-15.5, 1.0, -22.0));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-14.5, 1.0, -22.0));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(-16.5, 1.0, -22.0));
            if (F2_RAND <= 5) {
                ILLAGER_TOWER_F2_A.generateStructureRot180(world, pos.func_177981_b(12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 13, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-25, 13, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-23, 13, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-22, 13, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 14, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-25, 14, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-23, 14, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-22, 14, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 15, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-25, 15, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-23, 15, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-22, 15, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 16, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-25, 16, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-23, 16, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-22, 16, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(-26, 13, -5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(-20, 13, -7));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(-20, 13, -8));
                WorldGenCustomStructures.spawnHoarder(world, pos.func_177963_a(-23.0, 13.0, -7.5));
                WorldGenCustomStructures.spawnNecromancer(world, pos.func_177982_a(-24, 13, -23));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177982_a(-13, 13, -9));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-17, 18, -9));
                ILLAGER_TOWER_F3_A.generateStructureRot180(world, pos.func_177981_b(24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TREES, pos.func_177982_a(-23, 25, -16));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-11, 25, -7));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TNT_TRAP, pos.func_177982_a(-24, 30, -24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-15, 30, -18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-15, 30, -19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-18, 30, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-19, 30, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-8, 30, -7));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-13, 25, -7));
                WorldGenCustomStructures.spawnEnchanter(world, pos.func_177982_a(-10, 25, -17));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-13, 30, -14));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-14, 30, -13));
                ILLAGER_TOWER_F4_A.generateStructureRot180(world, pos.func_177981_b(36));
            } else {
                ILLAGER_TOWER_F2_B.generateStructureRot180(world, pos.func_177981_b(12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-15, 13, -5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-16, 13, -5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-11, 13, -13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-12, 13, -13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-20, 13, -13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(-19, 13, -13));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-5, 18, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(-26, 18, -15));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-5, 13, -5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-26, 13, -5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-5, 13, -26));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(-26, 13, -26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-5, 18, -5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-26, 18, -5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-5, 18, -26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-26, 18, -26));
                if (F3_RAND <= 5) {
                    ILLAGER_TOWER_F3_B.generateStructureRot180(world, pos.func_177981_b(24));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-5, 25, -10));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-5, 26, -10));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-10, 25, -8));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(-10, 26, -8));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_MECHANICS, pos.func_177982_a(-6, 26, -21));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-24, 25, -26));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-23, 25, -26));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-26, 25, -24));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(-26, 25, -23));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(-22, 25, -5));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(-23, 25, -5));
                } else {
                    ILLAGER_TOWER_F3_C.generateStructureRot180(world, pos.func_177981_b(24));
                }
                ILLAGER_TOWER_F4_B.generateStructureRot180(world, pos.func_177981_b(36));
            }
            ILLAGER_TOWER_F5.generateStructureRot180(world, pos.func_177981_b(48));
            WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-15, 51, -8));
            WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(-16, 51, -8));
            WorldGenCustomStructures.spawnIllusioner(world, pos.func_177963_a(-15.5, 49.0, -15.5));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-14, 51, -9));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(-17, 51, -9));
            ILLAGER_TOWER_F6.generateStructureRot180(world, pos.func_177981_b(58));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-13, 59, -18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-13, 59, -19));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-13, 60, -18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-13, 60, -19));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-15, 59, -21));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-16, 59, -21));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 59, -18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 59, -19));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 60, -18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(-18, 60, -19));
            WorldGenCustomStructures.spawnIllagerKing(world, pos.func_177963_a(-15.5, 60.0, -14.5));
        }
        if (rotation.equals("rotate270")) {
            ILLAGER_TOWER_F1.generateStructureRot270(world, pos);
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(26, 1, -9));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(27, 1, -9));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(26, 2, -9));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(27, 2, -9));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(26, 1, -22));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(27, 1, -22));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(26, 2, -22));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(27, 2, -22));
            WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(7, 1, -13));
            WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(7, 1, -18));
            WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(13, 1, -11));
            WorldGenCustomStructures.spawnFurantur(world, pos.func_177982_a(13, 1, -20));
            WorldGenCustomStructures.spawnEnchanter(world, pos.func_177963_a(22.0, 1.0, -15.5));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(22.0, 1.0, -14.5));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177963_a(22.0, 1.0, -16.5));
            if (F2_RAND <= 5) {
                ILLAGER_TOWER_F2_A.generateStructureRot270(world, pos.func_177981_b(12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 13, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 13, -25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 13, -23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 13, -22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 14, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 14, -25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 14, -23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 14, -22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 15, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 15, -25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 15, -23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 15, -22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 16, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 16, -25));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 16, -23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(26, 16, -22));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(5, 13, -26));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(7, 13, -20));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RESEARCHER, pos.func_177982_a(8, 13, -20));
                WorldGenCustomStructures.spawnHoarder(world, pos.func_177963_a(7.5, 13.0, -23.0));
                WorldGenCustomStructures.spawnNecromancer(world, pos.func_177982_a(23, 13, -24));
                WorldGenCustomStructures.spawnEvoker(world, pos.func_177982_a(9, 13, -13));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(9, 18, -17));
                ILLAGER_TOWER_F3_A.generateStructureRot270(world, pos.func_177981_b(24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TREES, pos.func_177982_a(16, 25, -23));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(7, 25, -11));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_TNT_TRAP, pos.func_177982_a(24, 30, -24));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(18, 30, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(19, 30, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(15, 30, -18));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(15, 30, -19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(7, 30, -8));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(7, 25, -13));
                WorldGenCustomStructures.spawnEnchanter(world, pos.func_177982_a(17, 25, -10));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(14, 30, -13));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(13, 30, -14));
                ILLAGER_TOWER_F4_A.generateStructureRot270(world, pos.func_177981_b(36));
            } else {
                ILLAGER_TOWER_F2_B.generateStructureRot270(world, pos.func_177981_b(12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(5, 13, -15));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(5, 13, -16));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(13, 13, -11));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(13, 13, -12));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(13, 13, -20));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_COMMON, pos.func_177982_a(13, 13, -19));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(15, 18, -5));
                WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_UNCOMMON, pos.func_177982_a(15, 18, -26));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(5, 13, -5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(5, 13, -26));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(26, 13, -5));
                WorldGenCustomStructures.spawnVindicator(world, pos.func_177982_a(26, 13, -26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(5, 18, -5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(5, 18, -26));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(26, 18, -5));
                WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(26, 18, -26));
                if (F3_RAND <= 5) {
                    ILLAGER_TOWER_F3_B.generateStructureRot270(world, pos.func_177981_b(24));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(10, 25, -5));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(10, 26, -5));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(8, 25, -10));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_FARMS, pos.func_177982_a(8, 26, -10));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_MECHANICS, pos.func_177982_a(21, 26, -6));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(26, 25, -24));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(26, 25, -23));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(24, 25, -26));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_ARMORY, pos.func_177982_a(23, 25, -26));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(5, 25, -22));
                    WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_ROOM_BREWERY, pos.func_177982_a(5, 25, -23));
                } else {
                    ILLAGER_TOWER_F3_C.generateStructureRot270(world, pos.func_177981_b(24));
                }
                ILLAGER_TOWER_F4_B.generateStructureRot270(world, pos.func_177981_b(36));
            }
            ILLAGER_TOWER_F5.generateStructureRot270(world, pos.func_177981_b(48));
            WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(8, 51, -15));
            WorldGenCustomStructures.setLoot(world, random, LootTableList.field_186422_d, pos.func_177982_a(8, 51, -16));
            WorldGenCustomStructures.spawnIllusioner(world, pos.func_177963_a(15.5, 49.0, -15.5));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(9, 51, -14));
            WorldGenCustomStructures.spawnArcher(world, pos.func_177982_a(9, 51, -17));
            ILLAGER_TOWER_F6.generateStructureRot270(world, pos.func_177981_b(58));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 59, -13));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(19, 59, -13));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 60, -13));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(19, 60, -13));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(21, 59, -15));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(21, 59, -16));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 59, -18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(19, 59, -18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(18, 60, -18));
            WorldGenCustomStructures.setLoot(world, random, IllagerPlusLootTable.ILLAGER_TOWER_RARE, pos.func_177982_a(19, 60, -18));
            WorldGenCustomStructures.spawnIllagerKing(world, pos.func_177963_a(14.5, 60.0, -15.5));
        }
    }
}

