/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import twistedgate.immersiveposts.IPOConfig;
import twistedgate.immersiveposts.ImmersivePosts;
import twistedgate.immersiveposts.common.blocks.BlockMetalFence;
import twistedgate.immersiveposts.common.blocks.BlockPost;
import twistedgate.immersiveposts.common.blocks.BlockPostBase;
import twistedgate.immersiveposts.common.items.MetalRods;
import twistedgate.immersiveposts.common.items.MultiMetaItem;
import twistedgate.immersiveposts.enums.EnumPostMaterial;
import twistedgate.immersiveposts.utils.StringUtils;

@Mod.EventBusSubscriber(modid="immersiveposts")
public class IPOStuff {
    public static final ArrayList<Block> BLOCKS = new ArrayList();
    public static final ArrayList<Item> ITEMS = new ArrayList();
    public static BlockPostBase postBase;
    public static BlockFence ironFence;
    public static BlockFence goldFence;
    public static BlockFence copperFence;
    public static BlockFence leadFence;
    public static BlockFence silverFence;
    public static BlockFence nickelFence;
    public static BlockFence constantanFence;
    public static BlockFence electrumFence;
    public static BlockFence uraniumFence;
    public static BlockPost woodPost;
    public static BlockPost ironPost;
    public static BlockPost goldPost;
    public static BlockPost copperPost;
    public static BlockPost leadPost;
    public static BlockPost silverPost;
    public static BlockPost nickelPost;
    public static BlockPost constantanPost;
    public static BlockPost electrumPost;
    public static BlockPost uraniumPost;
    public static BlockPost netherPost;
    public static BlockPost aluminiumPost;
    public static BlockPost steelPost;
    public static BlockPost concretePost;
    public static BlockPost leadedConcretePost;
    public static MultiMetaItem metalRods;

    public static final void initBlocks() {
        postBase = new BlockPostBase();
        ironFence = IPOStuff.createFence("fence_iron");
        goldFence = IPOStuff.createFence("fence_gold");
        copperFence = IPOStuff.createFence("fence_copper");
        leadFence = IPOStuff.createFence("fence_lead");
        silverFence = IPOStuff.createFence("fence_silver");
        nickelFence = IPOStuff.createFence("fence_nickel");
        constantanFence = IPOStuff.createFence("fence_constantan");
        electrumFence = IPOStuff.createFence("fence_electrum");
        uraniumFence = IPOStuff.createFence("fence_uranium");
        woodPost = new BlockPost(Material.field_151575_d, EnumPostMaterial.WOOD);
        ironPost = IPOStuff.createMetalPost(EnumPostMaterial.IRON);
        goldPost = IPOStuff.createMetalPost(EnumPostMaterial.GOLD);
        copperPost = IPOStuff.createMetalPost(EnumPostMaterial.COPPER);
        leadPost = IPOStuff.createMetalPost(EnumPostMaterial.LEAD);
        silverPost = IPOStuff.createMetalPost(EnumPostMaterial.SILVER);
        nickelPost = IPOStuff.createMetalPost(EnumPostMaterial.NICKEL);
        constantanPost = IPOStuff.createMetalPost(EnumPostMaterial.CONSTANTAN);
        electrumPost = IPOStuff.createMetalPost(EnumPostMaterial.ELECTRUM);
        uraniumPost = IPOStuff.createMetalPost(EnumPostMaterial.URANIUM);
        netherPost = IPOStuff.createRockyPost(EnumPostMaterial.NETHERBRICK);
        aluminiumPost = IPOStuff.createMetalPost(EnumPostMaterial.ALUMINIUM);
        steelPost = IPOStuff.createMetalPost(EnumPostMaterial.STEEL);
        concretePost = IPOStuff.createRockyPost(EnumPostMaterial.CONCRETE);
        leadedConcretePost = IPOStuff.createRockyPost(EnumPostMaterial.CONCRETE_LEADED);
        metalRods = new MetalRods();
    }

    private static BlockPost createMetalPost(EnumPostMaterial postMat) {
        return new BlockPost(Material.field_151573_f, postMat);
    }

    private static BlockPost createRockyPost(EnumPostMaterial postMat) {
        return new BlockPost(Material.field_151576_e, postMat);
    }

    private static BlockFence createFence(String name) {
        return new BlockMetalFence(name);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : BLOCKS) {
            if (block instanceof BlockPost && !IPOConfig.isEnabled(((BlockPost)block).getPostMaterial())) {
                ImmersivePosts.log.info("Block-Registration of {}-Post skipped.", (Object)((BlockPost)block).getPostMaterial());
                continue;
            }
            if (block instanceof BlockMetalFence) {
                boolean skip = false;
                for (EnumPostMaterial m : EnumPostMaterial.values()) {
                    if (block != m.getBlock() || IPOConfig.isEnabled(m)) continue;
                    ImmersivePosts.log.info("Block-Registration of {}-Fence skipped.", (Object)m);
                    skip = true;
                    break;
                }
                if (skip) continue;
            }
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ImmersivePosts.log.info("Registering Recipes.");
        ComparableItemStack compMoldRod = ApiUtils.createComparableItemStack((ItemStack)new ItemStack((Item)IEContent.itemMold, 1, 2), (boolean)false);
        block3: for (EnumPostMaterial m : EnumPostMaterial.values()) {
            switch (m) {
                case WOOD: 
                case NETHERBRICK: 
                case ALUMINIUM: 
                case STEEL: 
                case CONCRETE: 
                case CONCRETE_LEADED: {
                    continue block3;
                }
                default: {
                    if (!IPOConfig.isEnabled(m)) continue block3;
                    String ogName = m.toString().toLowerCase(Locale.ENGLISH);
                    String oreName = StringUtils.upperCaseFirst(ogName);
                    int meta = -1;
                    for (int i = 0; i < metalRods.getSubItemCount(); ++i) {
                        if (!metalRods.getName(i).equals("stick_" + ogName)) continue;
                        meta = i;
                        break;
                    }
                    IPOStuff.voidRegDynOreRecipe(event, "fence_" + ogName, new ItemStack(m.getBlock()), "ISI", "ISI", Character.valueOf('S'), "stick" + oreName, Character.valueOf('I'), "ingot" + oreName);
                    if (meta != -1 && m != EnumPostMaterial.IRON) {
                        IPOStuff.voidRegDynOreRecipe(event, "metal_rods/stick_" + ogName, new ItemStack((Item)metalRods, 4, meta), "I", "I", Character.valueOf('I'), "ingot" + oreName);
                    }
                    if (m == EnumPostMaterial.IRON) continue block3;
                    MetalPressRecipe.addRecipe((ItemStack)Utils.copyStackWithAmount((ItemStack)IEApi.getPreferredOreStack((String)("stick" + oreName)), (int)2), (Object)("ingot" + oreName), (ComparableItemStack)compMoldRod, (int)2400);
                }
            }
        }
    }

    private static void voidRegDynOreRecipe(RegistryEvent.Register<IRecipe> event, String name, ItemStack output, Object ... params) {
        ResourceLocation group = new ResourceLocation("immersiveposts", "recipes");
        ResourceLocation regName = new ResourceLocation("immersiveposts", "recipes/" + name);
        event.getRegistry().register(new ShapedOreRecipe(group, output, params).setRegistryName(regName));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : ITEMS) {
            if (item instanceof ItemBlock) {
                boolean skip = false;
                for (EnumPostMaterial m : EnumPostMaterial.values()) {
                    if (((ItemBlock)item).func_179223_d() != m.getBlock() || IPOConfig.isEnabled(m)) continue;
                    ImmersivePosts.log.info("Item-Registration of {}-Fence skipped.", (Object)m);
                    skip = true;
                    break;
                }
                if (skip) continue;
            }
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        IPOStuff.registerFenceOres();
        IPOStuff.registerStickOres();
    }

    private static void registerFenceOres() {
        String prefix = "fence";
        block3: for (EnumPostMaterial mat : EnumPostMaterial.values()) {
            switch (mat) {
                case WOOD: 
                case NETHERBRICK: 
                case ALUMINIUM: 
                case STEEL: {
                    continue block3;
                }
                default: {
                    if (IPOConfig.isEnabled(mat)) {
                        OreDictionary.registerOre((String)(prefix + StringUtils.upperCaseFirst(mat.toString())), (Block)mat.getBlock());
                        continue block3;
                    }
                    ImmersivePosts.log.info("Ore-Registration of {}-Fence skipped.", (Object)mat.toString());
                }
            }
        }
    }

    private static void registerStickOres() {
        String prefix = "stick";
        String rep = "stick_";
        for (Item item : ITEMS) {
            if (!(item instanceof MetalRods)) continue;
            MultiMetaItem mItem = (MultiMetaItem)item;
            for (int i = 0; i < mItem.getSubItemCount(); ++i) {
                String name = mItem.getName(i).substring(rep.length());
                if (mItem.getName(i).contains(rep) && IPOConfig.isEnabled(EnumPostMaterial.valueOf(name.toUpperCase(Locale.ENGLISH)))) {
                    String oreName = prefix + StringUtils.upperCaseFirst(name);
                    OreDictionary.registerOre((String)oreName, (ItemStack)new ItemStack((Item)mItem, 1, i));
                    continue;
                }
                ImmersivePosts.log.info("Ore-Registration of {}-Rod skipped.", (Object)name);
            }
        }
    }
}

