/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedbackpacks.inventory.containers;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import invtweaks.api.container.ChestContainer;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.poopycoders.improvedbackpacks.ImprovedBackpacks;
import ru.poopycoders.improvedbackpacks.init.ModItems;
import ru.poopycoders.improvedbackpacks.inventory.InventoryBackpack;
import ru.poopycoders.improvedbackpacks.inventory.containers.slots.SlotBackpack;
import ru.poopycoders.improvedbackpacks.items.ItemBackpack;
import ru.poopycoders.improvedbackpacks.utils.NBTUtils;

@ChestContainer
public class ContainerBackpack
extends Container {
    public static final int SLOT_HAND = 0;
    public static final int SLOT_OFFHAND = 1;
    public static final int SLOT_CHESTPLATE = 2;
    public static final int SLOT_BAUBLE = 3;
    private int slot;
    private final InventoryBackpack backpackInventory;
    private boolean needSave;

    public ContainerBackpack(EntityPlayer player, InventoryBackpack backpackInventory, int slot) {
        this.backpackInventory = backpackInventory;
        this.slot = slot;
        int numRows = backpackInventory.func_70302_i_() / 9;
        int i = (numRows - 4) * 18;
        for (int j = 0; j < numRows; ++j) {
            for (int k = 0; k < 9; ++k) {
                SlotBackpack sb = new SlotBackpack(player, backpackInventory, k + j * 9, 8 + k * 18, 18 + j * 18);
                if (!player.func_130014_f_().field_72995_K) {
                    sb.setContainerBackpack(this);
                }
                this.func_75146_a(sb);
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, j1 + l * 9 + 9, 8 + j1 * 18, 103 + l * 18 + i));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, i1, 8 + i1 * 18, 161 + i){
                boolean block;
                {
                    this.block = ContainerBackpack.this.isThisBackpack(this.func_75211_c());
                }

                public boolean func_75214_a(ItemStack stack) {
                    return !this.block;
                }

                public boolean func_82869_a(EntityPlayer playerIn) {
                    return !this.block;
                }
            });
        }
        if (!player.func_130014_f_().field_72995_K && backpackInventory.getUUID() == null) {
            this.saveBackpack(player);
        }
    }

    public void setNeedSave(boolean needSave) {
        this.needSave = needSave;
    }

    public boolean isValid(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        ItemStack bp = this.getRealBackpack(player);
        boolean valid = this.isThisBackpack(bp);
        if (valid && this.needSave) {
            this.needSave = false;
            this.saveBackpack(player);
        }
        return valid;
    }

    public ItemStack getRealBackpack(EntityPlayer player) {
        ItemStack bp = ItemStack.field_190927_a;
        switch (this.slot) {
            case 0: {
                bp = player.func_184614_ca();
                break;
            }
            case 1: {
                bp = player.func_184592_cb();
                break;
            }
            case 2: {
                bp = (ItemStack)player.field_71071_by.field_70460_b.get(EntityEquipmentSlot.CHEST.func_188454_b());
                break;
            }
            case 3: {
                if (!ImprovedBackpacks.proxy.isBaublesHere()) break;
                bp = BaublesApi.getBaublesHandler(player).getStackInSlot(BaubleType.BODY.getValidSlots()[0]);
            }
        }
        return bp;
    }

    public boolean isThisBackpack(ItemStack bp) {
        return !bp.func_190926_b() && bp.func_77973_b() == ModItems.BACKPACK && NBTUtils.getStackTag(bp).func_186855_b("UUID") && NBTUtils.getStackTag(bp).func_186857_a("UUID").equals(this.backpackInventory.uuid);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.backpackInventory.func_70300_a(player);
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, EntityPlayer player) {
        if (clickType == ClickType.SWAP) {
            Slot slot5 = (Slot)this.field_75151_b.get(slotId);
            ItemStack itemstack9 = player.field_71071_by.func_70301_a(dragType);
            ItemStack itemstack12 = slot5.func_75211_c();
            if (NBTUtil.func_181123_a((NBTBase)itemstack9.serializeNBT(), (NBTBase)this.backpackInventory.backpack.serializeNBT(), (boolean)true) || NBTUtil.func_181123_a((NBTBase)itemstack12.serializeNBT(), (NBTBase)this.backpackInventory.backpack.serializeNBT(), (boolean)true)) {
                return ItemStack.field_190927_a;
            }
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.backpackInventory.func_70302_i_() ? !this.func_75135_a(itemstack1, this.backpackInventory.func_70302_i_(), this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.backpackInventory.func_70302_i_(), false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        return itemstack;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.backpackInventory.func_174886_c(player);
        if (this.backpackInventory.backpack != null) {
            this.saveBackpack(player);
        }
        ItemBackpack.playCloseSound(player);
    }

    public void saveBackpack(EntityPlayer player) {
        if (this.backpackInventory.getUUID() == null) {
            this.backpackInventory.setUUID(UUID.randomUUID());
        }
        if (this.slot == 3 && ImprovedBackpacks.proxy.isBaublesHere()) {
            int bodySlot;
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler(player);
            if (baubles.getStackInSlot(bodySlot = BaubleType.BODY.getValidSlots()[0]) == this.backpackInventory.backpack) {
                ItemStack copy = this.backpackInventory.backpack.func_77946_l();
                ItemStackHelper.func_191282_a((NBTTagCompound)NBTUtils.getStackTag(copy), this.backpackInventory.items);
                NBTUtils.getStackTag(copy).func_186854_a("UUID", this.backpackInventory.getUUID());
                baubles.setStackInSlot(bodySlot, copy);
                this.backpackInventory.backpack = copy;
            }
        } else {
            ItemStackHelper.func_191282_a((NBTTagCompound)NBTUtils.getStackTag(this.backpackInventory.backpack), this.backpackInventory.items);
            NBTUtils.getStackTag(this.backpackInventory.backpack).func_186854_a("UUID", this.backpackInventory.getUUID());
        }
    }

    public InventoryBackpack getBackpackInventory() {
        return this.backpackInventory;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isClientBackpackSimilar(EntityPlayer player, ItemStack bp) {
        if (this.backpackInventory.uuid == null) {
            this.backpackInventory.uuid = ItemBackpack.getUUID(this.getRealBackpack(player));
        }
        return this.backpackInventory.uuid != null && this.backpackInventory.uuid.equals(NBTUtils.getStackTag(bp).func_186857_a("UUID"));
    }
}

