/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedbackpacks.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.poopycoders.improvedbackpacks.ImprovedBackpacks;
import ru.poopycoders.improvedbackpacks.init.ModBlocks;
import ru.poopycoders.improvedbackpacks.init.ModConfig;
import ru.poopycoders.improvedbackpacks.inventory.containers.ContainerBackpack;
import ru.poopycoders.improvedbackpacks.items.ItemBackpackUpgrade;
import ru.poopycoders.improvedbackpacks.utils.ColorUtils;
import ru.poopycoders.improvedbackpacks.utils.NBTUtils;

public class ItemBackpack
extends ItemArmor
implements IBauble {
    private static final ItemArmor.ArmorMaterial armorMaterial = EnumHelper.addArmorMaterial((String)"improvedbackpacks:backpack", (String)"improvedbackpacks:backpack", (int)0, (int[])new int[]{0, 0, 0, 0}, (int)0, (SoundEvent)SoundEvents.field_187728_s, (float)0.2f);
    public static final int DEFAULT_COLOR = -3038889;
    private ItemBlock itemBlock = new ItemBlock((Block)ModBlocks.BACKPACK);

    public ItemBackpack() {
        super(armorMaterial, 0, EntityEquipmentSlot.CHEST);
        this.func_77637_a(ImprovedBackpacks.creativeTab);
        this.setNoRepair();
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("open"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack backpack, @Nullable World world, @Nullable EntityLivingBase entity) {
                Minecraft mc = Minecraft.func_71410_x();
                if ((mc.field_71439_g.func_184614_ca() == backpack || mc.field_71439_g.func_184592_cb() == backpack) && mc.field_71439_g.field_71070_bA instanceof ContainerBackpack && ((ContainerBackpack)mc.field_71439_g.field_71070_bA).isClientBackpackSimilar((EntityPlayer)mc.field_71439_g, backpack)) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("3d"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack backpack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return ModConfig.gui3dBackpacks ? 1.0f : 0.0f;
            }
        });
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            ItemBackpack.playOpenSound(player, false);
            int guiId = hand == EnumHand.OFF_HAND ? 1 : 0;
            player.openGui((Object)ImprovedBackpacks.INSTANCE, guiId, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        } else {
            ImprovedBackpacks.proxy.openBackpackRenameGui(player, held);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)held);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int water;
        IBlockState state = world.func_180495_p(pos);
        ItemStack backpack = player.func_184586_b(hand);
        if (player.func_70093_af() && ModConfig.allowPlaceBackpacks) {
            return this.itemBlock.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
        }
        if (state.func_177230_c() instanceof BlockCauldron && (water = ((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a)).intValue()) > 0 && ItemBackpack.isDyed(backpack)) {
            ((BlockCauldron)state.func_177230_c()).func_176590_a(world, pos, state, water - 1);
            ItemBackpack.setBackpackColor(backpack, null);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
            for (EnumDyeColor dyeColor : EnumDyeColor.values()) {
                subItems.add((Object)ItemBackpack.setBackpackColor(new ItemStack((Item)this), dyeColor));
            }
        }
    }

    public String func_77667_c(ItemStack backpack) {
        EnumDyeColor color = ItemBackpack.getBackpackDyeColor(backpack);
        if (color == null) {
            return super.func_77667_c(backpack);
        }
        return super.func_77667_c(backpack) + "." + color.func_176762_d();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Minecraft mc = Minecraft.func_71410_x();
        if (ModConfig.maxBackpackTier != 0) {
            int tier = ItemBackpack.getTier(stack);
            if (GameSettings.func_100015_a((KeyBinding)mc.field_71474_y.field_74311_E)) {
                tooltip.add(TextFormatting.DARK_AQUA + I18n.func_135052_a((String)"tooltip.tier", (Object[])new Object[0]) + " " + tier);
                if (tier < ItemBackpackUpgrade.EnumUpgradeType.values().length && tier < ModConfig.maxBackpackTier) {
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.next_upgrade", (Object[])new Object[0]) + " " + TextFormatting.DARK_GREEN + I18n.func_135052_a((String)("tooltip.upgrade." + ItemBackpackUpgrade.EnumUpgradeType.byMeta(tier)), (Object[])new Object[0]));
                } else {
                    tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"tooltip.max_upgraded", (Object[])new Object[0]));
                }
            } else {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.backpack_info", (Object[])new Object[]{GameSettings.func_74298_c((int)mc.field_71474_y.field_74311_E.func_151463_i())}));
            }
            tooltip.add("");
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.hint.rename", (Object[])new Object[]{GameSettings.func_74298_c((int)mc.field_71474_y.field_74313_G.func_151463_i())}));
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.hint.place", (Object[])new Object[]{GameSettings.func_74298_c((int)mc.field_71474_y.field_74313_G.func_151463_i())}));
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    @Override
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BODY;
    }

    public static void playOpenSound(EntityPlayer player, boolean fromServer) {
        player.field_70170_p.func_184148_a(fromServer ? null : player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.0f, 1.5f);
    }

    public static void playCloseSound(EntityPlayer player) {
        player.field_70170_p.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.0f, 1.2f);
    }

    public static EnumDyeColor getBackpackDyeColor(ItemStack backpack) {
        if (backpack.func_77942_o() && backpack.func_77978_p().func_150297_b("Color", 3)) {
            return EnumDyeColor.func_176764_b((int)backpack.func_77978_p().func_74762_e("Color"));
        }
        return null;
    }

    public static ItemStack setBackpackColor(ItemStack backpack, EnumDyeColor color) {
        NBTTagCompound tag = NBTUtils.getStackTag(backpack);
        if (color != null) {
            tag.func_74768_a("Color", color.func_176765_a());
        } else {
            tag.func_82580_o("Color");
            if (tag.func_82582_d()) {
                backpack.func_77982_d(null);
            }
        }
        return backpack;
    }

    public static void setBackpackUUID(ItemStack backpack, UUID uuid) {
        NBTTagCompound tag = NBTUtils.getStackTag(backpack);
        tag.func_186854_a("UUID", uuid);
    }

    public static boolean isDyed(ItemStack backpack) {
        return ItemBackpack.getBackpackDyeColor(backpack) != null;
    }

    public static int getTier(ItemStack backpack) {
        if (backpack.func_77942_o() && backpack.func_77978_p().func_150297_b("Tier", 3)) {
            return backpack.func_77978_p().func_74762_e("Tier");
        }
        return 0;
    }

    public static UUID getUUID(ItemStack backpack) {
        if (backpack.func_77942_o() && backpack.func_77978_p().func_186855_b("UUID")) {
            return backpack.func_77978_p().func_186857_a("UUID");
        }
        return null;
    }

    public static int getInventorySize(ItemStack backpack) {
        return ItemBackpack.getInventorySize(ItemBackpack.getTier(backpack));
    }

    public static int getInventorySize(int tier) {
        return (tier + 2) * 9;
    }

    public static int getSpecialColor(ItemStack backpack) {
        int tier = ItemBackpack.getTier(backpack);
        if (tier > 0) {
            return ItemBackpackUpgrade.EnumUpgradeType.byMeta(tier - 1).getColor();
        }
        return -9287377;
    }

    public static int getColor0(ItemStack backpack) {
        return ItemBackpack.getColorFromDyeColor(ItemBackpack.getBackpackDyeColor(backpack));
    }

    public static int getColorFromDyeColor(EnumDyeColor dyeColor) {
        if (dyeColor != null) {
            float[] c = EntitySheep.func_175513_a((EnumDyeColor)dyeColor);
            return ColorUtils.interpolateColor(new Color(c[0], c[1], c[2]).getRGB(), -1, 0.1f);
        }
        return -3038889;
    }

    public static boolean canBeUpgraded(ItemStack backpack) {
        return ItemBackpack.getTier(backpack) < ModConfig.maxBackpackTier;
    }

    public static ItemStack setTier(ItemStack backpack, int tier) {
        tier = MathHelper.func_76125_a((int)tier, (int)0, (int)5);
        NBTTagCompound tag = NBTUtils.getStackTag(backpack);
        if (tier != 0) {
            tag.func_74768_a("Tier", tier);
        } else {
            tag.func_82580_o("Tier");
            if (tag.func_82582_d()) {
                backpack.func_77982_d(null);
            }
        }
        return backpack;
    }
}

