/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedbackpacks.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.poopycoders.improvedbackpacks.ImprovedBackpacks;
import ru.poopycoders.improvedbackpacks.init.ModBlocks;
import ru.poopycoders.improvedbackpacks.init.ModConfig;

public class ItemEnderBackpack
extends ItemArmor
implements IBauble {
    private static final ItemArmor.ArmorMaterial armorMaterial = EnumHelper.addArmorMaterial((String)"improvedbackpacks:ender_backpack", (String)"improvedbackpacks:ender_backpack", (int)0, (int[])new int[]{0, 0, 0, 0}, (int)0, (SoundEvent)SoundEvents.field_187728_s, (float)0.2f);
    private ItemBlock itemBlock = new ItemBlock((Block)ModBlocks.ENDER_BACKPACK);

    public ItemEnderBackpack() {
        super(armorMaterial, 1, EntityEquipmentSlot.CHEST);
        this.func_77637_a(ImprovedBackpacks.creativeTab);
        this.setNoRepair();
        this.func_77625_d(1);
        this.func_77656_e(128);
        this.func_185043_a(new ResourceLocation("open"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack backpack, @Nullable World world, @Nullable EntityLivingBase entity) {
                Minecraft mc = Minecraft.func_71410_x();
                if ((mc.field_71439_g.func_184614_ca() == backpack || mc.field_71439_g.func_184592_cb() == backpack) && mc.field_71439_g.field_71070_bA instanceof ContainerChest && ((ContainerChest)mc.field_71439_g.field_71070_bA).func_85151_d().func_70005_c_().equals(I18n.func_135052_a((String)"container.enderchest", (Object[])new Object[0]))) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("3d"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack backpack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return ModConfig.gui3dBackpacks ? 1.0f : 0.0f;
            }
        });
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (ModConfig.enderBackpackEnabled) {
            this.openEnderBackpack(player, player.func_184586_b(hand), true);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return this.itemBlock.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BODY;
    }

    public void openEnderBackpack(EntityPlayer player, ItemStack stack, boolean soundFlag) {
        if (ModConfig.enderBackpackEnabled) {
            player.field_70170_p.func_184148_a((EntityPlayer)(soundFlag ? player : null), player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187520_aJ, SoundCategory.PLAYERS, 1.0f, 1.5f);
            if (!player.field_70170_p.field_72995_K) {
                player.func_71007_a((IInventory)player.func_71005_bN());
                if (ModConfig.enderBackpackHasDurability) {
                    if (!player.field_71075_bZ.field_75098_d && stack.func_96631_a(1, player.func_70681_au(), (EntityPlayerMP)player)) {
                        stack.func_190920_e(0);
                    }
                } else if (stack.func_77952_i() != 0) {
                    stack.func_77964_b(0);
                }
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!ModConfig.enderBackpackEnabled) {
            tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"tooltip.disabled_in_config", (Object[])new Object[0]));
        }
    }
}

