/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.JustEnoughCalculation;
import me.towdium.jecalculation.data.label.labels.LFluidStack;
import me.towdium.jecalculation.data.label.labels.LItemStack;
import me.towdium.jecalculation.data.label.labels.LOreDict;
import me.towdium.jecalculation.data.label.labels.LPlaceholder;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.guis.pickers.IPicker;
import me.towdium.jecalculation.gui.guis.pickers.PickerItemStack;
import me.towdium.jecalculation.gui.guis.pickers.PickerPlaceholder;
import me.towdium.jecalculation.gui.guis.pickers.PickerSimple;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Pair;
import mezz.jei.api.gui.IRecipeLayout;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface ILabel {
    public static final Merger MERGER = new Merger();
    public static final Serializer SERIALIZER = new Serializer();
    public static final Converter CONVERTER = new Converter();
    public static final RegistryEditor EDITOR = new RegistryEditor();
    public static final ILabel EMPTY = new LEmpty();
    public static final String FORMAT_BLUE = "\u00a79";
    public static final String FORMAT_GREY = "\u00a78";
    public static final String FORMAT_ITALIC = "\u00a7o";

    @Nullable
    public Object getRepresentation();

    public ILabel increaseAmount();

    public ILabel decreaseAmount();

    public static void initClient() {
        CONVERTER.register(LItemStack::suggest, Converter.Priority.SUGGEST);
        CONVERTER.register(LOreDict::suggest, Converter.Priority.SUGGEST);
        CONVERTER.register(LFluidStack::suggest, Converter.Priority.SUGGEST);
        CONVERTER.register(LItemStack::fallback, Converter.Priority.FALLBACK);
        CONVERTER.register(LOreDict::fallback, Converter.Priority.FALLBACK);
        EDITOR.register(PickerSimple.FluidStack::new, "fluid", new LFluidStack(1000L, FluidRegistry.WATER));
        EDITOR.register(PickerSimple.OreDict::new, "ore", new LOreDict("ingotIron"));
        EDITOR.register(PickerPlaceholder::new, "placeholder", new LPlaceholder("example", 1L, true));
        EDITOR.register(PickerItemStack::new, "item", new LItemStack(new ItemStack(Items.field_151035_b)).setFMeta(true));
        MERGER.register("itemStack", "itemStack", Impl.form(LItemStack.class, LItemStack.class, LItemStack::merge));
        MERGER.register("oreDict", "oreDict", Impl.form(LOreDict.class, LOreDict.class, LOreDict::mergeSame));
        MERGER.register("oreDict", "itemStack", Impl.form(LOreDict.class, LItemStack.class, LOreDict::mergeFuzzy));
        MERGER.register("fluidStack", "fluidStack", Impl.form(LFluidStack.class, LFluidStack.class, LFluidStack::merge));
        MERGER.register("placeholder", "placeholder", Impl.form(LPlaceholder.class, LPlaceholder.class, LPlaceholder::merge));
    }

    public long getAmount();

    public ILabel multiply(float var1);

    public boolean acceptPercent();

    public ILabel setPercent(boolean var1);

    public boolean isPercent();

    public static void initServer() {
        SERIALIZER.register("fluidStack", LFluidStack::new);
        SERIALIZER.register("itemStack", LItemStack::new);
        SERIALIZER.register("oreDict", LOreDict::new);
        SERIALIZER.register("placeholder", LPlaceholder::new);
        SERIALIZER.register("empty", i -> EMPTY);
    }

    public String getAmountString(boolean var1);

    public String getDisplayName();

    public void getToolTip(List<String> var1, boolean var2);

    public ILabel copy();

    public NBTTagCompound toNbt();

    public String getIdentifier();

    public ILabel setAmount(long var1);

    public boolean matches(Object var1);

    @SideOnly(value=Side.CLIENT)
    public void drawLabel(JecaGui var1, int var2, int var3, boolean var4);

    public static abstract class Impl
    implements ILabel {
        public static final String KEY_AMOUNT = "amount";
        public static final String KEY_PERCENT = "percent";
        protected long amount;
        protected boolean percent;

        public String toString() {
            return this.getDisplayName() + 'x' + this.getAmount();
        }

        public Impl(long amount, boolean percent) {
            this.amount = amount;
            this.percent = percent;
        }

        public Impl(Impl lsa) {
            this.amount = lsa.amount;
            this.percent = lsa.percent;
        }

        public Impl(NBTTagCompound nbt) {
            this.amount = nbt.func_74763_f(KEY_AMOUNT);
            this.percent = nbt.func_74767_n(KEY_PERCENT);
        }

        protected int getMultiplier() {
            return 1;
        }

        @Override
        public void drawLabel(JecaGui gui, int xPos, int yPos, boolean center) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(center ? (float)(xPos - 8) : (float)xPos), (float)(center ? (float)(yPos - 8) : (float)yPos), (float)0.0f);
            this.drawLabel(gui);
            GlStateManager.func_179121_F();
        }

        @Override
        public ILabel increaseAmount() {
            return this.setAmount(this.getAmount() + (long)this.getMultiplier());
        }

        @Override
        public ILabel decreaseAmount() {
            if (this.getAmount() <= (long)this.getMultiplier()) {
                return EMPTY;
            }
            return this.setAmount(this.getAmount() - (long)this.getMultiplier());
        }

        public int hashCode() {
            return (int)(this.amount ^ (long)(this.percent ? 1 : 0));
        }

        protected static Merger.MergerFunction form(Class a, Class b, BiPredicate<ILabel, ILabel> p) {
            return (c, d) -> {
                if (a.isInstance(d) && b.isInstance(c)) {
                    ILabel tmp = c;
                    c = d;
                    d = tmp;
                }
                if (a.isInstance(c) && b.isInstance(d) && p.test(c, d)) {
                    long amountC = c.isPercent() ? c.getAmount() : Math.multiplyExact(c.getAmount(), 100L);
                    long amountD = d.isPercent() ? d.getAmount() : Math.multiplyExact(d.getAmount(), 100L);
                    long amount = Math.addExact(amountC, amountD);
                    long amountI = (amount > 0L ? Math.addExact(amount, 99L) : Math.subtractExact(amount, 99L)) / 100L;
                    if (amount == 0L) {
                        return EMPTY;
                    }
                    if (amount > 0L) {
                        return d.copy().setAmount(d.isPercent() ? amount : amountI);
                    }
                    return c.copy().setAmount(c.isPercent() ? amount : amountI);
                }
                return null;
            };
        }

        @Override
        public ILabel multiply(float i) {
            float amount = i * (float)this.getAmount();
            if (amount > 9.223372E18f) {
                throw new ArithmeticException("Multiply overflow");
            }
            return this.setAmount((long)amount);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getToolTip(List<String> existing, boolean detailed) {
            if (detailed) {
                existing.add(ILabel.FORMAT_GREY + Utilities.I18n.get("label.common.amount", this.getAmountString(false)));
            }
        }

        @Override
        public long getAmount() {
            return this.amount;
        }

        @Override
        public ILabel setAmount(long amount) {
            if (amount == 0L) {
                return EMPTY;
            }
            this.amount = amount;
            return this;
        }

        @Override
        public NBTTagCompound toNbt() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a(KEY_AMOUNT, this.amount);
            if (this.percent) {
                nbt.func_74757_a(KEY_PERCENT, true);
            }
            return nbt;
        }

        @Override
        public boolean acceptPercent() {
            return true;
        }

        @Override
        public ILabel setPercent(boolean p) {
            if (p && !this.acceptPercent()) {
                throw new UnsupportedOperationException();
            }
            if (p && !this.percent) {
                this.amount *= 100L;
                this.percent = true;
            } else if (!p && this.percent) {
                this.amount = (this.amount + 99L) / 100L;
                this.percent = false;
            }
            return this;
        }

        @Override
        public boolean isPercent() {
            return this.percent;
        }

        public boolean equals(Object obj) {
            return obj instanceof Impl && this.amount == ((Impl)obj).amount && this.matches(obj);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public String getAmountString(boolean round) {
            if (this.getAmount() == 0L) {
                return "";
            }
            if (!this.percent) {
                return Utilities.cutNumber(this.getAmount(), 5);
            }
            if (round) {
                return Utilities.cutNumber((this.getAmount() + 99L) / 100L, 5);
            }
            return Utilities.cutNumber(this.getAmount(), 4) + "%";
        }

        @Override
        public abstract Impl copy();

        @Override
        public boolean matches(Object l) {
            return l instanceof Impl && this.percent == ((Impl)l).percent;
        }

        protected abstract void drawLabel(JecaGui var1);
    }

    public static class LEmpty
    implements ILabel {
        public static final String IDENTIFIER = "empty";

        @Override
        public boolean matches(Object l) {
            return l == this;
        }

        private LEmpty() {
        }

        @Override
        @Nullable
        public Object getRepresentation() {
            return null;
        }

        @Override
        public ILabel increaseAmount() {
            return this;
        }

        @Override
        public ILabel decreaseAmount() {
            return this;
        }

        @Override
        public ILabel multiply(float i) {
            return this;
        }

        @Override
        public boolean acceptPercent() {
            return false;
        }

        @Override
        public ILabel setPercent(boolean p) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPercent() {
            return false;
        }

        @Override
        public long getAmount() {
            return 0L;
        }

        @Override
        public ILabel setAmount(long amount) {
            return this;
        }

        @Override
        public String getAmountString(boolean round) {
            return "";
        }

        @Override
        public String getDisplayName() {
            return "";
        }

        @Override
        public void getToolTip(List<String> existing, boolean detailed) {
        }

        @Override
        public ILabel copy() {
            return this;
        }

        @Override
        public NBTTagCompound toNbt() {
            return new NBTTagCompound();
        }

        @Override
        public String getIdentifier() {
            return IDENTIFIER;
        }

        @Override
        public void drawLabel(JecaGui gui, int xPos, int yPos, boolean center) {
        }
    }

    public static class RegistryEditor {
        private ArrayList<Record> records = new ArrayList();

        private RegistryEditor() {
        }

        public void register(Supplier<IPicker> editor, String unlocalizedName, ILabel representation) {
            this.records.add(new Record(editor, "common.label." + unlocalizedName, representation));
        }

        public List<Record> getRecords() {
            return this.records;
        }

        public static class Record {
            public Supplier<IPicker> editor;
            public String localizeKey;
            public ILabel representation;

            public Record(Supplier<IPicker> editor, String localizeKey, ILabel representation) {
                this.editor = editor;
                this.localizeKey = localizeKey;
                this.representation = representation;
            }
        }
    }

    public static class Converter {
        static EnumMap<Priority, ArrayList<ConverterFunction>> handlers = new EnumMap(Priority.class);

        public static ILabel from(@Nullable Object o) {
            if (o == null) {
                return EMPTY;
            }
            if (o instanceof ItemStack) {
                return new LItemStack((ItemStack)o);
            }
            if (o instanceof FluidStack) {
                return new LFluidStack((FluidStack)o);
            }
            if (o instanceof EnchantmentData) {
                return new LItemStack(ItemEnchantedBook.func_92111_a((EnchantmentData)((EnchantmentData)o)));
            }
            JustEnoughCalculation.logger.warn("Unrecognized ingredient type: " + o.getClass());
            return EMPTY;
        }

        public void register(ConverterFunction handler, Priority priority) {
            handlers.get((Object)priority).add(handler);
        }

        public ILabel first(List<ILabel> labels, @Nullable IRecipeLayout context) {
            List guess = (List)this.guess(labels, (IRecipeLayout)context).one;
            return guess.isEmpty() ? labels.get(0) : (ILabel)guess.get(0);
        }

        public ILabel first(List<ILabel> labels) {
            return this.first(labels, null);
        }

        public Pair<List<ILabel>, List<ILabel>> guess(List<ILabel> labels) {
            return this.guess(labels, null);
        }

        public Pair<List<ILabel>, List<ILabel>> guess(List<ILabel> labels, @Nullable IRecipeLayout context) {
            ArrayList ret = new ArrayList();
            List suggest = new Utilities.ReversedIterator((List)handlers.get((Object)Priority.SUGGEST)).stream().flatMap(h -> h.convert(labels, context).stream()).collect(Collectors.toList());
            List fallback = new Utilities.ReversedIterator((List)handlers.get((Object)Priority.FALLBACK)).stream().flatMap(h -> h.convert(labels, context).stream()).collect(Collectors.toList());
            return new Pair<List<ILabel>, List<ILabel>>(suggest, fallback);
        }

        static {
            handlers.put(Priority.SUGGEST, new ArrayList());
            handlers.put(Priority.FALLBACK, new ArrayList());
        }

        @FunctionalInterface
        public static interface ConverterFunction {
            public List<ILabel> convert(List<ILabel> var1, @Nullable IRecipeLayout var2);
        }

        public static enum Priority {
            SUGGEST,
            FALLBACK;

        }
    }

    public static class Serializer {
        public static final String KEY_IDENTIFIER = "type";
        public static final String KEY_CONTENT = "content";
        private HashMap<String, Function<NBTTagCompound, ILabel>> idToData = new HashMap();

        private Serializer() {
        }

        public void register(String identifier, Function<NBTTagCompound, ILabel> deserializer) {
            this.idToData.put(identifier, deserializer);
        }

        public ILabel deserialize(NBTTagCompound nbt) {
            String s = nbt.func_74779_i(KEY_IDENTIFIER);
            Function<NBTTagCompound, ILabel> func = this.idToData.get(s);
            if (func == null) {
                JustEnoughCalculation.logger.warn("Unrecognized identifier \"" + s + "\", abort");
            } else {
                try {
                    return func.apply(nbt.func_74775_l(KEY_CONTENT));
                }
                catch (SerializationException serializationException) {
                    // empty catch block
                }
            }
            return EMPTY;
        }

        public NBTTagCompound serialize(ILabel label) {
            NBTTagCompound ret = new NBTTagCompound();
            ret.func_74778_a(KEY_IDENTIFIER, label.getIdentifier());
            ret.func_74782_a(KEY_CONTENT, (NBTBase)label.toNbt());
            return ret;
        }

        public static class SerializationException
        extends RuntimeException {
            public SerializationException(String s) {
                super(s);
                JustEnoughCalculation.logger.warn(s);
            }
        }
    }

    public static class Merger {
        private Utilities.Relation<String, MergerFunction> functions = new Utilities.Relation();

        private Merger() {
        }

        public void register(String a, String b, MergerFunction func) {
            this.functions.put(a, b, func);
        }

        public Optional<ILabel> merge(ILabel a, ILabel b) {
            MergerFunction mf = this.functions.get(a.getIdentifier(), b.getIdentifier());
            if (mf == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(mf.merge(a, b));
        }

        @FunctionalInterface
        public static interface MergerFunction {
            @Nullable
            public ILabel merge(ILabel var1, ILabel var2);
        }
    }
}

