/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.guis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.Controller;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.structure.CostList;
import me.towdium.jecalculation.data.structure.RecordCraft;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.guis.GuiLabel;
import me.towdium.jecalculation.gui.guis.GuiRecipe;
import me.towdium.jecalculation.gui.guis.GuiSearch;
import me.towdium.jecalculation.gui.guis.IGui;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.gui.widgets.WButton;
import me.towdium.jecalculation.gui.widgets.WButtonIcon;
import me.towdium.jecalculation.gui.widgets.WContainer;
import me.towdium.jecalculation.gui.widgets.WHelp;
import me.towdium.jecalculation.gui.widgets.WIcon;
import me.towdium.jecalculation.gui.widgets.WLabel;
import me.towdium.jecalculation.gui.widgets.WLabelGroup;
import me.towdium.jecalculation.gui.widgets.WLabelScroll;
import me.towdium.jecalculation.gui.widgets.WLine;
import me.towdium.jecalculation.gui.widgets.WOverlay;
import me.towdium.jecalculation.gui.widgets.WPanel;
import me.towdium.jecalculation.gui.widgets.WText;
import me.towdium.jecalculation.gui.widgets.WTextField;
import me.towdium.jecalculation.utils.wrappers.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@SideOnly(value=Side.CLIENT)
public class GuiCraft
extends WContainer
implements IGui {
    Mode mode = Mode.INPUT;
    CostList.Calculator calculator = null;
    RecordCraft record = Controller.getRCraft();
    WLabelGroup recent = new WLabelGroup(7, 31, 8, 1, WLabel.Mode.PICKER).setListener((i, v) -> {
        JecaGui.getCurrent().hand = i.get((int)v);
    });
    WLabelScroll result = new WLabelScroll(7, 87, 8, 4, WLabel.Mode.RESULT, true);
    WButton steps = new WButtonIcon(64, 62, 20, 20, Resource.BTN_LIST, "craft.step").setListener(i -> this.setMode(Mode.STEPS));
    WButton catalyst = new WButtonIcon(45, 62, 20, 20, Resource.BTN_CAT, "common.catalyst").setListener(i -> this.setMode(Mode.CATALYST));
    WButton output = new WButtonIcon(26, 62, 20, 20, Resource.BTN_OUT, "common.output").setListener(i -> this.setMode(Mode.OUTPUT));
    WButton input = new WButtonIcon(7, 62, 20, 20, Resource.BTN_IN, "common.input").setListener(i -> this.setMode(Mode.INPUT));
    WLabel label = new WLabel(31, 7, 20, 20, WLabel.Mode.SELECTOR).setListener((i, v) -> this.refreshLabel((ILabel)v, false, true));
    WButton invE = new WButtonIcon(149, 62, 20, 20, Resource.BTN_INV_E, "craft.inventory_enabled");
    WButton invD = new WButtonIcon(149, 62, 20, 20, Resource.BTN_INV_D, "craft.inventory_disabled");
    WTextField amount;

    public GuiCraft() {
        this.amount = new WTextField(60, 7, 65).setText(this.record.amount).setListener(i -> {
            this.record.amount = i.getText();
            Controller.setRCraft(this.record);
            this.refreshCalculator();
        });
        this.add((IWidget)new WHelp("craft"));
        this.add((IWidget)new WPanel());
        this.add((IWidget)new WButtonIcon(7, 7, 20, 20, Resource.BTN_LABEL, "craft.label").setListener(i -> JecaGui.displayGui(new GuiLabel(l -> {
            JecaGui.displayParent();
            JecaGui.getCurrent().hand = l;
        }))));
        this.add((IWidget)new WButtonIcon(130, 7, 20, 20, Resource.BTN_NEW, "craft.recipe").setListener(i -> JecaGui.displayGui(true, true, new GuiRecipe())));
        this.add((IWidget)new WButtonIcon(149, 7, 20, 20, Resource.BTN_SEARCH, "craft.search").setListener(i -> JecaGui.displayGui(new GuiSearch())));
        this.add((IWidget)new WText(53, 13, JecaGui.Font.RAW, "x"));
        this.add((IWidget)new WLine(55));
        this.add((IWidget)new WIcon(151, 31, 18, 18, Resource.ICN_RECENT, "craft.history"));
        this.add(this.recent, this.label, this.input, this.output, this.catalyst, this.steps, this.result, this.amount, this.record.inventory ? this.invE : this.invD);
        this.invE.setListener(i -> {
            this.record.inventory = false;
            Controller.setRCraft(this.record);
            this.remove(this.invE);
            this.add((IWidget)this.invD);
            this.refreshCalculator();
        });
        this.invD.setListener(i -> {
            this.record.inventory = true;
            Controller.setRCraft(this.record);
            this.remove(this.invD);
            this.add((IWidget)this.invE);
            this.refreshCalculator();
        });
        this.refreshRecent();
        this.setMode(Mode.INPUT);
    }

    @Override
    public void onVisible(JecaGui gui) {
        this.refreshCalculator();
    }

    void setMode(Mode mode) {
        this.mode = mode;
        this.input.setDisabled(mode == Mode.INPUT);
        this.output.setDisabled(mode == Mode.OUTPUT);
        this.catalyst.setDisabled(mode == Mode.CATALYST);
        this.steps.setDisabled(mode == Mode.STEPS);
        this.refreshResult();
    }

    void refreshRecent() {
        this.label.setLabel(this.record.getLatest());
        this.recent.setLabel(this.record.getHistory(), 0);
    }

    void refreshCalculator() {
        try {
            String s = this.amount.getText();
            long i = s.isEmpty() ? 1L : Long.parseLong(this.amount.getText());
            this.amount.setColor(0xFFFFFF);
            List<ILabel> dest = Collections.singletonList(this.label.getLabel().copy().setAmount(i));
            CostList list = this.record.inventory ? new CostList(this.getInventory(), dest) : new CostList(dest);
            this.calculator = list.calculate();
        }
        catch (ArithmeticException | NumberFormatException e) {
            this.amount.setColor(0xFF0000);
            this.calculator = null;
        }
        this.refreshResult();
    }

    List<ILabel> getInventory() {
        InventoryPlayer inv = Minecraft.func_71410_x().field_71439_g.field_71071_by;
        ArrayList<ILabel> labels = new ArrayList<ILabel>();
        Consumer<List> add = i -> i.stream().filter(j -> !j.func_190926_b()).forEach(j -> labels.add(ILabel.Converter.from(j)));
        add.accept((List)inv.field_70460_b);
        add.accept((List)inv.field_70462_a);
        add.accept((List)inv.field_184439_c);
        return labels;
    }

    void refreshResult() {
        if (this.calculator == null) {
            this.result.setLabels(new ArrayList<ILabel>());
        } else {
            switch (this.mode) {
                case INPUT: {
                    this.result.setLabels(this.calculator.getInputs());
                    break;
                }
                case OUTPUT: {
                    this.result.setLabels(this.calculator.getOutputs(this.getInventory()));
                    break;
                }
                case CATALYST: {
                    this.result.setLabels(this.calculator.getCatalysts());
                    break;
                }
                case STEPS: {
                    this.result.setLabels(this.calculator.getSteps());
                }
            }
        }
    }

    private void refreshLabel(ILabel l, boolean replace, boolean suggest) {
        boolean dup = this.record.push(l, replace);
        Controller.setRCraft(this.record);
        this.refreshRecent();
        this.refreshCalculator();
        if (suggest && GuiCraft.findRecipe(l).isEmpty()) {
            Pair<List<ILabel>, List<ILabel>> guess = ILabel.CONVERTER.guess(Collections.singletonList(l));
            LinkedHashSet match = new LinkedHashSet();
            ArrayList fuzzy = new ArrayList();
            Stream.of((List)guess.one, (List)guess.two).flatMap(Collection::stream).forEach(i -> {
                List<ILabel> list = GuiCraft.findRecipe(i);
                list.forEach(j -> match.add(j.setPercent(false).setAmount(1L)));
                if (!list.isEmpty()) {
                    fuzzy.add(i);
                }
            });
            match.addAll(fuzzy);
            ArrayList list = new ArrayList(match);
            if (!match.isEmpty()) {
                this.add((IWidget)new Suggest(list.size() > 3 ? list.subList(0, 3) : list, !dup));
            }
        }
    }

    private static List<ILabel> findRecipe(ILabel l) {
        return Controller.recipeIterator().stream().map(i -> i.matches(l)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    class Suggest
    extends WOverlay {
        boolean replace;

        public Suggest(List<ILabel> labels, boolean replace) {
            this.replace = replace;
            int width = labels.size() * 20;
            this.add((IWidget)new WPanel(0 - width, 2, 56 + width, 30));
            this.add((IWidget)new WLabel(31, 7, 20, 20, WLabel.Mode.PICKER).setLabel(GuiCraft.this.label.getLabel()).setListener((i, v) -> this.refresh((ILabel)v)));
            this.add((IWidget)new WIcon(5 - width, 7, 18, 20, Resource.ICN_HELP, "craft.suggest"));
            this.add((IWidget)new WLine(26, 7, 20, false));
            for (int i2 = 0; i2 < labels.size(); ++i2) {
                this.add((IWidget)new WLabel(3 - i2 * 20, 7, 20, 20, WLabel.Mode.PICKER).setLabel(labels.get(i2)).setListener((j, v) -> this.refresh((ILabel)v)));
            }
        }

        public void refresh(ILabel l) {
            GuiCraft.this.remove(this);
            GuiCraft.this.refreshLabel(l, this.replace, false);
        }
    }

    static enum Mode {
        INPUT,
        OUTPUT,
        CATALYST,
        STEPS;

    }
}

