/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.common.block;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.creativecore.common.block.TileEntityState;
import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.opener.GuiHandler;
import com.creativemd.creativecore.common.gui.opener.IGuiCreator;
import com.creativemd.creativecore.common.utils.math.box.AlignedBox;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.creative.littleframes.LittleFrames;
import team.creative.littleframes.client.gui.SubGuiCreativeFrame;
import team.creative.littleframes.common.block.TileEntityCreativeFrame;
import team.creative.littleframes.common.container.SubContainerCreativeFrame;

public class BlockCreativeFrame
extends BlockContainer
implements IGuiCreator,
ICreativeRendered {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;

    public BlockCreativeFrame() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST));
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149752_b(2.5f);
        this.func_149711_c(2.0f);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return new TileEntityState(state, world.func_175625_s(pos));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        AlignedBox cube = new AlignedBox(0.0f, 0.0f, 0.0f, 0.05f, 1.0f, 1.0f);
        EnumFacing direction = (EnumFacing)blockState.func_177229_b((IProperty)FACING);
        return BlockCreativeFrame.rotateCube(cube, direction).getBB();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity te = source.func_175625_s(pos);
        if (te instanceof TileEntityCreativeFrame) {
            return ((TileEntityCreativeFrame)te).getBox().getBB();
        }
        AlignedBox cube = new AlignedBox(0.0f, 0.0f, 0.0f, 0.05f, 1.0f, 1.0f);
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return BlockCreativeFrame.rotateCube(cube, direction).getBB();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && LittleFrames.CONFIG.canInteract(player, world)) {
            GuiHandler.openGui((EntityPlayer)player, (World)world, (BlockPos)pos);
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCreativeFrame();
    }

    @SideOnly(value=Side.CLIENT)
    public SubGui getGui(EntityPlayer player, ItemStack stack, World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCreativeFrame) {
            return new SubGuiCreativeFrame((TileEntityCreativeFrame)te);
        }
        return null;
    }

    public SubContainer getContainer(EntityPlayer player, ItemStack stack, World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCreativeFrame) {
            return new SubContainerCreativeFrame((TileEntityCreativeFrame)te, player);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ArrayList<RenderBox> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        ArrayList<RenderBox> cubes = new ArrayList<RenderBox>();
        RenderBox cube = new RenderBox(0.0f, 0.0f, 0.0f, 0.03f, 1.0f, 1.0f, Blocks.field_150344_f);
        if (te instanceof TileEntityCreativeFrame && ((TileEntityCreativeFrame)te).visibleFrame) {
            cube = new RenderBox(BlockCreativeFrame.rotateCube((AlignedBox)cube, (EnumFacing)state.func_177229_b((IProperty)FACING)), cube);
            cubes.add(cube);
        } else if (!(te instanceof TileEntityCreativeFrame)) {
            cubes.add(cube);
        }
        return cubes;
    }

    public static AlignedBox rotateCube(AlignedBox cube, EnumFacing direction) {
        return BlockCreativeFrame.rotateCube(cube, direction, new Vec3d(0.5, 0.5, 0.5));
    }

    public static AlignedBox rotateCube(AlignedBox cube, EnumFacing direction, Vec3d center) {
        AlignedBox rotateCube = new AlignedBox(cube);
        BlockCreativeFrame.applyCubeRotation(rotateCube, direction, center);
        return rotateCube;
    }

    public static Vec3d applyVectorRotation(Vec3d vector, EnumFacing EnumFacing2) {
        double tempX = vector.field_72450_a;
        double tempY = vector.field_72448_b;
        double tempZ = vector.field_72449_c;
        double posX = tempX;
        double posY = tempY;
        double posZ = tempZ;
        switch (EnumFacing2) {
            case UP: {
                posX = -tempY;
                posY = tempX;
                break;
            }
            case DOWN: {
                posX = tempY;
                posY = -tempX;
                break;
            }
            case SOUTH: {
                posX = -tempZ;
                posZ = tempX;
                break;
            }
            case NORTH: {
                posX = tempZ;
                posZ = -tempX;
                break;
            }
            case WEST: {
                posX = -tempX;
                posZ = -tempZ;
                break;
            }
        }
        return new Vec3d(posX, posY, posZ);
    }

    public static void applyCubeRotation(AlignedBox cube, EnumFacing EnumFacing2, Vec3d center) {
        float minX = cube.minX;
        float minY = cube.minY;
        float minZ = cube.minZ;
        float maxX = cube.maxX;
        float maxY = cube.maxY;
        float maxZ = cube.maxZ;
        if (center != null) {
            minX = (float)((double)minX - center.field_72450_a);
            minY = (float)((double)minY - center.field_72448_b);
            minZ = (float)((double)minZ - center.field_72449_c);
            maxX = (float)((double)maxX - center.field_72450_a);
            maxY = (float)((double)maxY - center.field_72448_b);
            maxZ = (float)((double)maxZ - center.field_72449_c);
        }
        Vec3d min = BlockCreativeFrame.applyVectorRotation(new Vec3d((double)minX, (double)minY, (double)minZ), EnumFacing2);
        Vec3d max = BlockCreativeFrame.applyVectorRotation(new Vec3d((double)maxX, (double)maxY, (double)maxZ), EnumFacing2);
        if (center != null) {
            min = min.func_72441_c(center.field_72450_a, center.field_72448_b, center.field_72449_c);
            max = max.func_72441_c(center.field_72450_a, center.field_72448_b, center.field_72449_c);
        }
        if (min.field_72450_a < max.field_72450_a) {
            cube.minX = (float)min.field_72450_a;
            cube.maxX = (float)max.field_72450_a;
        } else {
            cube.minX = (float)max.field_72450_a;
            cube.maxX = (float)min.field_72450_a;
        }
        if (min.field_72448_b < max.field_72448_b) {
            cube.minY = (float)min.field_72448_b;
            cube.maxY = (float)max.field_72448_b;
        } else {
            cube.minY = (float)max.field_72448_b;
            cube.maxY = (float)min.field_72448_b;
        }
        if (min.field_72449_c < max.field_72449_c) {
            cube.minZ = (float)min.field_72449_c;
            cube.maxZ = (float)max.field_72449_c;
        } else {
            cube.minZ = (float)max.field_72449_c;
            cube.maxZ = (float)min.field_72449_c;
        }
    }
}

