/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.common.structure;

import com.creativemd.creativecore.common.utils.mc.InventoryUtils;
import com.creativemd.littletiles.client.gui.handler.LittleStructureGuiHandler;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LittleFrameBuilder
extends LittleStructurePremade {
    public InventoryBasic inventory = new InventoryBasic("recipe", false, 1);
    public int lastSizeX = 16;
    public int lastSizeY = 16;
    public int lastThickness = 1;
    public IBlockState lastBlockState;

    public LittleFrameBuilder(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        LittleStructureGuiHandler.openGui((String)"frame_builder", (NBTTagCompound)new NBTTagCompound(), (EntityPlayer)playerIn, (LittleStructure)this);
        return true;
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.lastSizeX = nbt.func_74764_b("sizeX") ? nbt.func_74762_e("sizeX") : 16;
        this.lastSizeY = nbt.func_74764_b("sizeY") ? nbt.func_74762_e("sizeY") : 16;
        this.lastThickness = nbt.func_74764_b("thickness") ? nbt.func_74762_e("thickness") : 1;
        if (nbt.func_74764_b("block")) {
            String[] parts = nbt.func_74779_i("block").split(":");
            Block block = Block.func_149684_b((String)(parts[0] + ":" + parts[1]));
            int meta = parts.length == 3 ? Integer.parseInt(parts[2]) : 0;
            this.lastBlockState = block.func_176203_a(meta);
        } else {
            this.lastBlockState = Blocks.field_150344_f.func_176223_P();
        }
        this.inventory = InventoryUtils.loadInventoryBasic((NBTTagCompound)nbt, (int)1);
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74768_a("sizeX", this.lastSizeX);
        nbt.func_74768_a("sizeY", this.lastSizeY);
        nbt.func_74768_a("thickness", this.lastThickness);
        InventoryUtils.saveInventoryBasic((IInventory)this.inventory);
        Block block = this.lastBlockState.func_177230_c();
        int meta = block.func_176201_c(this.lastBlockState);
        nbt.func_74778_a("block", block.getRegistryName().toString() + (meta != 0 ? ":" + meta : ""));
    }
}

