/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionCombined;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceAbsolute;
import com.creativemd.littletiles.common.api.ILittlePlacer;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxesSimple;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredient;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import com.creativemd.littletiles.common.util.place.Placement;
import com.creativemd.littletiles.common.util.place.PlacementHelper;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import com.creativemd.littletiles.common.util.place.PlacementPreview;
import com.creativemd.littletiles.common.util.place.PlacementResult;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class LittleActionPlaceStack
extends LittleAction {
    public PlacementPosition position;
    public boolean centered;
    public boolean fixed;
    public PlacementMode mode;
    public LittlePreviews previews;
    public PlacementResult placedTiles;
    public LittleBoxes boxes;
    public LittleAbsolutePreviews destroyed;

    public LittleActionPlaceStack(LittlePreviews previews, PlacementPosition position, boolean centered, boolean fixed, PlacementMode mode) {
        this.position = position;
        this.centered = centered;
        this.fixed = fixed;
        this.mode = mode;
        this.previews = previews;
    }

    public LittleActionPlaceStack() {
    }

    public void checkMode(LittlePreviews previews) {
        if (previews.hasStructure() && !this.mode.canPlaceStructures()) {
            System.out.println("Using invalid mode for placing structure. mode=" + this.mode.name);
            this.mode = PlacementMode.getStructureDefault();
        }
    }

    public void checkMode(LittleStructure structure) {
        if (structure != null && !this.mode.canPlaceStructures()) {
            System.out.println("Using invalid mode for placing structure. mode=" + this.mode.name);
            this.mode = PlacementMode.getStructureDefault();
        }
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert(EntityPlayer player) {
        this.boxes.convertToSmallest();
        if (this.destroyed != null) {
            this.destroyed.convertToSmallest();
            return new LittleActionCombined(new LittleActionDestroyBoxes(this.boxes), new LittleActionPlaceAbsolute(this.destroyed, PlacementMode.normal, true));
        }
        return new LittleActionDestroyBoxes(this.boxes);
    }

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        ItemStack stack = player.func_184614_ca();
        World world = player.field_70170_p;
        if (!LittleActionPlaceStack.isAllowedToInteract(world, player, this.position.getPos(), true, EnumFacing.EAST)) {
            LittleActionPlaceStack.sendBlockResetToClient(world, player, this.position.getPos());
            return false;
        }
        if (PlacementHelper.getLittleInterface(stack) != null) {
            PlacementResult tiles = this.placeTile(player, stack, player.field_70170_p, this.position, this.centered, this.fixed, this.mode);
            if (!player.field_70170_p.field_72995_K) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                Slot slot = playerMP.field_71070_bA.func_75147_a((IInventory)playerMP.field_71071_by, playerMP.field_71071_by.field_70461_c);
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(playerMP.field_71070_bA.field_75152_c, slot.field_75222_d, playerMP.field_71071_by.func_70448_g()));
            }
            return tiles != null;
        }
        return false;
    }

    public void writeBytes(ByteBuf buf) {
        this.position.writeToBytes(buf);
        buf.writeBoolean(this.centered);
        buf.writeBoolean(this.fixed);
        LittleActionPlaceStack.writePlacementMode(this.mode, buf);
        LittleActionPlaceStack.writePreviews(this.previews, buf);
    }

    public void readBytes(ByteBuf buf) {
        this.position = PlacementPosition.readFromBytes(buf);
        this.centered = buf.readBoolean();
        this.fixed = buf.readBoolean();
        this.mode = LittleActionPlaceStack.readPlacementMode(buf);
        this.previews = LittleActionPlaceStack.readPreviews(buf);
    }

    public PlacementResult placeTile(EntityPlayer player, ItemStack stack, World world, PlacementPosition position, boolean centered, boolean fixed, PlacementMode mode) throws LittleActionException {
        ILittlePlacer iTile = PlacementHelper.getLittleInterface(stack);
        this.checkMode(this.previews);
        PlacementPreview result = PlacementHelper.getPreviews(world, this.previews, iTile.getPreviewsContext(stack), stack, position, centered, fixed, false, mode);
        if (result == null) {
            return null;
        }
        ItemStack toPlace = stack.func_77946_l();
        LittleInventory inventory = new LittleInventory(player);
        if (LittleActionPlaceStack.needIngredients(player) && !iTile.containsIngredients(stack)) {
            LittleActionPlaceStack.canTake(player, inventory, LittleActionPlaceStack.getIngredients(result.previews));
        }
        Placement placement = new Placement(player, result).setStack(toPlace);
        this.placedTiles = placement.place();
        if (this.placedTiles != null) {
            this.boxes = this.placedTiles.placedBoxes;
            if (LittleActionPlaceStack.needIngredients(player)) {
                LittleActionPlaceStack.checkAndGive(player, inventory, placement.overflow());
                if (iTile.containsIngredients(stack)) {
                    stack.func_190918_g(1);
                    LittleActionPlaceStack.checkAndGive(player, inventory, LittleActionPlaceStack.getIngredients(placement.unplaceableTiles));
                } else {
                    LittleIngredients ingredients = LittleIngredient.extractStructureOnly(this.previews);
                    ingredients.add(LittleActionPlaceStack.getIngredients(this.placedTiles.placedPreviews));
                    LittleActionPlaceStack.take(player, inventory, ingredients);
                }
            }
            if (!placement.removedTiles.isEmpty()) {
                this.destroyed = placement.removedTiles.copy();
            }
        } else {
            this.boxes = new LittleBoxesSimple(position.getPos(), result.context);
        }
        return this.placedTiles;
    }

    @Override
    public LittleAction flip(EnumFacing.Axis axis, LittleAbsoluteBox box) {
        if (this.placedTiles == null) {
            return null;
        }
        return new LittleActionPlaceAbsolute(this.placedTiles.placedPreviews.copy(), this.mode);
    }
}

