/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.tool;

import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.LittleActionInteract;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxesSimple;
import com.creativemd.littletiles.common.tile.math.location.TileLocation;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.ingredient.BlockIngredient;
import com.creativemd.littletiles.common.util.ingredient.BlockIngredientEntry;
import com.creativemd.littletiles.common.util.ingredient.ColorIngredient;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class LittleActionSaw
extends LittleActionInteract {
    public boolean toLimit;
    public LittleGridContext context;
    public LittleBox oldBox = null;
    public LittleBoxes newBoxes;
    public TileLocation location = null;
    public EnumFacing facing;

    public LittleActionSaw(World world, BlockPos blockPos, EntityPlayer player, boolean toLimit, LittleGridContext context) {
        super(world, blockPos, player);
        this.toLimit = toLimit;
        this.context = context;
    }

    public LittleActionSaw() {
    }

    @Override
    protected boolean isRightClick() {
        return true;
    }

    @Override
    public RayTraceResult rayTrace(TileEntityLittleTiles te, LittleTile tile, Vec3d pos, Vec3d look) {
        return new LittleBox(tile.getBox()).calculateIntercept(te.getContext(), te.func_174877_v(), pos, look);
    }

    @Override
    protected boolean action(World world, TileEntityLittleTiles te, IParentTileList parent, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, boolean secondMode) throws LittleActionException {
        this.facing = moving.field_178784_b;
        if (!parent.isStructure() && tile.canSawResizeTile(this.facing, player)) {
            LittleBox box;
            EnumFacing.Axis axis = this.facing.func_176740_k();
            if (te.getContext() != this.context) {
                if (this.context.size > te.getContext().size) {
                    te.convertTo(this.context);
                } else {
                    this.context = te.getContext();
                }
            }
            this.oldBox = tile.getBox().copy();
            boolean outside = false;
            if (secondMode) {
                box = tile.getBox().shrink(this.facing, this.toLimit);
            } else {
                box = tile.getBox().grow(this.facing);
                if (tile.getBox().isFaceAtEdge(te.getContext(), this.facing)) {
                    BlockPos newPos = te.func_174877_v().func_177972_a(this.facing);
                    if ((box = box.createOutsideBlockBox(te.getContext(), this.facing)) == null) {
                        return false;
                    }
                    LittleGridContext context = LittleGridContext.get(box.getSmallestContext(te.getContext()));
                    te = LittleActionSaw.loadTe(player, world, newPos, null, false, 0);
                    if (te == null) {
                        return false;
                    }
                    if (context != te.getContext()) {
                        if (context.size > te.getContext().size) {
                            te.convertTo(context);
                        } else {
                            box.convertTo(context, te.getContext());
                        }
                    }
                    outside = true;
                }
                if (this.toLimit) {
                    LittleBox before = null;
                    while (!box.isFaceAtEdge(te.getContext(), this.facing) && te.isSpaceForLittleTile(box, (x, y) -> y != tile)) {
                        before = box;
                        box = box.grow(this.facing);
                    }
                    if (!te.isSpaceForLittleTile(box, (x, y) -> y != tile)) {
                        box = before;
                    }
                } else if (!te.isSpaceForLittleTile(box, (x, y) -> y != tile)) {
                    box = null;
                }
            }
            if (box != null) {
                double amount = outside ? box.getPercentVolume(te.getContext()) : Math.abs(box.getPercentVolume(te.getContext()) - tile.getBox().getPercentVolume(te.getContext()));
                LittleIngredients ingredients = new LittleIngredients();
                LittleInventory inventory = new LittleInventory(player);
                BlockIngredient blocks = new BlockIngredient();
                LittlePreview preview = tile.getPreviewTile();
                BlockIngredientEntry block = preview.getBlockIngredient(te.getContext());
                if (block != null) {
                    block.value = amount;
                    blocks.add(block);
                    ingredients.set(blocks.getClass(), blocks);
                    ColorIngredient unit = null;
                    if (preview.hasColor()) {
                        unit = ColorIngredient.getColors(preview.getColor());
                        unit.scaleLoose(amount);
                        ingredients.set(unit.getClass(), unit);
                    }
                    if (secondMode) {
                        LittleActionSaw.give(player, inventory, ingredients);
                    } else {
                        LittleActionSaw.take(player, inventory, ingredients);
                    }
                }
                if (outside) {
                    LittleTile newTile = tile.copy();
                    newTile.setBox(box);
                    te.updateTiles(x -> x.noneStructureTiles().add(newTile));
                    this.newBoxes = new LittleBoxesSimple(te.func_174877_v(), te.getContext());
                    this.newBoxes.addBox(parent, newTile);
                    te.convertToSmallest();
                    return true;
                }
                tile.setBox(box);
                te.updateTiles();
                this.location = new TileLocation(parent, tile);
                te.convertToSmallest();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert(EntityPlayer player) {
        if (this.newBoxes != null) {
            return new LittleActionDestroyBoxes(this.newBoxes);
        }
        return new LittleActionSawRevert(this.context, this.location, this.oldBox, this.facing);
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        super.writeBytes(buf);
        buf.writeBoolean(this.toLimit);
        LittleActionSaw.writeContext(this.context, buf);
    }

    @Override
    public void readBytes(ByteBuf buf) {
        super.readBytes(buf);
        this.toLimit = buf.readBoolean();
        this.context = LittleActionSaw.readContext(buf);
    }

    @Override
    public LittleAction flip(EnumFacing.Axis axis, LittleAbsoluteBox box) {
        return null;
    }

    @Override
    protected boolean requiresBreakEvent() {
        return false;
    }

    public static class LittleActionSawRevert
    extends LittleAction {
        public LittleBox oldBox;
        public LittleBox replacedBox;
        public TileLocation location;
        public TileLocation newLocation;
        public EnumFacing facing;
        public LittleGridContext context;

        public LittleActionSawRevert(LittleGridContext context, TileLocation location, LittleBox oldBox, EnumFacing facing) {
            this.location = location;
            this.oldBox = oldBox;
            this.facing = facing;
            this.context = context;
        }

        public LittleActionSawRevert() {
        }

        @Override
        public boolean canBeReverted() {
            return true;
        }

        @Override
        public LittleAction revert(EntityPlayer player) throws LittleActionException {
            return new LittleActionSawRevert(this.context, this.newLocation, this.replacedBox, this.facing.func_176734_d());
        }

        @Override
        protected boolean action(EntityPlayer player) throws LittleActionException {
            Pair<IParentTileList, LittleTile> pair = this.location.find(player.field_70170_p);
            LittleTile tile = (LittleTile)pair.value;
            if (tile.canSawResizeTile(this.facing, player)) {
                if (this.context != ((IParentTileList)pair.key).getContext()) {
                    if (this.context.size > ((IParentTileList)pair.key).getContext().size) {
                        ((IParentTileList)pair.key).getTe().convertTo(this.context);
                    } else {
                        this.oldBox.convertTo(this.context, ((IParentTileList)pair.key).getContext());
                        this.context = ((IParentTileList)pair.key).getContext();
                    }
                }
                double amount = Math.abs(this.oldBox.getPercentVolume(this.context) - tile.getBox().getPercentVolume(((IParentTileList)pair.key).getContext()));
                LittlePreview preview = tile.getPreviewTile();
                LittleIngredients ingredients = new LittleIngredients();
                BlockIngredient blocks = new BlockIngredient();
                BlockIngredientEntry block = preview.getBlockIngredient(((IParentTileList)pair.key).getContext());
                if (block != null) {
                    LittleInventory inventory = new LittleInventory(player);
                    block.value = amount;
                    blocks.add(block);
                    ingredients.set(blocks.getClass(), blocks);
                    ColorIngredient unit = null;
                    if (preview.hasColor()) {
                        unit = ColorIngredient.getColors(preview.getColor());
                        unit.scaleLoose(amount);
                        ingredients.set(unit.getClass(), unit);
                    }
                    if (this.oldBox.getVolume() < tile.getBox().getVolume()) {
                        LittleActionSawRevert.give(player, inventory, ingredients);
                    } else {
                        LittleActionSawRevert.take(player, inventory, ingredients);
                    }
                }
                this.replacedBox = tile.getBox().copy();
                tile.setBox(this.oldBox.copy());
                ((IParentTileList)pair.key).getTe().convertToSmallest();
                ((IParentTileList)pair.key).getTe().updateTiles();
                this.newLocation = new TileLocation((IParentTileList)pair.key, tile);
                return true;
            }
            return false;
        }

        public void writeBytes(ByteBuf buf) {
            LittleActionSawRevert.writeTileLocation(this.location, buf);
            LittleActionSawRevert.writeLittleBox(this.oldBox, buf);
            LittleActionSawRevert.writeFacing((ByteBuf)buf, (EnumFacing)this.facing);
            LittleActionSawRevert.writeContext(this.context, buf);
        }

        public void readBytes(ByteBuf buf) {
            this.location = LittleActionSawRevert.readTileLocation(buf);
            this.oldBox = LittleActionSawRevert.readLittleBox(buf);
            this.facing = LittleActionSawRevert.readFacing((ByteBuf)buf);
            this.context = LittleActionSawRevert.readContext(buf);
        }

        @Override
        public LittleAction flip(EnumFacing.Axis axis, LittleAbsoluteBox box) {
            return null;
        }
    }
}

