/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.item;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.mc.NBTUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.client.gui.configure.SubGuiModeSelector;
import com.creativemd.littletiles.client.render.cache.ItemModelCache;
import com.creativemd.littletiles.common.api.ILittlePlacer;
import com.creativemd.littletiles.common.item.ItemLittleChisel;
import com.creativemd.littletiles.common.item.ItemMultiTiles;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPremadeStructure
extends Item
implements ICreativeRendered,
ILittlePlacer {
    private static HashMap<String, LittlePreviews> cachedPreviews = new HashMap();

    public ItemPremadeStructure() {
        this.func_77637_a(LittleTiles.littleTab);
        this.field_77787_bX = true;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + ItemPremadeStructure.getPremadeId(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public List<RenderBox> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("structure")) {
            return Collections.EMPTY_LIST;
        }
        LittleStructurePremade.LittleStructureTypePremade premade = LittleStructurePremade.getType(stack.func_77978_p().func_74775_l("structure").func_74779_i("id"));
        if (premade == null) {
            return Collections.EMPTY_LIST;
        }
        LittlePreviews previews = this.getLittlePreview(stack);
        if (previews == null) {
            return Collections.EMPTY_LIST;
        }
        List<RenderBox> cubes = premade.getRenderingCubes(previews);
        if (cubes == null) {
            cubes = new ArrayList<RenderBox>();
            for (LittlePreview preview : previews.allPreviews()) {
                if (preview.isInvisible()) continue;
                cubes.add(preview.getCubeBlock(previews.getContext()));
            }
            LittlePreview.shrinkCubesToOneBlock(cubes);
        }
        return cubes;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public LittleGridContext getPositionContext(ItemStack stack) {
        return ItemMultiTiles.currentContext;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUIAdvanced(EntityPlayer player, ItemStack stack) {
        return new SubGuiModeSelector(stack, ItemMultiTiles.currentContext, ItemLittleChisel.currentMode){

            @Override
            public void saveConfiguration(LittleGridContext context, PlacementMode mode) {
                ItemLittleChisel.currentMode = mode;
                ItemMultiTiles.currentContext = context;
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public void saveCachedModel(EnumFacing facing, BlockRenderLayer layer, List<BakedQuad> cachedQuads, IBlockState state, TileEntity te, ItemStack stack, boolean threaded) {
        if (stack != null) {
            ItemModelCache.cacheModel(stack, facing, cachedQuads);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getCachedModel(EnumFacing facing, BlockRenderLayer layer, IBlockState state, TileEntity te, ItemStack stack, boolean threaded) {
        if (stack == null) {
            return null;
        }
        return ItemModelCache.requestCache(stack, facing);
    }

    public boolean isInCreativeTab(CreativeTabs targetTab, LittleStructurePremade.LittleStructureTypePremade type) {
        CreativeTabs tab = type.getCustomTab();
        if (tab == null) {
            tab = this.func_77640_w();
        }
        if (tab == targetTab) {
            return true;
        }
        return tab != null && (targetTab == CreativeTabs.field_78027_g || targetTab == tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (LittleStructurePremade.LittleStructureTypePremade entry : LittleStructurePremade.getPremadeStructureTypes()) {
            if (!entry.showInCreativeTab || !this.isInCreativeTab(tab, entry)) continue;
            list.add((Object)entry.createItemStack());
        }
    }

    @Override
    public boolean hasLittlePreview(ItemStack stack) {
        String id = ItemPremadeStructure.getPremadeId(stack);
        return LittleStructurePremade.getStructurePremadeEntry(id) != null;
    }

    public void removeUnnecessaryData(ItemStack stack) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o("tiles");
            stack.func_77978_p().func_82580_o("size");
            stack.func_77978_p().func_82580_o("min");
        }
    }

    public static void clearCache() {
        cachedPreviews.clear();
    }

    private LittlePreviews getPreviews(String id) {
        if (cachedPreviews.containsKey(id)) {
            return cachedPreviews.get(id).copy();
        }
        LittlePreviews previews = LittleStructurePremade.getPreviews(id);
        if (previews != null) {
            return previews.copy();
        }
        return null;
    }

    @Override
    public LittlePreviews getLittlePreview(ItemStack stack) {
        String id = ItemPremadeStructure.getPremadeId(stack);
        LittlePreviews previews = this.getPreviews(id);
        if (previews != null && previews.structureNBT != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("structure")) {
            NBTUtils.mergeNotOverwrite((NBTTagCompound)previews.structureNBT, (NBTTagCompound)stack.func_77978_p().func_74775_l("structure"));
        }
        return previews;
    }

    @Override
    public void rotate(EntityPlayer player, ItemStack stack, Rotation rotation, boolean client) {
        String id = ItemPremadeStructure.getPremadeId(stack);
        LittlePreviews previews = this.getPreviews(id);
        if (previews.isEmpty()) {
            return;
        }
        previews.rotatePreviews(rotation, previews.getContext().rotationCenter);
        this.saveLittlePreview(stack, previews);
    }

    @Override
    public void flip(EntityPlayer player, ItemStack stack, EnumFacing.Axis axis, boolean client) {
        String id = ItemPremadeStructure.getPremadeId(stack);
        LittlePreviews previews = this.getPreviews(id);
        if (previews.isEmpty()) {
            return;
        }
        previews.flipPreviews(axis, previews.getContext().rotationCenter);
        this.saveLittlePreview(stack, previews);
    }

    @Override
    public void saveLittlePreview(ItemStack stack, LittlePreviews previews) {
        cachedPreviews.put(ItemPremadeStructure.getPremadeId(stack), previews);
    }

    @Override
    public boolean sendTransformationUpdate() {
        return false;
    }

    @Override
    public boolean containsIngredients(ItemStack stack) {
        return true;
    }

    @Override
    public PlacementMode getPlacementMode(ItemStack stack) {
        if (!ItemMultiTiles.currentMode.canPlaceStructures()) {
            return PlacementMode.getStructureDefault();
        }
        return ItemMultiTiles.currentMode;
    }

    @Override
    public boolean shouldCache() {
        return false;
    }

    @Override
    public boolean snapToGridByDefault(ItemStack stack) {
        LittleStructureType type = LittleStructureRegistry.getStructureType(ItemPremadeStructure.getPremadeId(stack));
        if (type instanceof LittleStructurePremade.LittleStructureTypePremade) {
            return ((LittleStructurePremade.LittleStructureTypePremade)type).snapToGrid;
        }
        return false;
    }

    public static String getPremadeId(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74775_l("structure").func_74779_i("id");
        }
        return null;
    }

    public static LittleStructurePremade.LittleStructurePremadeEntry getPremade(ItemStack stack) {
        if (stack.func_77942_o()) {
            return LittleStructurePremade.getStructurePremadeEntry(stack.func_77978_p().func_74775_l("structure").func_74779_i("id"));
        }
        return null;
    }
}

