/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.morphspellpack;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="morphspellpack", name="morphspellpack")
public class Settings {
    @Config.Name(value="General Settings")
    @Config.LangKey(value="settings.morphspellpack:general_settings")
    public static GeneralSettings generalSettings = new GeneralSettings();

    public static class GeneralSettings {
        @Config.Name(value="Skinchanger spell - mob blacklist")
        @Config.Comment(value={"Players cannot morph into these mobs using the Skinchanger spell"})
        public String[] skinchanger_banned_mobs = new String[]{""};
        @Config.Name(value="Skinchanger spell - disallow undeads")
        @Config.Comment(value={"Players cannot morph into undeads using the Skinchanger spell"})
        public boolean skinchanger_disallow_undeads = true;
        @Config.Name(value="Rabbitify spell - mob blacklist")
        @Config.Comment(value={"Players cannot morph these entities using the Rabbitify spell"})
        public String[] rabbitify_banned_mobs = new String[]{"minecraft:rabbit"};
        @Config.Name(value="Druid Stone - list is blacklist")
        @Config.Comment(value={"If true: the Druid Stone - mob list acts as a blacklist. If False, the list acts as an entity whitelist"})
        public boolean druid_stone_list_is_blacklist = true;
        @Config.Name(value="Druid Stone - mob list")
        @Config.Comment(value={"Also see the other related setting"})
        public String[] druid_stone_mob_list = new String[]{"minecraft:dragon", "minecraft:wither"};
        @Config.Name(value="Soul Phylactery - list is blacklist")
        @Config.Comment(value={"If true: the Soul Phylactery - mob list acts as a blacklist. If False, the list acts as an entity whitelist"})
        public boolean soul_phylactery_list_is_blacklist = true;
        @Config.Name(value="Soul Phylactery - mob list")
        @Config.Comment(value={"Also see the other related setting"})
        public String[] soul_phylactery_mob_list = new String[]{"minecraft:dragon", "minecraft:wither"};
        @Config.Name(value="Soul Phylactery - percent gain per kill")
        @Config.Comment(value={"Must be between 0 and 1"})
        public float soul_phylactery_percent_gain_per_kill = 0.05f;
        @Config.Name(value="Soul Phylactery - cost of use")
        @Config.Comment(value={"Must be between 0 and 1"})
        public float soul_phylactery_cost_of_use = 0.2f;
        @Config.Name(value="Curse of Transformation - mob list")
        @Config.Comment(value={"Players can be transformed to these entities"})
        public String[] curse_of_transformation_mob_list = new String[]{"morphspellpack:temporary_rabbit", "minecraft:chicken", "morphspellpack:bat_minion"};
        @Config.Name(value="Druid Stone effect duration")
        @Config.Comment(value={"The Druid Stone artefact will transform the player for this duration in ticks"})
        public int druid_stone_duration = 300;
    }

    @Mod.EventBusSubscriber(modid="morphspellpack")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("morphspellpack")) {
                ConfigManager.sync((String)"morphspellpack", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

