/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.morphspellpack.ability.active;

import com.windanesz.morphspellpack.ability.IActiveAbility;
import me.ichun.mods.morph.api.ability.Ability;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class AbilityTimedPotion
extends Ability
implements IActiveAbility {
    public static final String name = "timedPotion";
    private String potionName;
    public Boolean toggled;
    public int cooldown = 0;
    public int maxCooldown = 0;
    public int effectDuration = 0;
    Potion potion;

    public AbilityTimedPotion() {
    }

    public AbilityTimedPotion(String potion, int maxCooldown, int effectDuration) {
        this.potionName = potion;
        this.maxCooldown = maxCooldown;
        this.effectDuration = effectDuration;
        this.potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(potion));
    }

    public Ability parse(String[] args) {
        this.potionName = args[0];
        this.maxCooldown = Integer.parseInt(args[1]);
        this.effectDuration = Integer.parseInt(args[2]);
        return this;
    }

    public Ability clone() {
        return new AbilityTimedPotion(this.potionName, this.maxCooldown, this.effectDuration);
    }

    public String getType() {
        return name;
    }

    public void tick() {
        if (this.cooldown > 0) {
            --this.cooldown;
            this.toggled = false;
        }
        if (this.toggled != null && this.toggled.booleanValue() && this.conditionPredicate() && this.potion != null && this.getParent() instanceof EntityPlayerMP) {
            EntityPlayerMP caster = (EntityPlayerMP)this.getParent();
            caster.func_70690_d(new PotionEffect(this.potion, this.effectDuration));
        }
        this.toggled = false;
    }

    @Override
    public void toggleAbility() {
        this.toggled = true;
    }
}

