/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.morphspellpack.items;

import com.windanesz.morphspellpack.Settings;
import com.windanesz.morphspellpack.handler.LichHandler;
import com.windanesz.morphspellpack.spell.SpellTransformation;
import com.windanesz.wizardryutils.integration.baubles.BaublesIntegration;
import com.windanesz.wizardryutils.item.ITickableArtefact;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.util.BlockUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSoulPhylactery
extends ItemArtefact
implements IWorkbenchItem,
ITickableArtefact {
    public static final String ENTITY_TAG = "Entity";
    public static final String PERCENT_TAG = "PercentageFull";

    public ItemSoulPhylactery(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
        this.func_185043_a(new ResourceLocation("soul"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return ItemSoulPhylactery.getPercentFilled(stack);
            }
        });
    }

    public static boolean isAllowedEnity(String entity) {
        List<String> entities = Arrays.asList(Settings.generalSettings.soul_phylactery_mob_list);
        boolean blacklist = Settings.generalSettings.soul_phylactery_list_is_blacklist;
        if (blacklist && entities.contains(entity)) {
            return false;
        }
        return blacklist || entities.contains(entity);
    }

    public static boolean hasEntity(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(ENTITY_TAG);
    }

    public static ItemStack setEntity(ItemStack stack, String entity) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a(ENTITY_TAG, entity);
        nbt.func_74776_a(PERCENT_TAG, 0.0f);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static String getEntity(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(ENTITY_TAG) ? stack.func_77978_p().func_74779_i(ENTITY_TAG) : "";
    }

    public static ItemStack addPercent(ItemStack stack, float percentToAdd) {
        float percent = percentToAdd;
        NBTTagCompound nbt = new NBTTagCompound();
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b(PERCENT_TAG)) {
            percent = nbt.func_74760_g(PERCENT_TAG);
            percent = Math.min(percent + percentToAdd, 1.0f);
        }
        nbt.func_74776_a(PERCENT_TAG, percent);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static ItemStack consumePercent(ItemStack stack, float percentToConsume) {
        float percent = percentToConsume;
        NBTTagCompound nbt = new NBTTagCompound();
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b(PERCENT_TAG)) {
            percent = nbt.func_74760_g(PERCENT_TAG);
            percent = Math.max(percent - percentToConsume, 0.0f);
            nbt.func_74776_a(PERCENT_TAG, percent);
        }
        stack.func_77982_d(nbt);
        return stack;
    }

    public static float getPercentFilled(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(PERCENT_TAG) ? stack.func_77978_p().func_74760_g(PERCENT_TAG) : 0.0f;
    }

    public boolean func_77636_d(ItemStack stack) {
        return ItemSoulPhylactery.getPercentFilled(stack) == 1.0f;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (world != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(ENTITY_TAG)) {
            EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(stack.func_77978_p().func_74779_i(ENTITY_TAG)));
            String entity = entry != null ? entry.newInstance(world).func_70005_c_() : stack.func_77978_p().func_74779_i(ENTITY_TAG);
            int fill = (int)(ItemSoulPhylactery.getPercentFilled(stack) * 100.0f);
            Wizardry.proxy.addMultiLineDescription(tooltip, "item.morphspellpack:charm_soul_phylactery.status", new Object[]{fill, entity});
        } else {
            Wizardry.proxy.addMultiLineDescription(tooltip, "item.morphspellpack:charm_soul_phylactery.desc_initial", new Object[0]);
        }
        super.func_77624_a(stack, world, tooltip, advanced);
    }

    public int getSpellSlotCount(ItemStack stack) {
        return 0;
    }

    public boolean onApplyButtonPressed(EntityPlayer player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        if (centre.func_75211_c().func_77942_o()) {
            NBTTagCompound nbt = centre.func_75211_c().func_77978_p();
            nbt.func_82580_o(ENTITY_TAG);
            nbt.func_82580_o(PERCENT_TAG);
            centre.func_75211_c().func_77982_d(nbt);
            return true;
        }
        return false;
    }

    public boolean showTooltip(ItemStack stack) {
        return false;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (ItemSoulPhylactery.getPercentFilled(itemstack) >= Settings.generalSettings.soul_phylactery_cost_of_use) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    public ItemStack func_77654_b(ItemStack itemstack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer && LichHandler.isLich((Entity)entityLiving) && ItemSoulPhylactery.getPercentFilled(itemstack) >= Settings.generalSettings.soul_phylactery_cost_of_use) {
            ItemSoulPhylactery.consumePercent(itemstack, Settings.generalSettings.soul_phylactery_cost_of_use);
            ((EntityPlayer)entityLiving).func_71024_bL().func_75122_a(2, 0.1f);
            return itemstack;
        }
        if (entityLiving instanceof EntityPlayer && ItemSoulPhylactery.getPercentFilled(itemstack) >= Settings.generalSettings.soul_phylactery_cost_of_use) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187922_gv, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            ItemSoulPhylactery.consumePercent(itemstack, Settings.generalSettings.soul_phylactery_cost_of_use);
            SpellTransformation.morphPlayer((EntityLivingBase)entityplayer, ItemSoulPhylactery.getEntity(itemstack), 320);
        }
        return itemstack;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public void onWornTick(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        EntityPlayer player;
        if (entityLivingBase.field_70173_aa % 20 != 0) {
            return;
        }
        if (ItemSoulPhylactery.hasEntity(itemStack) && !ItemSoulPhylactery.getEntity(itemStack).equals(entityLivingBase.func_70005_c_())) {
            return;
        }
        if (entityLivingBase instanceof EntityPlayer && !entityLivingBase.field_70170_p.field_72995_K && (player = (EntityPlayer)entityLivingBase).func_70027_ad() && !player.func_70644_a(MobEffects.field_76426_n)) {
            BlockPos pos = player.func_180425_c();
            World world = player.field_70170_p;
            int skulls = 0;
            int soulSand = 0;
            for (BlockPos blockPos : BlockUtils.getBlockSphere((BlockPos)pos, (double)4.0)) {
                if (world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150465_bP) {
                    ++skulls;
                }
                if (world.func_180495_p(blockPos).func_177230_c() != Blocks.field_150425_aM) continue;
                ++soulSand;
            }
            if (skulls >= 4 && soulSand >= 8) {
                ItemStack stack = itemStack.func_77946_l();
                if (!ItemSoulPhylactery.hasEntity(stack)) {
                    ItemSoulPhylactery.setEntity(stack, entityLivingBase.func_70005_c_());
                }
                ItemSoulPhylactery.addPercent(stack, 0.05f);
                BaublesIntegration.setArtefactToSlot((EntityPlayer)player, (ItemStack)stack, (ItemArtefact.Type)ItemArtefact.Type.CHARM);
            }
            if (ItemSoulPhylactery.getPercentFilled(itemStack) >= 1.0f) {
                SpellTransformation.morphPlayer(entityLivingBase, "morphspellpack:lich", -1);
                LichHandler.setLich((Entity)entityLivingBase, true);
            }
        }
    }
}

