/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.morphspellpack.spell;

import com.windanesz.morphspellpack.Settings;
import com.windanesz.morphspellpack.entity.living.EntityTemporaryRabbit;
import com.windanesz.morphspellpack.registry.MSItems;
import com.windanesz.morphspellpack.registry.MSPotions;
import com.windanesz.morphspellpack.spell.SpellTransformation;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class CurseOfTransformation
extends SpellRay {
    public CurseOfTransformation() {
        super("morphspellpack", "curse_of_transformation", SpellActions.POINT, false);
        this.soundValues(1.0f, 1.1f, 0.2f);
        this.addProperties(new String[]{"effect_strength"});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (EntityUtils.isLiving((Entity)target)) {
            List<String> entities = Arrays.asList(Settings.generalSettings.curse_of_transformation_mob_list);
            if (target instanceof EntityPlayer) {
                if (!ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)target), (Item)MSItems.amulet_transformation_protection)) {
                    if (!entities.isEmpty()) {
                        String entity = entities.get(world.field_73012_v.nextInt(entities.size() - 1));
                        boolean flag = SpellTransformation.morphPlayer((EntityLivingBase)target, entity, 20);
                        ((EntityLivingBase)target).func_70690_d(new PotionEffect(MSPotions.curse_of_transformation, Integer.MAX_VALUE, this.getProperty("effect_strength").intValue() + SpellBuff.getStandardBonusAmplifier((float)modifiers.get("potency"))));
                        return flag;
                    }
                } else if (!world.field_72995_K && ticksInUse == 1 && caster instanceof EntityPlayer) {
                    ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
                    return false;
                }
            }
            if (target.func_184222_aU() && !world.field_72995_K && !target.func_190530_aW() && !(target instanceof EntityTemporaryRabbit)) {
                EntityTemporaryRabbit rabbit = new EntityTemporaryRabbit(world);
                rabbit.storeEntity((EntityLivingBase)target);
                rabbit.func_70080_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, target.field_70177_z, target.field_70125_A);
                rabbit.setLifetimeAsRabbit(Integer.MAX_VALUE);
                world.func_72838_d((Entity)rabbit);
                world.func_72900_e(target);
            } else if (!world.field_72995_K && ticksInUse == 1 && caster instanceof EntityPlayer) {
                ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
            }
        }
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(0.2f, 0.0f, 0.3f).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(0.1f, 0.0f, 0.0f).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(12 + world.field_73012_v.nextInt(8)).clr(0.4f, 0.0f, 0.0f).spawn(world);
    }
}

