/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.morphspellpack.spell;

import com.windanesz.morphspellpack.handler.LichHandler;
import com.windanesz.morphspellpack.registry.MSItems;
import com.windanesz.morphspellpack.registry.MSPotions;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.handler.PlayerMorphHandler;
import me.ichun.mods.morph.common.morph.MorphInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class SpellTransformation
extends Spell {
    public static final IStoredVariable<Integer> MORPH_DURATION = IStoredVariable.StoredVariable.ofInt((String)"morphCountdown", (Persistence)Persistence.ALWAYS).withTicker(SpellTransformation::update);
    public static final IStoredVariable<String> LAST_MORPH = IStoredVariable.StoredVariable.ofString((String)"lastMorph", (Persistence)Persistence.ALWAYS);
    String morph;

    public SpellTransformation(String name, EnumAction action, boolean isContinuous, String morph) {
        super("morphspellpack", name, action, isContinuous);
        this.morph = morph;
        this.addProperties(new String[]{"duration"});
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{MORPH_DURATION, LAST_MORPH});
    }

    public static boolean isShapeLocked(EntityLivingBase entityLiving) {
        return entityLiving.func_70644_a(MSPotions.shape_lock) || entityLiving.func_70644_a(MSPotions.curse_of_transformation);
    }

    private static Integer update(EntityPlayer player, Integer countdown) {
        if (LichHandler.isLich((Entity)player) && player.field_70173_aa == 20) {
            SpellTransformation.morphPlayer((EntityLivingBase)player, "morphspellpack:lich", 5);
        }
        if (countdown == null) {
            return 0;
        }
        if (!player.field_70170_p.field_72995_K && !SpellTransformation.isShapeLocked((EntityLivingBase)player)) {
            if (countdown > 0) {
                Integer n = countdown;
                Integer n2 = countdown = Integer.valueOf(countdown - 1);
            }
            if (countdown == 1 && Morph.eventHandlerServer.morphsActive.containsKey(player.func_70005_c_())) {
                SpellTransformation.demorphPlayer((EntityLivingBase)player);
            }
        }
        return countdown;
    }

    public static boolean morphPlayer(EntityLivingBase player, String ent, int duration) {
        if (!(player instanceof EntityPlayerMP) && SpellTransformation.isShapeLocked(player)) {
            return false;
        }
        Entity entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(ent), (World)player.field_70170_p);
        if (entity instanceof EntityLivingBase && player instanceof EntityPlayerMP) {
            if (!PlayerMorphHandler.getInstance().forceMorph((EntityPlayerMP)player, (EntityLivingBase)entity)) {
                return false;
            }
            WizardData data = WizardData.get((EntityPlayer)((EntityPlayer)player));
            if (data != null) {
                if (ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)player), (Item)MSItems.ring_transformation)) {
                    duration *= 2;
                }
                data.setVariable(LAST_MORPH, (Object)ent);
                data.setVariable(MORPH_DURATION, (Object)duration);
                data.sync();
            }
            return true;
        }
        return false;
    }

    public static boolean demorphPlayer(EntityLivingBase player) {
        if (player != null && SpellTransformation.isShapeLocked(player)) {
            return false;
        }
        if (player instanceof EntityPlayerMP) {
            if (LichHandler.isLich((Entity)player)) {
                SpellTransformation.morphPlayer(player, "morphspellpack:lich", -1);
                return true;
            }
            if (PlayerMorphHandler.getInstance().forceDemorph((EntityPlayerMP)player)) {
                WizardData data = WizardData.get((EntityPlayer)((EntityPlayer)player));
                if (data != null) {
                    data.setVariable(MORPH_DURATION, (Object)0);
                }
                return true;
            }
        }
        return false;
    }

    public static void resumeMorph(Entity player) {
        WizardData data;
        if (player instanceof EntityPlayer && !player.field_70170_p.field_72995_K && (data = WizardData.get((EntityPlayer)((EntityPlayer)player))) != null) {
            String lastMorph = (String)data.getVariable(LAST_MORPH);
            Integer duration = (Integer)data.getVariable(MORPH_DURATION);
            if (lastMorph != null && duration != null && duration > 0 && !lastMorph.equals("morphspellpack:lich")) {
                SpellTransformation.morphPlayer((EntityLivingBase)((EntityPlayer)player), lastMorph, duration);
            }
        }
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        return this.morph(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers);
    }

    public boolean morph(World world, EntityLivingBase caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (world.field_72995_K) {
            this.playSound(world, caster, ticksInUse, -1, modifiers, new String[0]);
        }
        if (!world.field_72995_K) {
            if (Morph.eventHandlerServer.morphsActive.containsKey(caster.func_70005_c_()) && !((MorphInfo)Morph.eventHandlerServer.morphsActive.get(caster.func_70005_c_())).isMorphing() && !LichHandler.isLich((Entity)caster)) {
                SpellTransformation.demorphPlayer(caster);
                return false;
            }
            int duration = this.getProperty("duration").intValue();
            boolean flag = SpellTransformation.morphPlayer(caster, this.morph, duration);
            if (flag) {
                this.morphExtra(world, caster, this.morph, duration);
            }
            return flag;
        }
        return false;
    }

    public void morphExtra(World world, EntityLivingBase caster, String morph, int morphDuration) {
    }
}

