/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.morphspellpack.spell;

import com.windanesz.morphspellpack.items.ItemSoulPhylactery;
import com.windanesz.morphspellpack.registry.MSItems;
import com.windanesz.wizardryutils.integration.baubles.BaublesIntegration;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TrueResurrection
extends Spell {
    public static final String SOUL_COST = "soul_cost";
    private static final String SUMMON_RADIUS = "summon_radius";
    private static final String MINION_COUNT = "minion_count";

    public TrueResurrection() {
        super("morphspellpack", "true_resurrection", SpellActions.SUMMON, false);
        this.addProperties(new String[]{SOUL_COST, SUMMON_RADIUS, MINION_COUNT});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        ItemStack stack;
        if (ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)MSItems.charm_soul_phylactery) && ItemSoulPhylactery.hasEntity(stack = (ItemStack)BaublesIntegration.getEquippedArtefactStacks((EntityPlayer)caster, (Object[])new Object[]{ItemArtefact.Type.CHARM}).get(0)) && ItemSoulPhylactery.getPercentFilled(stack) >= this.getProperty(SOUL_COST).floatValue()) {
            String entity = ItemSoulPhylactery.getEntity(stack);
            return this.spawnMinions(world, (EntityLivingBase)caster, modifiers, entity);
        }
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    protected boolean spawnMinions(World world, EntityLivingBase caster, SpellModifiers modifiers, String ent) {
        if (!world.field_72995_K) {
            for (int i = 0; i < this.getProperty(MINION_COUNT).intValue(); ++i) {
                int range = this.getProperty(SUMMON_RADIUS).intValue();
                BlockPos pos = BlockUtils.findNearbyFloorSpace((Entity)caster, (int)range, (int)(range * 2));
                if (pos == null) {
                    return false;
                }
                Entity minion = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(ent), (World)caster.field_70170_p);
                if (minion == null) {
                    return false;
                }
                minion.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                if (minion instanceof EntityLiving) {
                    ((EntityLiving)minion).func_180482_a(world.func_175649_E(new BlockPos(minion)), (IEntityLivingData)null);
                }
                if (!(minion instanceof EntityLivingBase)) continue;
                world.func_72838_d(minion);
                float cost = this.getProperty(SOUL_COST).floatValue();
                ItemStack stack = (ItemStack)BaublesIntegration.getEquippedArtefactStacks((EntityPlayer)((EntityPlayer)caster), (Object[])new Object[]{ItemArtefact.Type.CHARM}).get(0);
                ItemSoulPhylactery.consumePercent(stack, cost);
                BaublesIntegration.setArtefactToSlot((EntityPlayer)((EntityPlayer)caster), (ItemStack)stack, (ItemArtefact.Type)ItemArtefact.Type.CHARM);
            }
        }
        return true;
    }
}

