/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.api.aura.chunk;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import java.util.function.BiConsumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.INBTSerializable;

public interface IAuraChunk
extends INBTSerializable<NBTTagCompound> {
    public static final int DEFAULT_AURA = 1000000;

    public static IAuraChunk getAuraChunk(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        if (chunk.hasCapability(NaturesAuraAPI.capAuraChunk, null)) {
            return (IAuraChunk)chunk.getCapability(NaturesAuraAPI.capAuraChunk, null);
        }
        return null;
    }

    public static void getSpotsInArea(World world, BlockPos pos, int radius, BiConsumer<BlockPos, Integer> consumer) {
        NaturesAuraAPI.instance().getAuraSpotsInArea(world, pos, radius, consumer);
    }

    public static int getSpotAmountInArea(World world, BlockPos pos, int radius) {
        return NaturesAuraAPI.instance().getSpotAmountInArea(world, pos, radius);
    }

    public static int getAuraInArea(World world, BlockPos pos, int radius) {
        return NaturesAuraAPI.instance().getAuraInArea(world, pos, radius);
    }

    public static int triangulateAuraInArea(World world, BlockPos pos, int radius) {
        return NaturesAuraAPI.instance().triangulateAuraInArea(world, pos, radius);
    }

    public static BlockPos getLowestSpot(World world, BlockPos pos, int radius, BlockPos defaultSpot) {
        return NaturesAuraAPI.instance().getLowestAuraDrainSpot(world, pos, radius, defaultSpot);
    }

    public static BlockPos getHighestSpot(World world, BlockPos pos, int radius, BlockPos defaultSpot) {
        return NaturesAuraAPI.instance().getHighestAuraDrainSpot(world, pos, radius, defaultSpot);
    }

    public int drainAura(BlockPos var1, int var2, boolean var3, boolean var4);

    public int drainAura(BlockPos var1, int var2);

    public int storeAura(BlockPos var1, int var2, boolean var3, boolean var4);

    public int storeAura(BlockPos var1, int var2);

    public int getDrainSpot(BlockPos var1);

    public IAuraType getType();

    public void markDirty();
}

