/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.packet.PacketClient;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.reg.ICreativeItem;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.IModelProvider;
import de.ellpeck.naturesaura.reg.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class BlockDimensionRail
extends BlockRailBase
implements IModItem,
ICreativeItem,
IModelProvider {
    public static final PropertyEnum<BlockRailBase.EnumRailDirection> SHAPE = PropertyEnum.func_177706_a((String)"shape", BlockRailBase.EnumRailDirection.class, (Enum[])new BlockRailBase.EnumRailDirection[]{BlockRailBase.EnumRailDirection.NORTH_SOUTH, BlockRailBase.EnumRailDirection.EAST_WEST});
    private final String name;
    private final int goalDim;
    private final DimensionType[] canUseDims;

    public BlockDimensionRail(String name, DimensionType goalDim, DimensionType ... canUseDims) {
        super(false);
        this.name = name;
        this.goalDim = goalDim.func_186068_a();
        this.canUseDims = canUseDims;
        this.func_149711_c(0.8f);
        this.func_149672_a(SoundType.field_185852_e);
        ModRegistry.add(this);
    }

    private boolean canUseHere(DimensionType dimension) {
        for (DimensionType dim : this.canUseDims) {
            if (dim != dimension) continue;
            return true;
        }
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (stack.func_77973_b() == ModItems.RANGE_VISUALIZER) {
            if (!worldIn.field_72995_K) {
                BlockPos goalPos = this.getGoalCoords(worldIn, pos);
                PacketHandler.sendTo(playerIn, new PacketClient(0, this.goalDim, goalPos.func_177958_n(), goalPos.func_177956_o(), goalPos.func_177952_p()));
            }
            return true;
        }
        return false;
    }

    public void onMinecartPass(World world, EntityMinecart cart, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        if (cart.func_184207_aI()) {
            return;
        }
        if (!this.canUseHere(world.field_73011_w.func_186058_p())) {
            return;
        }
        AxisAlignedBB box = cart.func_174813_aQ();
        PacketHandler.sendToAllAround(world, pos, 32, new PacketParticles((float)box.field_72340_a, (float)box.field_72338_b, (float)box.field_72339_c, 25, (int)((box.field_72336_d - box.field_72340_a) * 100.0), (int)((box.field_72337_e - box.field_72338_b) * 100.0), (int)((box.field_72334_f - box.field_72339_c) * 100.0)));
        world.func_184133_a(null, pos, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f);
        BlockPos goalCoords = this.getGoalCoords(world, pos);
        cart.changeDimension(this.goalDim, (newWorld, entity, yaw) -> entity.func_174828_a(goalCoords, yaw, entity.field_70125_A));
        BlockPos spot = IAuraChunk.getHighestSpot(world, pos, 35, pos);
        IAuraChunk.getAuraChunk(world, spot).drainAura(spot, 50000);
    }

    private BlockPos getGoalCoords(World world, BlockPos pos) {
        MinecraftServer server = world.func_73046_m();
        if (this == ModBlocks.DIMENSION_RAIL_NETHER) {
            return new BlockPos(pos.func_177958_n() / 8, pos.func_177956_o() / 2, pos.func_177952_p() / 8);
        }
        if (this == ModBlocks.DIMENSION_RAIL_END) {
            WorldServer end = server.func_71218_a(this.goalDim);
            return end.func_180504_m().func_177981_b(8);
        }
        if (world.field_73011_w.func_186058_p() == DimensionType.NETHER) {
            return new BlockPos(pos.func_177958_n() * 8, pos.func_177956_o() * 2, pos.func_177952_p() * 8);
        }
        WorldServer overworld = server.func_71218_a(this.goalDim);
        return overworld.func_175672_r(overworld.func_175694_M());
    }

    public IProperty<BlockRailBase.EnumRailDirection> func_176560_l() {
        return SHAPE;
    }

    public boolean isFlexibleRail(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean canMakeSlopes(IBlockAccess world, BlockPos pos) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SHAPE});
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockRailBase.EnumRailDirection)state.func_177229_b(SHAPE)).func_177015_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.func_177016_a((int)meta));
    }

    @Override
    public String getBaseName() {
        return "dimension_rail_" + this.name;
    }

    @Override
    public void onPreInit(FMLPreInitializationEvent event) {
    }

    @Override
    public void onInit(FMLInitializationEvent event) {
    }

    @Override
    public void onPostInit(FMLPostInitializationEvent event) {
    }
}

