/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityPickupStopper;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPickupStopper
extends BlockContainerImpl
implements IVisualizable {
    public BlockPickupStopper() {
        super(Material.field_151576_e, "pickup_stopper", TileEntityPickupStopper.class, "pickup_stopper");
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(2.0f);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPickup(EntityItemPickupEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player != null && !player.func_70093_af()) {
            EntityItem item = event.getItem();
            BlockPos pos = item.func_180425_c();
            Helper.getTileEntitiesInArea(item.field_70170_p, pos, 8, tile -> {
                if (!(tile instanceof TileEntityPickupStopper)) {
                    return false;
                }
                TileEntityPickupStopper stopper = (TileEntityPickupStopper)((Object)tile);
                float radius = stopper.getRadius();
                if (radius <= 0.0f) {
                    return false;
                }
                BlockPos stopperPos = stopper.func_174877_v();
                if (!new AxisAlignedBB(stopperPos).func_186662_g((double)radius).func_72326_a(item.func_174813_aQ())) {
                    return false;
                }
                event.setCanceled(true);
                if (item.field_70170_p.func_82737_E() % 3L == 0L) {
                    PacketHandler.sendToAllAround(item.field_70170_p, pos, 32, new PacketParticles((float)item.field_70165_t, (float)item.field_70163_u, (float)item.field_70161_v, 14, new int[0]));
                }
                return true;
            });
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getVisualizationBounds(World world, BlockPos pos) {
        double radius;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityPickupStopper && (radius = (double)((TileEntityPickupStopper)tile).getRadius()) > 0.0) {
            return new AxisAlignedBB(pos).func_186662_g(radius);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getVisualizationColor(World world, BlockPos pos) {
        return 16034370;
    }
}

