/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.misc.IWorldData;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.TileEntitySpawnLamp;
import de.ellpeck.naturesaura.misc.WorldData;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSpawnLamp
extends BlockContainerImpl
implements IVisualizable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.8125, 0.75);

    public BlockSpawnLamp() {
        super(Material.field_151573_f, "spawn_lamp", TileEntitySpawnLamp.class, "spawn_lamp");
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.func_149715_a(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(3.0f);
    }

    @SubscribeEvent
    public void onSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getSpawner() != null) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = new BlockPos((double)event.getX(), (double)event.getY(), (double)event.getZ());
        WorldData data = (WorldData)IWorldData.getWorldData(world);
        for (TileEntitySpawnLamp lamp : data.spawnLamps) {
            BlockPos lampPos;
            int range = lamp.getRadius();
            if (range <= 0 || !new AxisAlignedBB(lampPos = lamp.func_174877_v()).func_186662_g((double)range).func_72318_a(new Vec3d((Vec3i)pos))) continue;
            EntityLiving entity = (EntityLiving)event.getEntityLiving();
            if (entity.func_70601_bi() && entity.func_70058_J()) {
                BlockPos spot = IAuraChunk.getHighestSpot(world, lampPos, 32, lampPos);
                IAuraChunk.getAuraChunk(world, spot).drainAura(spot, 200);
                PacketHandler.sendToAllAround(world, lampPos, 32, new PacketParticles(lampPos.func_177958_n(), lampPos.func_177956_o(), lampPos.func_177952_p(), 15, new int[0]));
            }
            event.setResult(Event.Result.DENY);
            break;
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isSideSolid(IBlockState baseState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getVisualizationBounds(World world, BlockPos pos) {
        int radius;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntitySpawnLamp && (radius = ((TileEntitySpawnLamp)tile).getRadius()) > 0) {
            return new AxisAlignedBB(pos).func_186662_g((double)radius);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getVisualizationColor(World world, BlockPos pos) {
        return 8543973;
    }
}

