/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.packet.PacketAuraChunk;
import de.ellpeck.naturesaura.packet.PacketHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.mutable.MutableInt;

public class AuraChunk
implements IAuraChunk {
    private final Chunk chunk;
    private final IAuraType type;
    private final Map<BlockPos, MutableInt> drainSpots = new ConcurrentHashMap<BlockPos, MutableInt>();
    private final List<IDrainSpotEffect> effects = new ArrayList<IDrainSpotEffect>();
    private boolean needsSync;

    public AuraChunk(Chunk chunk, IAuraType type) {
        this.chunk = chunk;
        this.type = type;
        for (Supplier<IDrainSpotEffect> supplier : NaturesAuraAPI.DRAIN_SPOT_EFFECTS.values()) {
            IDrainSpotEffect effect = supplier.get();
            if (!effect.appliesHere(this.chunk, this, this.type)) continue;
            this.effects.add(effect);
        }
    }

    @Override
    public int drainAura(BlockPos pos, int amount, boolean aimForZero, boolean simulate) {
        if (amount <= 0) {
            return 0;
        }
        MutableInt spot = this.getActualDrainSpot(pos, true);
        int curr = spot.intValue();
        if (curr < 0 && curr - amount > 0) {
            return this.drainAura(pos.func_177984_a(), amount, aimForZero, simulate);
        }
        if (aimForZero && curr > 0 && curr - amount < 0) {
            amount = curr;
        }
        if (!simulate) {
            spot.subtract(amount);
            if (spot.intValue() == 0) {
                this.drainSpots.remove(pos);
            }
            this.markDirty();
        }
        return amount;
    }

    @Override
    public int drainAura(BlockPos pos, int amount) {
        return this.drainAura(pos, amount, false, false);
    }

    @Override
    public int storeAura(BlockPos pos, int amount, boolean aimForZero, boolean simulate) {
        if (amount <= 0) {
            return 0;
        }
        MutableInt spot = this.getActualDrainSpot(pos, true);
        int curr = spot.intValue();
        if (curr > 0 && curr + amount < 0) {
            return this.storeAura(pos.func_177984_a(), amount, aimForZero, simulate);
        }
        if (aimForZero && curr < 0 && curr + amount > 0) {
            amount = -curr;
        }
        if (!simulate) {
            spot.add(amount);
            if (spot.intValue() == 0) {
                this.drainSpots.remove(pos);
            }
            this.markDirty();
        }
        return amount;
    }

    @Override
    public int storeAura(BlockPos pos, int amount) {
        return this.storeAura(pos, amount, true, false);
    }

    private MutableInt getActualDrainSpot(BlockPos pos, boolean make) {
        MutableInt spot = this.drainSpots.get(pos);
        if (spot == null && make) {
            spot = new MutableInt();
            this.addDrainSpot(pos, spot);
        }
        return spot;
    }

    @Override
    public int getDrainSpot(BlockPos pos) {
        MutableInt spot = this.getActualDrainSpot(pos, false);
        return spot == null ? 0 : spot.intValue();
    }

    private void addDrainSpot(BlockPos pos, MutableInt spot) {
        int expX = pos.func_177958_n() >> 4;
        int expZ = pos.func_177952_p() >> 4;
        if (expX != this.chunk.field_76635_g || expZ != this.chunk.field_76647_h) {
            throw new IllegalArgumentException("Tried to add drain spot " + pos + " to chunk at " + this.chunk.field_76635_g + ", " + this.chunk.field_76647_h + " when it should've been added to chunk at " + expX + ", " + expZ);
        }
        this.drainSpots.put(pos, spot);
    }

    public void setSpots(Map<BlockPos, MutableInt> spots) {
        this.drainSpots.clear();
        for (Map.Entry<BlockPos, MutableInt> entry : spots.entrySet()) {
            this.addDrainSpot(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public IAuraType getType() {
        return this.type;
    }

    @Override
    public void markDirty() {
        this.chunk.func_76630_e();
        this.needsSync = true;
    }

    public void update() {
        World world = this.chunk.func_177412_p();
        for (Map.Entry<BlockPos, MutableInt> entry : this.drainSpots.entrySet()) {
            BlockPos pos = entry.getKey();
            MutableInt amount = entry.getValue();
            for (IDrainSpotEffect effect : this.effects) {
                world.field_72984_F.func_194340_a(() -> effect.getName().toString());
                effect.update(world, this.chunk, this, pos, amount.intValue());
                world.field_72984_F.func_76319_b();
            }
        }
        if (this.needsSync) {
            PacketHandler.sendToAllLoaded(world, new BlockPos(this.chunk.field_76635_g * 16, 0, this.chunk.field_76647_h * 16), this.makePacket());
            this.needsSync = false;
        }
    }

    public IMessage makePacket() {
        return new PacketAuraChunk(this.chunk.field_76635_g, this.chunk.field_76647_h, this.drainSpots);
    }

    public void getSpotsInArea(BlockPos pos, int radius, BiConsumer<BlockPos, Integer> consumer) {
        for (Map.Entry<BlockPos, MutableInt> entry : this.drainSpots.entrySet()) {
            BlockPos drainPos = entry.getKey();
            if (!(drainPos.func_177951_i((Vec3i)pos) <= (double)(radius * radius))) continue;
            consumer.accept(drainPos, entry.getValue().intValue());
        }
    }

    public void getActiveEffectIcons(EntityPlayer player, Map<ResourceLocation, Tuple<ItemStack, Boolean>> icons) {
        for (IDrainSpotEffect effect : this.effects) {
            Tuple<ItemStack, Boolean> alreadyThere = icons.get(effect.getName());
            if (alreadyThere != null && ((Boolean)alreadyThere.func_76340_b()).booleanValue()) continue;
            for (Map.Entry<BlockPos, MutableInt> entry : this.drainSpots.entrySet()) {
                ItemStack stack;
                MutableInt amount;
                BlockPos pos = entry.getKey();
                int state = effect.isActiveHere(player, this.chunk, this, pos, (amount = entry.getValue()).intValue());
                if (state < 0 || (stack = effect.getDisplayIcon()).func_190926_b()) continue;
                icons.put(effect.getName(), (Tuple<ItemStack, Boolean>)new Tuple((Object)stack, (Object)(state == 0 ? 1 : 0)));
            }
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<BlockPos, MutableInt> entry : this.drainSpots.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74772_a("pos", entry.getKey().func_177986_g());
            tag.func_74768_a("amount", entry.getValue().intValue());
            list.func_74742_a((NBTBase)tag);
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("drain_spots", (NBTBase)list);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.drainSpots.clear();
        NBTTagList list = compound.func_150295_c("drain_spots", 10);
        for (NBTBase base : list) {
            NBTTagCompound tag = (NBTTagCompound)base;
            this.addDrainSpot(BlockPos.func_177969_a((long)tag.func_74763_f("pos")), new MutableInt(tag.func_74762_e("amount")));
        }
    }
}

