/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.jei.animal;

import com.google.common.collect.ImmutableList;
import de.ellpeck.naturesaura.api.recipes.AnimalSpawnerRecipe;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class AnimalSpawnerWrapper
implements IRecipeWrapper {
    public final AnimalSpawnerRecipe recipe;
    private Entity entity;

    public AnimalSpawnerWrapper(AnimalSpawnerRecipe recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Ingredient ing : this.recipe.ingredients) {
            builder.add((Object[])ing.func_193365_a());
        }
        ingredients.setInputs(VanillaTypes.ITEM, (List)builder.build());
        ItemStack egg = new ItemStack(Items.field_151063_bx);
        ItemMonsterPlacer.func_185078_a((ItemStack)egg, (ResourceLocation)this.recipe.entity);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)egg);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.entity == null) {
            this.entity = this.recipe.makeEntity((World)minecraft.field_71441_e, 0.0, 0.0, 0.0);
        }
        float size = Math.max(1.0f, Math.max(this.entity.field_70130_N, this.entity.field_70131_O));
        float rot = ((float)minecraft.field_71441_e.func_82737_E() + minecraft.func_184121_ak()) % 360.0f;
        AnimalSpawnerWrapper.renderEntity(this.entity, 35.0f, 28.0f, rot, 100.0f / size * 0.4f, size * 0.5f);
        String name = this.entity.func_145748_c_().func_150254_d();
        minecraft.field_71466_p.func_175065_a(name, 36.0f - (float)minecraft.field_71466_p.func_78256_a(name) / 2.0f, 55.0f, 0xFFFFFF, true);
    }

    private static void renderEntity(Entity entity, float x, float y, float rotation, float renderScale, float offset) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)x, (float)y, (float)50.0f);
        GlStateManager.func_179152_a((float)(-renderScale), (float)renderScale, (float)renderScale);
        GlStateManager.func_179109_b((float)0.0f, (float)offset, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        Minecraft.func_71410_x().func_175598_ae().field_78735_i = 180.0f;
        Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }
}

