/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.patchouli;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.recipes.AltarRecipe;
import de.ellpeck.naturesaura.compat.patchouli.PatchouliCompat;
import net.minecraft.item.crafting.Ingredient;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.PatchouliAPI;

public class ProcessorAltar
implements IComponentProcessor {
    private AltarRecipe recipe;

    public void setup(IVariableProvider<String> provider) {
        this.recipe = PatchouliCompat.getRecipe(NaturesAuraAPI.ALTAR_RECIPES, (String)provider.get("recipe"));
    }

    public String process(String key) {
        if (this.recipe == null) {
            return null;
        }
        switch (key) {
            case "input": {
                return PatchouliAPI.instance.serializeIngredient(this.recipe.input);
            }
            case "output": {
                return PatchouliAPI.instance.serializeItemStack(this.recipe.output);
            }
            case "catalyst": {
                if (this.recipe.catalyst != Ingredient.field_193370_a) {
                    return PatchouliAPI.instance.serializeIngredient(this.recipe.catalyst);
                }
                return null;
            }
            case "name": {
                return this.recipe.output.func_82833_r();
            }
        }
        return null;
    }

    public boolean allowRender(String group) {
        if (this.recipe == null) {
            return false;
        }
        return group.isEmpty() || group.equals(this.recipe.catalyst == Ingredient.field_193370_a ? "altar" : "catalyst");
    }
}

