/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.patchouli;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.recipes.AnimalSpawnerRecipe;
import de.ellpeck.naturesaura.compat.patchouli.PatchouliCompat;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.PatchouliAPI;

public class ProcessorAnimalSpawner
implements IComponentProcessor {
    private AnimalSpawnerRecipe recipe;

    public void setup(IVariableProvider<String> provider) {
        this.recipe = PatchouliCompat.getRecipe(NaturesAuraAPI.ANIMAL_SPAWNER_RECIPES, (String)provider.get("recipe"));
    }

    public String process(String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.startsWith("input")) {
            int id = Integer.parseInt(key.substring(5)) - 1;
            if (this.recipe.ingredients.length > id) {
                return PatchouliAPI.instance.serializeIngredient(this.recipe.ingredients[id]);
            }
            return null;
        }
        switch (key) {
            case "name": {
                EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(this.recipe.entity);
                return I18n.func_135052_a((String)("entity." + entry.getName() + ".name"), (Object[])new Object[0]);
            }
            case "entity": {
                return this.recipe.entity.toString();
            }
            case "egg": {
                ItemStack egg = new ItemStack(Items.field_151063_bx);
                ItemMonsterPlacer.func_185078_a((ItemStack)egg, (ResourceLocation)this.recipe.entity);
                return PatchouliAPI.instance.serializeItemStack(egg);
            }
        }
        return null;
    }

    public boolean allowRender(String group) {
        return !"seekrit".equals(group);
    }
}

