/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.entities;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;

public class EntityMoverMinecart
extends EntityMinecart {
    private final List<BlockPos> spotOffsets = new ArrayList<BlockPos>();
    private BlockPos lastPosition = BlockPos.field_177992_a;
    public boolean isActive;

    public EntityMoverMinecart(World worldIn) {
        super(worldIn);
    }

    public EntityMoverMinecart(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public void moveMinecartOnRail(BlockPos railPos) {
        super.moveMinecartOnRail(railPos);
        if (!this.isActive) {
            return;
        }
        BlockPos pos = this.func_180425_c();
        if (!this.spotOffsets.isEmpty() && this.field_70170_p.func_82737_E() % 10L == 0L) {
            PacketHandler.sendToAllAround(this.field_70170_p, pos, 32, new PacketParticles((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 22, MathHelper.func_76128_c((double)(this.field_70159_w * 100.0)), MathHelper.func_76128_c((double)(this.field_70181_x * 100.0)), MathHelper.func_76128_c((double)(this.field_70179_y * 100.0))));
        }
        if (pos.func_177951_i((Vec3i)this.lastPosition) < 64.0) {
            return;
        }
        this.moveAura(this.field_70170_p, this.lastPosition, this.field_70170_p, pos);
        this.lastPosition = pos;
    }

    private void moveAura(World oldWorld, BlockPos oldPos, World newWorld, BlockPos newPos) {
        for (BlockPos offset : this.spotOffsets) {
            int toMove;
            int drained;
            BlockPos spot = oldPos.func_177971_a((Vec3i)offset);
            IAuraChunk chunk = IAuraChunk.getAuraChunk(oldWorld, spot);
            int amount = chunk.getDrainSpot(spot);
            if (amount <= 0 || (drained = chunk.drainAura(spot, toMove = Math.min(amount, 300000), false, false)) <= 0) continue;
            int toLose = MathHelper.func_76123_f((float)((float)drained / 250.0f));
            BlockPos newSpot = newPos.func_177971_a((Vec3i)offset);
            IAuraChunk.getAuraChunk(newWorld, newSpot).storeAura(newSpot, drained - toLose, false, false);
        }
    }

    public void func_96095_a(int x, int y, int z, boolean receivingPower) {
        if (this.isActive != receivingPower) {
            this.isActive = receivingPower;
            if (!this.isActive) {
                this.spotOffsets.clear();
                this.lastPosition = BlockPos.field_177992_a;
                return;
            }
            BlockPos pos = this.func_180425_c();
            IAuraChunk.getSpotsInArea(this.field_70170_p, pos, 25, (spot, amount) -> {
                if (amount > 0) {
                    this.spotOffsets.add(spot.func_177973_b((Vec3i)pos));
                }
            });
            this.lastPosition = pos;
        }
    }

    public void func_94095_a(DamageSource source) {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_70099_a(new ItemStack(ModItems.MOVER_MINECART), 0.0f);
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("active", this.isActive);
        compound.func_74772_a("last_pos", this.lastPosition.func_177986_g());
        NBTTagList list = new NBTTagList();
        for (BlockPos offset : this.spotOffsets) {
            list.func_74742_a((NBTBase)new NBTTagLong(offset.func_177986_g()));
        }
        compound.func_74782_a("offsets", (NBTBase)list);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.isActive = compound.func_74767_n("active");
        this.lastPosition = BlockPos.func_177969_a((long)compound.func_74763_f("last_pos"));
        this.spotOffsets.clear();
        NBTTagList list = compound.func_150295_c("offsets", 4);
        for (NBTBase base : list) {
            this.spotOffsets.add(BlockPos.func_177969_a((long)((NBTTagLong)base).func_150291_c()));
        }
    }

    @Nullable
    public Entity changeDimension(int dimensionIn, ITeleporter teleporter) {
        Entity entity = super.changeDimension(dimensionIn, teleporter);
        if (entity instanceof EntityMoverMinecart) {
            BlockPos pos = entity.func_180425_c();
            this.moveAura(this.field_70170_p, this.lastPosition, entity.field_70170_p, pos);
            ((EntityMoverMinecart)entity).lastPosition = pos;
        }
        return entity;
    }

    public IBlockState func_174897_t() {
        return Blocks.field_150348_b.func_176223_P();
    }

    public EntityMinecart.Type func_184264_v() {
        return EntityMinecart.Type.RIDEABLE;
    }

    public ItemStack getCartItem() {
        return new ItemStack(ModItems.MOVER_MINECART);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ModItems.MOVER_MINECART);
    }

    public boolean canBeRidden() {
        return false;
    }

    protected void func_94101_h() {
        this.field_70159_w *= (double)0.99f;
        this.field_70181_x *= 0.0;
        this.field_70179_y *= (double)0.99f;
    }
}

