/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.gui;

import de.ellpeck.naturesaura.api.misc.IWorldData;
import de.ellpeck.naturesaura.blocks.BlockEnderCrate;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityEnderCrate;
import de.ellpeck.naturesaura.gui.ContainerEnderCrate;
import de.ellpeck.naturesaura.gui.GuiEnderCrate;
import de.ellpeck.naturesaura.items.ModItems;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.items.IItemHandler;

public class GuiHandler
implements IGuiHandler {
    public GuiHandler() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)"naturesaura", (IGuiHandler)this);
    }

    @Nullable
    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        String name;
        ItemStack stack;
        if (id == 0) {
            TileEntityEnderCrate crate;
            TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
            if (tile instanceof TileEntityEnderCrate && (crate = (TileEntityEnderCrate)tile).canOpen()) {
                return new ContainerEnderCrate(player, (IItemHandler)crate.getItemHandler(null));
            }
        } else if (id == 1 && (stack = player.func_184614_ca()).func_77973_b() == ModItems.ENDER_ACCESS && (name = BlockEnderCrate.getEnderName(stack)) != null && !name.isEmpty()) {
            return new ContainerEnderCrate(player, (IItemHandler)IWorldData.getOverworldData(world).getEnderStorage(name));
        }
        return null;
    }

    @Nullable
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        String name;
        ItemStack stack;
        if (id == 0) {
            TileEntityEnderCrate crate;
            TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
            if (tile instanceof TileEntityEnderCrate && (crate = (TileEntityEnderCrate)tile).canOpen()) {
                return new GuiEnderCrate(player, (IItemHandler)crate.getItemHandler(null), "ender_crate", crate.name);
            }
        } else if (id == 1 && (stack = player.func_184614_ca()).func_77973_b() == ModItems.ENDER_ACCESS && (name = BlockEnderCrate.getEnderName(stack)) != null && !name.isEmpty()) {
            return new GuiEnderCrate(player, (IItemHandler)IWorldData.getOverworldData(world).getEnderStorage(name), "ender_access", name);
        }
        return null;
    }
}

