/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.items.ItemImpl;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemRangeVisualizer
extends ItemImpl {
    public static final ListMultimap<Integer, BlockPos> VISUALIZED_BLOCKS = ArrayListMultimap.create();
    public static final ListMultimap<Integer, Entity> VISUALIZED_ENTITIES = ArrayListMultimap.create();
    public static final ListMultimap<Integer, BlockPos> VISUALIZED_RAILS = ArrayListMultimap.create();

    public ItemRangeVisualizer() {
        super("range_visualizer");
        this.func_77625_d(1);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af()) {
            ItemRangeVisualizer.clear();
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("info.naturesaura.range_visualizer.end_all", new Object[0]), true);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IVisualizable) {
            if (worldIn.field_72995_K) {
                ItemRangeVisualizer.visualize(player, VISUALIZED_BLOCKS, worldIn.field_73011_w.getDimension(), pos);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static void clear() {
        if (!VISUALIZED_BLOCKS.isEmpty()) {
            VISUALIZED_BLOCKS.clear();
        }
        if (!VISUALIZED_ENTITIES.isEmpty()) {
            VISUALIZED_ENTITIES.clear();
        }
        if (!VISUALIZED_RAILS.isEmpty()) {
            VISUALIZED_RAILS.clear();
        }
    }

    public static <T> void visualize(EntityPlayer player, ListMultimap<Integer, T> map, int dim, T value) {
        if (map.containsEntry((Object)dim, value)) {
            map.remove((Object)dim, value);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("info.naturesaura.range_visualizer.end", new Object[0]), true);
        } else {
            map.put((Object)dim, value);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("info.naturesaura.range_visualizer.start", new Object[0]), true);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b() || stack.func_77973_b() != this) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof IVisualizable) {
            if (entity.field_70170_p.field_72995_K) {
                int dim = entity.field_70170_p.field_73011_w.getDimension();
                ItemRangeVisualizer.visualize(event.getEntityPlayer(), VISUALIZED_ENTITIES, dim, entity);
            }
            event.getEntityPlayer().func_184609_a(event.getHand());
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
        }
    }
}

