/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.capabilities.energy.adapter;

import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.machinemuse.numina.capabilities.energy.adapter.ElectricAdapter;
import net.minecraft.item.ItemStack;

public class TeslaEnergyAdapter
extends ElectricAdapter {
    private final ItemStack itemStack;
    private final ITeslaHolder holder;
    private final ITeslaConsumer consumer;
    private final ITeslaProducer producer;

    public TeslaEnergyAdapter(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.consumer = (ITeslaConsumer)this.itemStack.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, null);
        this.holder = (ITeslaHolder)itemStack.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, null);
        this.producer = (ITeslaProducer)itemStack.getCapability(TeslaCapabilities.CAPABILITY_PRODUCER, null);
    }

    @Override
    public int getEnergyStored() {
        return this.holder != null ? (int)this.holder.getStoredPower() : 0;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.holder != null ? (int)this.holder.getCapacity() : 0;
    }

    @Override
    public int extractEnergy(int requested, boolean simulate) {
        return this.producer != null ? (int)this.producer.takePower((long)requested, simulate) : 0;
    }

    @Override
    public int receiveEnergy(int provided, boolean simulate) {
        return this.consumer != null ? (int)this.consumer.givePower((long)provided, simulate) : 0;
    }
}

