/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.oldjava;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.darkhax.oldjava.Config;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="oldjava", name="Old Java Warning", version="1.1.11", clientSideOnly=true, certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", acceptedMinecraftVersions="[1.12.2]")
public class OldJavaWarning {
    private static final Logger LOG = LogManager.getLogger((String)"Old Java");
    private static final File LOCK = new File("stop-java-detection.txt");

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        Config.syncConfigData();
        new Thread(OldJavaWarning::checkJavaVersion).start();
    }

    private static void checkJavaVersion() {
        if (LOCK.exists()) {
            return;
        }
        if (Config.warn32 && !OldJavaWarning.isJvm64bit()) {
            OldJavaWarning.displayWarning(I18n.func_135052_a((String)"oldjava.notice.bit.body", (Object[])new Object[0]), I18n.func_135052_a((String)"oldjava.notice.bit.title", (Object[])new Object[0]), I18n.func_135052_a((String)"oldjava.url.bitinfo", (Object[])new Object[0]));
        }
        if (Config.warnVersion && Config.minVersion.compareTo(System.getProperty("java.version")) > 0) {
            OldJavaWarning.displayWarning(I18n.func_135052_a((String)"oldjava.notice.update.body", (Object[])new Object[0]), I18n.func_135052_a((String)"oldjava.notice.update.title", (Object[])new Object[0]), I18n.func_135052_a((String)"oldjava.url.updateinfo", (Object[])new Object[0]));
        }
    }

    private static void displayWarning(String message, String title, String url) {
        Object[] options = new String[]{I18n.func_135052_a((String)"oldjava.buttons.readmore", (Object[])new Object[0]), I18n.func_135052_a((String)"oldjava.buttons.ignore", (Object[])new Object[0]), I18n.func_135052_a((String)"oldjava.buttons.stop", (Object[])new Object[0])};
        int response = JOptionPane.showOptionDialog(OldJavaWarning.getPopupFrame(), message, title, -1, 2, null, options, options[0]);
        if (response == 0) {
            OldJavaWarning.displayUpdateInfo(url);
        } else if (response == 2) {
            OldJavaWarning.writeLock();
        }
    }

    private static void displayUpdateInfo(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException | URISyntaxException e) {
            LOG.catching((Throwable)e);
            JOptionPane.showMessageDialog(OldJavaWarning.getPopupFrame(), "Could not access update guide. Do you have Internet?", "Error", 0);
        }
    }

    private static void writeLock() {
        try {
            FileUtils.write((File)LOCK, (CharSequence)"If this file exists, the old java version popup will not be shown.", (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOG.catching((Throwable)e);
        }
    }

    private static JFrame getPopupFrame() {
        JFrame parent = new JFrame();
        parent.setAlwaysOnTop(true);
        return parent;
    }

    private static boolean isJvm64bit() {
        String[] propertyStrings;
        for (String property : propertyStrings = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"}) {
            String value = System.getProperty(property);
            if (value == null || !value.contains("64")) continue;
            return true;
        }
        return false;
    }
}

