/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBookEntryList;
import vazkii.patchouli.client.book.gui.button.GuiButtonCategory;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;

public class GuiBookCategory
extends GuiBookEntryList {
    final BookCategory category;
    private int subcategoryButtonCount;

    public GuiBookCategory(Book book, BookCategory category) {
        super(book);
        this.category = category;
    }

    @Override
    protected String getName() {
        return this.category.getName();
    }

    @Override
    protected String getDescriptionText() {
        return this.category.getDescription();
    }

    @Override
    protected Collection<BookEntry> getEntries() {
        return this.category.getEntries();
    }

    @Override
    void drawForegroundElements(int mouseX, int mouseY, float partialTicks) {
        super.drawForegroundElements(mouseX, mouseY, partialTicks);
        if (this.getEntries().isEmpty() && this.subcategoryButtonCount <= 16 && this.subcategoryButtonCount > 0) {
            int bottomSeparator = 55 + 24 * ((this.subcategoryButtonCount - 1) / 4 + 1);
            GuiBookCategory.drawSeparator(this.book, 141, bottomSeparator);
        }
    }

    @Override
    protected void addSubcategoryButtons() {
        int baseY;
        int baseX;
        int i = 0;
        ArrayList<BookCategory> categories = new ArrayList<BookCategory>(this.book.contents.categories.values());
        categories.removeIf(cat -> cat.getParentCategory() != this.category || cat.shouldHide());
        Collections.sort(categories);
        this.subcategoryButtonCount = categories.size();
        boolean rightPageFree = this.getEntries().isEmpty();
        if (rightPageFree) {
            baseX = 151;
            baseY = 43;
        } else {
            baseX = 25;
            baseY = 174 - categories.size() / 4 * 20 - (PatchouliConfig.disableAdvancementLocking ? 38 : 64);
        }
        for (BookCategory ocategory : categories) {
            int x = baseX + i % 4 * 24;
            int y = baseY + i / 4 * (rightPageFree ? 24 : 20);
            GuiButtonCategory button = new GuiButtonCategory(this, x, y, ocategory);
            this.field_146292_n.add(button);
            this.dependentButtons.add(button);
            ++i;
        }
    }

    @Override
    protected String getChapterListTitle() {
        if (this.getEntries().isEmpty() && this.subcategoryButtonCount > 0) {
            return I18n.func_135052_a((String)"patchouli.gui.lexicon.categories", (Object[])new Object[0]);
        }
        return super.getChapterListTitle();
    }

    @Override
    protected GuiTextField createSearchBar() {
        GuiTextField widget = super.createSearchBar();
        if (this.getEntries().isEmpty()) {
            widget.func_146184_c(false);
            widget.func_146189_e(false);
        }
        return widget;
    }

    @Override
    protected boolean doesEntryCountForProgress(BookEntry entry) {
        return entry.getCategory() == this.category;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof GuiBookCategory && ((GuiBookCategory)((Object)obj)).category == this.category && ((GuiBookCategory)((Object)obj)).page == this.page;
    }

    @Override
    public boolean canBeOpened() {
        return !this.category.isLocked() && !this.equals(Minecraft.func_71410_x().field_71462_r);
    }
}

