/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table.cell;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.cell.TableCellPropertyDefault;
import net.minecraft.client.gui.GuiButton;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TableCellBoolean
extends TableCellPropertyDefault<Boolean> {
    private GuiButton button;
    protected String trueTitle;
    protected String falseTitle;
    protected boolean enabled = true;

    public TableCellBoolean(String id, boolean value) {
        this(id, value, IvTranslations.get("reccomplex.gui.true"), IvTranslations.get("reccomplex.gui.false"));
    }

    public TableCellBoolean(String id, Boolean value, String trueTitle, String falseTitle) {
        super(id, value);
        this.trueTitle = trueTitle;
        this.falseTitle = falseTitle;
    }

    public String getTrueTitle() {
        return this.trueTitle;
    }

    public void setTrueTitle(String trueTitle) {
        this.trueTitle = trueTitle;
    }

    public String getFalseTitle() {
        return this.falseTitle;
    }

    public void setFalseTitle(String falseTitle) {
        this.falseTitle = falseTitle;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.button != null) {
            this.button.field_146124_l = enabled;
        }
    }

    @Override
    public void initGui(GuiTable screen) {
        super.initGui(screen);
        Bounds bounds = this.bounds();
        this.button = new GuiButton(-1, bounds.getMinX(), bounds.getMinY() + (bounds.getHeight() - 20) / 2, bounds.getWidth(), 20, this.getCurrentButtonTitle());
        this.button.field_146124_l = this.enabled;
        this.button.field_146125_m = !this.isHidden();
        screen.addButton(this, 0, this.button);
    }

    @Override
    public void setHidden(boolean hidden) {
        super.setHidden(hidden);
        if (this.button != null) {
            this.button.field_146125_m = !hidden;
        }
    }

    @Override
    public void setPropertyValue(Boolean value) {
        super.setPropertyValue(value);
        if (this.button != null) {
            this.button.field_146126_j = this.getCurrentButtonTitle();
        }
    }

    @Override
    public void buttonClicked(int buttonID) {
        super.buttonClicked(buttonID);
        this.property = (Boolean)this.property == false;
        if (this.button != null) {
            this.button.field_146126_j = this.getCurrentButtonTitle();
        }
        this.alertListenersOfChange();
    }

    public String getCurrentButtonTitle() {
        return (Boolean)this.property != false ? this.trueTitle : this.falseTitle;
    }
}

