/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.Reliquary;
import xreliquary.items.ItemToggleable;
import xreliquary.items.util.fluid.FluidHandlerEmperorChalice;
import xreliquary.reference.Settings;
import xreliquary.util.LanguageHelper;
import xreliquary.util.RegistryHelper;

public class ItemEmperorChalice
extends ItemToggleable {
    public ItemEmperorChalice() {
        super("emperor_chalice");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.canRepair = false;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    protected void addMoreInformation(ItemStack stack, @Nullable World world, List<String> tooltip) {
        LanguageHelper.formatTooltip(this.func_77657_g(stack) + ".tooltip2", tooltip);
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 16;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerEmperorChalice(stack);
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (world.field_72995_K) {
            return stack;
        }
        if (!(entityLiving instanceof EntityPlayer)) {
            return stack;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        int multiplier = Settings.Items.EmperorChalice.hungerSatiationMultiplier;
        player.func_71024_bL().func_75122_a(1, (float)(multiplier / 2));
        player.func_70097_a(DamageSource.field_76369_e, (float)multiplier);
        return stack;
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack ist = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            return super.func_77659_a(world, player, hand);
        }
        boolean isInDrainMode = this.isEnabled(ist);
        RayTraceResult result = this.func_77621_a(world, player, isInDrainMode);
        if (result == null) {
            if (!this.isEnabled(ist)) {
                player.func_184598_c(hand);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)ist);
        }
        if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (!world.func_175660_a(player, result.func_178782_a())) {
                return new ActionResult(EnumActionResult.FAIL, (Object)ist);
            }
            if (!player.func_175151_a(result.func_178782_a(), result.field_178784_b, ist)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)ist);
            }
            if (!this.isEnabled(ist)) {
                BlockPos waterPlacementPos = result.func_178782_a().func_177972_a(result.field_178784_b);
                if (!player.func_175151_a(waterPlacementPos, result.field_178784_b, ist)) {
                    return new ActionResult(EnumActionResult.FAIL, (Object)ist);
                }
                if (this.tryPlaceContainedLiquid(world, ist, waterPlacementPos)) {
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)ist);
                }
            } else {
                String ident = RegistryHelper.getBlockRegistryName(world.func_180495_p(result.func_178782_a()).func_177230_c());
                if ((ident.equals(RegistryHelper.getBlockRegistryName((Block)Blocks.field_150358_i)) || ident.equals(RegistryHelper.getBlockRegistryName((Block)Blocks.field_150355_j))) && (Integer)world.func_180495_p(result.func_178782_a()).func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                    world.func_175656_a(result.func_178782_a(), Blocks.field_150350_a.func_176223_P());
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)ist);
                }
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)ist);
    }

    @SubscribeEvent
    public void onBlockRightClick(PlayerInteractEvent.RightClickBlock evt) {
        World world;
        IBlockState state;
        if (evt.getItemStack().func_77973_b() == this && (state = (world = evt.getWorld()).func_180495_p(evt.getPos())).func_177230_c() == Blocks.field_150383_bp) {
            if (!this.isEnabled(evt.getItemStack()) && (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) == 0) {
                Blocks.field_150383_bp.func_176590_a(world, evt.getPos(), state, 3);
                evt.setUseItem(Event.Result.DENY);
                evt.setCanceled(true);
                evt.setCancellationResult(EnumActionResult.SUCCESS);
            } else if (this.isEnabled(evt.getItemStack()) && (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) == 3) {
                Blocks.field_150383_bp.func_176590_a(world, evt.getPos(), state, 0);
                evt.setUseItem(Event.Result.DENY);
                evt.setCanceled(true);
                evt.setCancellationResult(EnumActionResult.SUCCESS);
            }
        }
    }

    private boolean tryPlaceContainedLiquid(World world, @Nonnull ItemStack stack, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Material material = blockState.func_185904_a();
        if (this.isEnabled(stack)) {
            return false;
        }
        if (!world.func_175623_d(pos) && material.func_76220_a()) {
            return false;
        }
        if (world.field_73011_w.func_177500_n()) {
            world.func_184133_a(null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int var11 = 0; var11 < 8; ++var11) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            world.func_180501_a(pos, Blocks.field_150358_i.func_176223_P(), 3);
        }
        return true;
    }
}

