/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.api.requirement;

import codersafterdark.reskillable.Reskillable;
import codersafterdark.reskillable.api.ReskillableRegistries;
import codersafterdark.reskillable.api.requirement.Requirement;
import codersafterdark.reskillable.api.requirement.RequirementException;
import codersafterdark.reskillable.api.requirement.RequirementFunction;
import codersafterdark.reskillable.api.requirement.SkillRequirement;
import codersafterdark.reskillable.api.skill.Skill;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class RequirementRegistry {
    private Map<String, RequirementFunction<String, Requirement>> requirementHandlers = Maps.newHashMap();

    public Requirement getRequirement(String requirementString) {
        Requirement requirement;
        block12: {
            String[] requirements = requirementString.split("\\|");
            requirement = null;
            try {
                String requirementType;
                if (requirements.length == 2) {
                    String requirementType2 = requirements[0];
                    String requirementInputs = requirements[1];
                    if (this.requirementHandlers.containsKey(requirementType2)) {
                        requirement = this.requirementHandlers.get(requirementType2).apply(requirementInputs);
                        break block12;
                    }
                    Skill skill = (Skill)ReskillableRegistries.SKILLS.getValue(new ResourceLocation(requirementType2));
                    if (skill == null) {
                        throw new RequirementException("Skill '" + requirementType2 + "' not found.");
                    }
                    try {
                        int level = Integer.parseInt(requirementInputs);
                        if (level <= 1) {
                            throw new RequirementException("Level must be greater than 1. Found: '" + level + "'.");
                        }
                        requirement = new SkillRequirement(skill, level);
                        break block12;
                    }
                    catch (NumberFormatException e) {
                        throw new RequirementException("Invalid level '" + requirementInputs + "' for skill '" + skill.getName() + "'.");
                    }
                }
                if (requirements.length > 0 && this.requirementHandlers.containsKey(requirementType = requirements[0])) {
                    int pos = requirementType.length() + 1;
                    String input = pos > requirementString.length() ? "" : requirementString.substring(pos);
                    requirement = this.requirementHandlers.get(requirementType).apply(input);
                }
            }
            catch (RequirementException e) {
                Reskillable.logger.log(Level.ERROR, "Requirement Format Exception (" + requirementString + "): " + e.getMessage());
                return null;
            }
        }
        if (requirement == null) {
            Reskillable.logger.log(Level.ERROR, "No Requirement found for Input: " + requirementString);
        } else if (!requirement.isEnabled()) {
            Reskillable.logger.log(Level.ERROR, "Disabled Requirement for Input: " + requirementString);
            return null;
        }
        return requirement;
    }

    public void addRequirementHandler(String identity, RequirementFunction<String, Requirement> creator) {
        this.requirementHandlers.put(identity, creator);
    }
}

