/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.command;

import greymerk.roguelike.command.CommandSender;
import greymerk.roguelike.command.MessageType;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import net.minecraft.item.ItemStack;

public class CommandContext {
    private CommandSender commandSender;

    public CommandContext(CommandSender commandSender) {
        this.commandSender = commandSender;
    }

    public void sendFailure(Exception e) {
        this.sendFailure(e.getMessage());
    }

    public void sendFailure(String message) {
        this.sendMessage("Failure: " + message, MessageType.ERROR);
    }

    public void sendInfo(String message) {
        this.sendMessage(message, MessageType.INFO);
    }

    public void sendSpecial(String message) {
        this.sendMessage(message, MessageType.SPECIAL);
    }

    public void sendSuccess(String message) {
        this.sendMessage("Success: " + message, MessageType.SUCCESS);
    }

    public void sendMessage(String message, MessageType type) {
        this.commandSender.sendMessage(message, type);
    }

    public WorldEditor createEditor() {
        return this.commandSender.createWorldEditor();
    }

    public Coord getPos() {
        return this.commandSender.getPos();
    }

    public void give(ItemStack item) {
        this.commandSender.give(item);
    }
}

