/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.base;

import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SettingsResolver;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.spawners.MobType;
import greymerk.roguelike.worldgen.spawners.SpawnerSettings;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class DungeonBase
implements Comparable<DungeonBase> {
    private final RoomSetting roomSetting;
    protected final LevelSettings levelSettings;
    protected final WorldEditor worldEditor;

    public DungeonBase(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        this.roomSetting = roomSetting;
        this.levelSettings = levelSettings;
        this.worldEditor = worldEditor;
    }

    public List<Coord> chooseRandomLocations(int limit, List<Coord> spaces) {
        Collections.shuffle(spaces, this.worldEditor.getRandom());
        return spaces.stream().limit(limit).collect(Collectors.toList());
    }

    public abstract DungeonBase generate(Coord var1, List<Direction> var2);

    protected void generateSpawner(Coord spawnerLocation, MobType ... defaultMobs) {
        int difficulty = this.levelSettings.getDifficulty(spawnerLocation);
        this.getSpawnerSettings(difficulty, defaultMobs, this.levelSettings.getSpawners()).generateSpawner(this.worldEditor, spawnerLocation, difficulty);
    }

    private SpawnerSettings getSpawnerSettings(int difficulty, MobType[] defaultMobs, SpawnerSettings levelSettingsSpawners) {
        String spawnerId = this.roomSetting.getSpawnerId();
        if (spawnerId != null) {
            SpawnerSettings dungeonSettingsSpawners;
            DungeonSettings dungeonSettings = null;
            try {
                dungeonSettings = SettingsResolver.initSettingsResolver().getByName(spawnerId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (dungeonSettings != null && !(dungeonSettingsSpawners = dungeonSettings.getLevelSettings(difficulty).getSpawners()).isEmpty()) {
                return dungeonSettingsSpawners;
            }
        }
        return !levelSettingsSpawners.isEmpty() ? levelSettingsSpawners : MobType.newSpawnerSetting(defaultMobs.length > 0 ? defaultMobs : MobType.COMMON_MOBS);
    }

    public abstract int getSize();

    public boolean validLocation(WorldEditor editor, Direction dir, Coord pos) {
        int size = this.getSize();
        Coord start = new Coord(pos.getX() - size, pos.getY() - 2, pos.getZ() - size);
        Coord end = new Coord(pos.getX() + size, pos.getY() + 5, pos.getZ() + size);
        for (Coord cursor : new RectHollow(start, end)) {
            if (editor.isSolidBlock(cursor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(DungeonBase other) {
        return this.getSize() - other.getSize();
    }

    protected RoomSetting getRoomSetting() {
        return this.roomSetting;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DungeonBase)) {
            return false;
        }
        DungeonBase other = (DungeonBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RoomSetting this$roomSetting = this.getRoomSetting();
        RoomSetting other$roomSetting = other.getRoomSetting();
        if (this$roomSetting == null ? other$roomSetting != null : !((Object)this$roomSetting).equals(other$roomSetting)) {
            return false;
        }
        LevelSettings this$levelSettings = this.levelSettings;
        LevelSettings other$levelSettings = other.levelSettings;
        if (this$levelSettings == null ? other$levelSettings != null : !((Object)this$levelSettings).equals(other$levelSettings)) {
            return false;
        }
        WorldEditor this$worldEditor = this.worldEditor;
        WorldEditor other$worldEditor = other.worldEditor;
        return !(this$worldEditor == null ? other$worldEditor != null : !this$worldEditor.equals(other$worldEditor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DungeonBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RoomSetting $roomSetting = this.getRoomSetting();
        result = result * 59 + ($roomSetting == null ? 43 : ((Object)$roomSetting).hashCode());
        LevelSettings $levelSettings = this.levelSettings;
        result = result * 59 + ($levelSettings == null ? 43 : $levelSettings.hashCode());
        WorldEditor $worldEditor = this.worldEditor;
        result = result * 59 + ($worldEditor == null ? 43 : $worldEditor.hashCode());
        return result;
    }
}

