/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.base;

import com.github.srwaggon.minecraft.block.SingleBlockBrush;
import com.google.common.collect.Lists;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.List;

public class SecretRoom
extends DungeonBase {
    private final DungeonBase prototype;

    public SecretRoom(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
        this.prototype = this.getRoomSetting().instantiate(this.levelSettings, this.worldEditor);
    }

    @Override
    public boolean validLocation(WorldEditor editor, Direction dir, Coord pos) {
        if (this.getRoomSetting().getCount() <= 0) {
            return false;
        }
        Coord cursor = pos.copy();
        cursor.translate(dir, this.prototype.getSize() + 5);
        return this.prototype.validLocation(editor, dir, cursor);
    }

    @Override
    public DungeonBase generate(Coord pos, List<Direction> entrances) {
        int size = this.prototype.getSize();
        Coord start = pos.copy();
        Coord end = pos.copy();
        Direction entrance = entrances.get(0);
        start.translate(entrance.orthogonals()[0]);
        start.down();
        start.translate(entrance, 2);
        end.translate(entrance.orthogonals()[1]);
        end.translate(entrance, size + 5);
        end.up(2);
        RectSolid.newRect(start, end).fill(this.worldEditor, this.levelSettings.getTheme().getPrimary().getWall(), false, true);
        end = pos.copy();
        end.translate(entrance, size + 5);
        end.up();
        RectSolid.newRect(pos, end).fill(this.worldEditor, SingleBlockBrush.AIR);
        end.down();
        return this.prototype.generate(end, Lists.newArrayList((Object[])new Direction[]{entrance}));
    }

    @Override
    public int getSize() {
        return this.prototype.getSize();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecretRoom)) {
            return false;
        }
        SecretRoom other = (SecretRoom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DungeonBase this$prototype = this.prototype;
        DungeonBase other$prototype = other.prototype;
        return !(this$prototype == null ? other$prototype != null : !((Object)this$prototype).equals(other$prototype));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SecretRoom;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DungeonBase $prototype = this.prototype;
        result = result * 59 + ($prototype == null ? 43 : ((Object)$prototype).hashCode());
        return result;
    }

    public String toString() {
        return "SecretRoom(prototype=" + this.prototype + ")";
    }
}

