/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import com.github.srwaggon.minecraft.block.SingleBlockBrush;
import com.github.srwaggon.minecraft.block.normal.StairsBlock;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ThemeBase;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.spawners.MobType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BrickRoom
extends DungeonBase {
    public BrickRoom(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    @Override
    public DungeonBase generate(Coord origin, List<Direction> entrances) {
        int x = origin.getX();
        int y = origin.getY();
        int z = origin.getZ();
        ThemeBase theme = this.levelSettings.getTheme();
        StairsBlock stair = theme.getPrimary().getStair();
        BlockBrush blocks = theme.getPrimary().getWall();
        BlockBrush pillar = theme.getPrimary().getPillar();
        RectSolid.newRect(new Coord(x - 3, y, z - 3), new Coord(x + 3, y + 3, z + 3)).fill(this.worldEditor, SingleBlockBrush.AIR);
        RectSolid.newRect(new Coord(x - 1, y + 4, z - 1), new Coord(x + 1, y + 4, z + 1)).fill(this.worldEditor, SingleBlockBrush.AIR);
        RectHollow.newRect(new Coord(x - 4, y - 1, z - 4), new Coord(x + 4, y + 4, z + 4)).fill(this.worldEditor, blocks, false, true);
        RectSolid.newRect(new Coord(x - 4, y - 1, z - 4), new Coord(x + 4, y - 1, z + 4)).fill(this.worldEditor, theme.getPrimary().getFloor(), false, true);
        Coord cursor = new Coord(x, y, z);
        cursor.translate(Direction.UP, 5);
        SingleBlockBrush.AIR.stroke(this.worldEditor, cursor);
        cursor.translate(Direction.UP, 1);
        blocks.stroke(this.worldEditor, cursor);
        for (Direction dir : Direction.CARDINAL) {
            cursor = new Coord(x, y, z);
            cursor.translate(dir, 1);
            cursor.translate(Direction.UP, 5);
            stair.setUpsideDown(true).setFacing(dir.reverse());
            stair.stroke(this.worldEditor, cursor, false, true);
            cursor.translate(dir.antiClockwise(), 1);
            blocks.stroke(this.worldEditor, cursor, false, true);
            cursor = new Coord(x, y, z);
            cursor.translate(dir, 2);
            cursor.translate(Direction.UP, 4);
            SingleBlockBrush.AIR.stroke(this.worldEditor, cursor);
            cursor.translate(Direction.UP, 1);
            blocks.stroke(this.worldEditor, cursor, false, true);
            cursor = new Coord(x, y, z);
            cursor.translate(dir, 3);
            cursor.translate(dir.antiClockwise(), 3);
            Coord start = cursor.copy();
            cursor.translate(Direction.UP, 2);
            Coord end = cursor.copy();
            RectSolid.newRect(start, end).fill(this.worldEditor, pillar);
            cursor.translate(Direction.UP, 1);
            blocks.stroke(this.worldEditor, cursor);
            for (Direction orthogonals : dir.orthogonals()) {
                cursor = new Coord(x, y, z);
                cursor.translate(dir, 3);
                cursor.translate(orthogonals, 2);
                cursor.translate(Direction.UP, 3);
                stair.setUpsideDown(true).setFacing(orthogonals.reverse());
                stair.stroke(this.worldEditor, cursor);
            }
            cursor = new Coord(x, y, z);
            cursor.translate(dir, 2);
            cursor.translate(dir.antiClockwise(), 2);
            cursor.translate(Direction.UP, 4);
            blocks.stroke(this.worldEditor, cursor, false, true);
            for (Direction orthogonals : dir.orthogonals()) {
                cursor = new Coord(x, y, z);
                cursor.translate(Direction.UP, 4);
                cursor.translate(dir, 2);
                cursor.translate(orthogonals, 1);
                stair.setUpsideDown(true).setFacing(orthogonals.reverse());
                stair.stroke(this.worldEditor, cursor, false, true);
            }
            cursor = new Coord(x, y, z);
            cursor.translate(dir, 1);
            cursor.translate(dir.antiClockwise(), 1);
            cursor.translate(Direction.UP, 5);
            blocks.stroke(this.worldEditor, cursor, false, true);
        }
        Direction randomDirection = Direction.randomCardinal(this.worldEditor.getRandom());
        Coord spawnerLocation = origin.copy().translate(randomDirection, this.worldEditor.getRandom().nextInt(this.getSize())).translate(randomDirection.clockwise(), this.worldEditor.getRandom().nextInt(this.getSize()));
        this.generateSpawner(spawnerLocation, new MobType[0]);
        this.generateChest(origin, spawnerLocation);
        return this;
    }

    /*
     * Exception decompiling
     */
    public void generateChest(Coord origin, Coord spawnerLocation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Coord> getPotentialSpawnLocations(Coord origin) {
        ArrayList<Coord> potentialChestLocations = new ArrayList<Coord>();
        Direction.CARDINAL.forEach(dir -> Arrays.stream(dir.orthogonals()).map(orthogonal -> origin.copy().translate((Direction)((Object)dir), 3).translate((Direction)((Object)((Object)orthogonal)), 2)).forEach(potentialChestLocations::add));
        return potentialChestLocations;
    }

    @Override
    public int getSize() {
        return 6;
    }
}

