/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import com.github.srwaggon.minecraft.block.SingleBlockBrush;
import com.github.srwaggon.minecraft.block.normal.StairsBlock;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ThemeBase;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.spawners.MobType;
import java.util.ArrayList;
import java.util.List;

public class DungeonEniko
extends DungeonBase {
    public DungeonEniko(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    private static void pillar(WorldEditor editor, ThemeBase theme, Coord origin) {
        StairsBlock stair = theme.getPrimary().getStair();
        BlockBrush pillar = theme.getPrimary().getPillar();
        Coord start = origin.copy();
        Coord end = start.copy();
        end.up(3);
        RectSolid.newRect(start, end).fill(editor, pillar);
        for (Direction dir : Direction.CARDINAL) {
            Coord cursor = end.copy();
            cursor.translate(dir);
            stair.setUpsideDown(true).setFacing(dir).stroke(editor, cursor, true, false);
        }
    }

    @Override
    public DungeonBase generate(Coord origin, List<Direction> entrances) {
        ThemeBase theme = this.levelSettings.getTheme();
        StairsBlock stair = theme.getPrimary().getStair();
        BlockBrush walls = theme.getPrimary().getWall();
        BlockBrush floor = theme.getPrimary().getFloor();
        ArrayList<Coord> chests = new ArrayList<Coord>();
        Coord start = origin.copy();
        Coord end = origin.copy();
        start.translate(new Coord(6, -1, 6));
        end.translate(new Coord(-6, 4, -6));
        RectHollow.newRect(start, end).fill(this.worldEditor, walls, false, true);
        start = origin.copy();
        end = origin.copy();
        start.translate(new Coord(6, 4, 6));
        end.translate(new Coord(-6, 5, -6));
        RectSolid.newRect(start, end).fill(this.worldEditor, theme.getSecondary().getWall(), false, true);
        start = origin.copy();
        end = origin.copy();
        start.translate(new Coord(3, 4, 3));
        end.translate(new Coord(-3, 4, -3));
        RectSolid.newRect(start, end).fill(this.worldEditor, SingleBlockBrush.AIR);
        start = origin.copy();
        end = origin.copy();
        start.translate(new Coord(-3, -1, -3));
        end.translate(new Coord(3, -1, 3));
        RectSolid.newRect(start, end).fill(this.worldEditor, floor);
        for (Direction dir : Direction.CARDINAL) {
            Coord cursor = origin.copy();
            cursor.translate(dir, 5);
            for (Direction o : dir.orthogonals()) {
                Coord c = cursor.copy();
                c.translate(o, 2);
                DungeonEniko.pillar(this.worldEditor, theme, c);
                c = cursor.copy();
                c.translate(o, 3);
                stair.setUpsideDown(true).setFacing(dir.reverse()).stroke(this.worldEditor, c);
                c.translate(o);
                stair.setUpsideDown(true).setFacing(dir.reverse()).stroke(this.worldEditor, c);
                c.up();
                chests.add(c.copy());
                c.translate(o.reverse());
                chests.add(c.copy());
            }
            cursor.translate(dir.antiClockwise(), 5);
            DungeonEniko.pillar(this.worldEditor, theme, cursor);
            if (!entrances.contains((Object)dir)) continue;
            start = origin.copy();
            start.down();
            end = start.copy();
            start.translate(dir.antiClockwise());
            end.translate(dir.clockwise());
            end.translate(dir, 6);
            RectSolid.newRect(start, end).fill(this.worldEditor, floor);
        }
        this.generateSpawner(origin, MobType.COMMON_MOBS);
        List<Coord> chestLocations = this.chooseRandomLocations(1, chests);
        ChestType chestType = this.getRoomSetting().getChestType().orElse(ChestType.chooseRandomAmong(this.worldEditor.getRandom(origin), ChestType.COMMON_TREASURES));
        this.worldEditor.getTreasureChestEditor().createChests(chestLocations, false, this.levelSettings.getDifficulty(origin), chestType);
        return this;
    }

    @Override
    public int getSize() {
        return 7;
    }
}

