/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import com.github.srwaggon.minecraft.block.BlockType;
import com.github.srwaggon.minecraft.block.SingleBlockBrush;
import com.github.srwaggon.minecraft.block.decorative.TorchBlock;
import com.github.srwaggon.minecraft.block.normal.ColoredBlock;
import com.github.srwaggon.minecraft.block.redstone.ComparatorBlock;
import com.github.srwaggon.minecraft.block.redstone.LeverBlock;
import com.github.srwaggon.minecraft.block.redstone.RepeaterBlock;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.treasure.loot.Firework;
import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.util.DyeColor;
import greymerk.roguelike.util.TextFormat;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class DungeonFirework
extends DungeonBase {
    public DungeonFirework(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    @Override
    public DungeonBase generate(Coord origin, List<Direction> entrances) {
        int x = origin.getX();
        int y = origin.getY();
        int z = origin.getZ();
        ColoredBlock breadboard = ColoredBlock.stainedHardenedClay().setColor(DyeColor.GREEN);
        Direction dir = entrances.get(0);
        Coord start = new Coord(x, y, z);
        Coord end = start.copy();
        start.translate(dir.reverse(), 9);
        end.translate(dir, 9);
        start.translate(dir.antiClockwise(), 4);
        end.translate(dir.clockwise(), 4);
        start.down();
        end.up(3);
        RectHollow.newRect(start, end).fill(this.worldEditor, ColoredBlock.stainedHardenedClay().setColor(DyeColor.ORANGE), false, true);
        start = new Coord(x, y, z);
        start.translate(dir.antiClockwise(), 2);
        end = start.copy();
        start.translate(dir.reverse(), 3);
        end.translate(dir, 7);
        end.up();
        RectSolid.newRect(start, end).fill(this.worldEditor, breadboard);
        start.translate(dir.clockwise(), 2);
        end.translate(dir.clockwise(), 2);
        RectSolid.newRect(start, end).fill(this.worldEditor, breadboard);
        start.translate(dir.clockwise(), 2);
        end.translate(dir.clockwise(), 2);
        RectSolid.newRect(start, end).fill(this.worldEditor, breadboard);
        Coord cursor = new Coord(x, y, z);
        cursor.translate(dir.antiClockwise(), 2);
        this.launcher(this.worldEditor, dir, cursor);
        cursor.translate(dir.clockwise(), 2);
        this.launcher(this.worldEditor, dir, cursor);
        cursor.translate(dir.clockwise(), 2);
        this.launcher(this.worldEditor, dir, cursor);
        cursor.translate(dir, 6);
        this.launcher(this.worldEditor, dir, cursor);
        cursor.translate(dir.antiClockwise(), 2);
        this.launcher(this.worldEditor, dir, cursor);
        cursor.translate(dir.antiClockwise(), 2);
        this.launcher(this.worldEditor, dir, cursor);
        start = new Coord(x, y, z);
        start.translate(dir, 4);
        end = start.copy();
        start.translate(dir.antiClockwise(), 2);
        end.translate(dir.clockwise(), 2);
        end.translate(dir, 2);
        RectSolid.newRect(start, end).fill(this.worldEditor, SingleBlockBrush.AIR);
        cursor = new Coord(x, y, z);
        cursor.translate(dir, 2);
        RepeaterBlock.repeater().setFacing(dir).stroke(this.worldEditor, cursor);
        cursor.translate(dir.antiClockwise(), 2);
        RepeaterBlock.repeater().setFacing(dir).stroke(this.worldEditor, cursor);
        cursor.translate(dir.clockwise(), 4);
        RepeaterBlock.repeater().setFacing(dir).stroke(this.worldEditor, cursor);
        cursor = new Coord(x, y, z);
        cursor.translate(dir.reverse(), 3);
        cursor.translate(dir.antiClockwise());
        RepeaterBlock.repeater().setFacing(dir.antiClockwise()).stroke(this.worldEditor, cursor);
        cursor.translate(dir.clockwise(), 2);
        RepeaterBlock.repeater().setFacing(dir.clockwise()).stroke(this.worldEditor, cursor);
        SingleBlockBrush wire = BlockType.REDSTONE_WIRE.getBrush();
        start = new Coord(x, y, z);
        start.down(2);
        start.translate(dir.clockwise());
        start.translate(dir.reverse(), 2);
        end = start.copy();
        end.translate(dir.antiClockwise(), 5);
        end.translate(dir.reverse(), 5);
        end.down(2);
        RectSolid.newRect(start, end).fill(this.worldEditor, BlockType.COBBLESTONE.getBrush());
        cursor = new Coord(x, y, z);
        cursor.translate(dir.reverse(), 3);
        cursor.down();
        TorchBlock.redstone().setFacing(Direction.UP).stroke(this.worldEditor, cursor);
        cursor.down();
        breadboard.stroke(this.worldEditor, cursor);
        cursor.translate(dir.antiClockwise());
        TorchBlock.redstone().setFacing(dir.antiClockwise()).stroke(this.worldEditor, cursor);
        cursor.translate(dir.antiClockwise());
        wire.stroke(this.worldEditor, cursor);
        cursor.translate(dir.reverse());
        wire.stroke(this.worldEditor, cursor);
        cursor.translate(dir.reverse());
        wire.stroke(this.worldEditor, cursor);
        cursor.translate(dir.clockwise());
        wire.stroke(this.worldEditor, cursor);
        cursor.translate(dir.clockwise());
        wire.stroke(this.worldEditor, cursor);
        cursor.translate(dir);
        RepeaterBlock.repeater().setDelay(RepeaterBlock.Delay.FOUR).setPowered(true).setFacing(dir).stroke(this.worldEditor, cursor);
        cursor.up();
        cursor.translate(dir.reverse());
        ColoredBlock.stainedHardenedClay().setColor(DyeColor.RED).stroke(this.worldEditor, cursor);
        cursor.up();
        LeverBlock.lever().setActive(true).setFacing(Direction.UP).stroke(this.worldEditor, cursor);
        BlockBrush light = this.levelSettings.getTheme().getPrimary().getLightBlock();
        cursor = new Coord(x, y, z);
        cursor.translate(dir.reverse(), 5);
        cursor.up(3);
        light.stroke(this.worldEditor, cursor);
        cursor.translate(dir, 4);
        light.stroke(this.worldEditor, cursor);
        cursor.translate(dir, 6);
        light.stroke(this.worldEditor, cursor);
        return this;
    }

    private void launcher(WorldEditor editor, Direction dir, Coord pos) {
        Coord cursor = pos.copy();
        BlockType.REDSTONE_WIRE.getBrush().stroke(editor, cursor);
        cursor.translate(dir.reverse());
        BlockType.REDSTONE_WIRE.getBrush().stroke(editor, cursor);
        cursor.translate(dir.reverse());
        RepeaterBlock.repeater().setFacing(dir).stroke(editor, cursor);
        cursor.translate(dir.reverse());
        cursor.up();
        BlockType.DROPPER.getBrush().setFacing(Direction.UP).stroke(editor, cursor);
        for (int i = 0; i < 8; ++i) {
            ItemStack stick = new ItemStack(Items.field_151055_y, 1);
            stick.func_151001_c(Integer.toString(i));
            Loot.setItemLore(stick, "Random logic unit", TextFormat.DARKGRAY);
            editor.setItem(cursor, i, stick);
        }
        editor.setItem(cursor, 8, new ItemStack(Items.field_151017_I));
        cursor.up();
        BlockType.HOPPER.getBrush().setFacing(Direction.DOWN).stroke(editor, cursor);
        cursor.translate(dir);
        ComparatorBlock.comparator().setFacing(dir).stroke(editor, cursor);
        cursor.translate(dir);
        BlockType.REDSTONE_WIRE.getBrush().stroke(editor, cursor);
        cursor.translate(dir);
        BlockType.REDSTONE_WIRE.getBrush().stroke(editor, cursor);
        cursor.translate(dir);
        Coord top = new Coord(pos.getX(), 80, pos.getZ());
        while (top.getY() > pos.getY()) {
            top.down();
            if (!editor.isSolidBlock(top)) continue;
        }
        if (top.getY() >= 100) {
            return;
        }
        Coord start = cursor.copy();
        start.up();
        start.translate(dir);
        Coord end = start.copy();
        ColoredBlock breadboard = ColoredBlock.stainedHardenedClay().setColor(DyeColor.GREEN);
        boolean torch = false;
        while (end.getY() < top.getY()) {
            if (torch) {
                TorchBlock.redstone().setFacing(Direction.UP).stroke(editor, cursor);
            } else {
                breadboard.stroke(editor, cursor);
            }
            torch = !torch;
            cursor.up();
            end.up();
        }
        if (torch) {
            cursor.down();
        }
        BlockType.DISPENSER.getBrush().setFacing(Direction.UP).stroke(editor, cursor);
        for (int i = 0; i < 9; ++i) {
            editor.setItem(cursor, i, Firework.get(editor.getRandom(cursor), 16 + editor.getRandom(cursor).nextInt(16)));
        }
        cursor.up();
        SingleBlockBrush cob = BlockType.COBBLESTONE.getBrush();
        RectSolid.newRect(start, end).fill(editor, cob);
        start.translate(dir.reverse(), 2);
        end.translate(dir.reverse(), 2);
        RectSolid.newRect(start, end).fill(editor, cob);
        start.translate(dir);
        end.translate(dir);
        Coord above = end.copy();
        above.up(10);
        for (Coord c : new RectSolid(cursor, above)) {
            if (!editor.isSolidBlock(c)) continue;
            SingleBlockBrush.AIR.stroke(editor, c);
        }
        start.translate(dir.antiClockwise());
        end.translate(dir.antiClockwise());
        RectSolid.newRect(start, end).fill(editor, cob);
        start.translate(dir.clockwise(), 2);
        end.translate(dir.clockwise(), 2);
        RectSolid.newRect(start, end).fill(editor, cob);
    }

    @Override
    public int getSize() {
        return 10;
    }

    @Override
    public boolean validLocation(WorldEditor editor, Direction dir, Coord pos) {
        Coord start = pos.copy();
        Coord end = start.copy();
        start.translate(dir.reverse(), 9);
        end.translate(dir, 9);
        Direction[] orthogonal = dir.orthogonals();
        start.translate(orthogonal[0], 5);
        end.translate(orthogonal[1], 5);
        start.down();
        end.up(3);
        for (Coord c : new RectHollow(start, end)) {
            if (!editor.isAirBlock(c)) continue;
            return false;
        }
        return true;
    }
}

