/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import com.github.srwaggon.minecraft.block.SingleBlockBrush;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ThemeBase;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.List;

public class DungeonPyramidCorner
extends DungeonBase {
    public DungeonPyramidCorner(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    @Override
    public DungeonBase generate(Coord origin, List<Direction> entrances) {
        int x = origin.getX();
        int y = origin.getY();
        int z = origin.getZ();
        ThemeBase theme = this.levelSettings.getTheme();
        BlockBrush blocks = theme.getPrimary().getWall();
        BlockBrush pillar = theme.getPrimary().getPillar();
        RectHollow.newRect(new Coord(x - 3, y - 1, z - 3), new Coord(x + 3, y + 3, z + 3)).fill(this.worldEditor, blocks, false, true);
        RectSolid.newRect(new Coord(x - 2, y + 3, z - 2), new Coord(x + 2, y + 5, z + 2)).fill(this.worldEditor, blocks, false, true);
        RectSolid.newRect(new Coord(x - 1, y + 3, z - 1), new Coord(x + 1, y + 3, z + 1)).fill(this.worldEditor, SingleBlockBrush.AIR);
        RectSolid.newRect(new Coord(x - 3, y - 1, z - 3), new Coord(x + 3, y - 1, z + 3)).fill(this.worldEditor, theme.getPrimary().getFloor(), false, true);
        Coord cursor = new Coord(x, y, z);
        cursor.up(4);
        SingleBlockBrush.AIR.stroke(this.worldEditor, cursor);
        cursor.up(1);
        SingleBlockBrush.AIR.stroke(this.worldEditor, cursor);
        for (Direction dir : Direction.CARDINAL) {
            cursor = new Coord(x, y, z);
            cursor.up(4);
            cursor.translate(dir);
            SingleBlockBrush.AIR.stroke(this.worldEditor, cursor);
            cursor = new Coord(x, y, z);
            cursor.translate(dir, 2);
            cursor.translate(dir.orthogonals()[0], 2);
            Coord start = cursor.copy();
            cursor.up(2);
            Coord end = cursor.copy();
            RectSolid.newRect(start, end).fill(this.worldEditor, pillar);
        }
        return this;
    }

    @Override
    public int getSize() {
        return 4;
    }
}

