/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import com.github.srwaggon.minecraft.block.BlockType;
import com.github.srwaggon.minecraft.block.SingleBlockBrush;
import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.BlockWeightedRandom;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.spawners.MobType;
import java.util.List;

public class DungeonsSpiderNest
extends DungeonBase {
    int originX;
    int originY;
    int originZ;
    byte dungeonHeight = (byte)2;
    int dungeonLength = 3;
    int dungeonWidth = 3;

    public DungeonsSpiderNest(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    @Override
    public DungeonBase generate(Coord origin, List<Direction> entrances) {
        this.originX = origin.getX();
        this.originY = origin.getY();
        this.originZ = origin.getZ();
        BlockWeightedRandom webs = new BlockWeightedRandom();
        webs.addBlock(BlockType.WEB.getBrush(), 3);
        webs.addBlock(SingleBlockBrush.AIR, 1);
        for (int blockX = this.originX - this.dungeonLength - 1; blockX <= this.originX + this.dungeonLength + 1; ++blockX) {
            for (int blockZ = this.originZ - this.dungeonWidth - 1; blockZ <= this.originZ + this.dungeonWidth + 1; ++blockZ) {
                for (int blockY = this.originY + this.dungeonHeight; blockY >= this.originY - this.dungeonHeight; --blockY) {
                    int x = Math.abs(blockX - this.originX);
                    int z = Math.abs(blockZ - this.originZ);
                    int clearHeight = Math.max(x, z);
                    if (blockY == this.originY) {
                        webs.stroke(this.worldEditor, new Coord(blockX, blockY, blockZ));
                    }
                    if (clearHeight < 1) {
                        clearHeight = 1;
                    }
                    if (Math.abs(blockY - this.originY) > clearHeight) continue;
                    if (this.worldEditor.getRandom().nextInt(clearHeight) == 0) {
                        webs.stroke(this.worldEditor, new Coord(blockX, blockY, blockZ));
                        continue;
                    }
                    if (this.worldEditor.getRandom().nextInt(5) != 0) continue;
                    BlockType.GRAVEL.getBrush().stroke(this.worldEditor, new Coord(blockX, blockY, blockZ));
                }
            }
        }
        Coord cursor = new Coord(this.originX, this.originY, this.originZ);
        this.generateSpawner(cursor, MobType.CAVESPIDER);
        List<Coord> spaces = new RectSolid(new Coord(this.originX - this.dungeonLength, this.originY - 1, this.originZ - this.dungeonWidth), new Coord(this.originX + this.dungeonLength, this.originY + 1, this.originZ + this.dungeonWidth)).get();
        List<Coord> chestLocations = this.chooseRandomLocations(1 + this.worldEditor.getRandom(cursor).nextInt(3), spaces);
        ChestType chestType = this.getRoomSetting().getChestType().orElse(ChestType.chooseRandomAmong(this.worldEditor.getRandom(cursor), ChestType.COMMON_TREASURES));
        this.worldEditor.getTreasureChestEditor().createChests(chestLocations, false, Dungeon.getLevel(this.originY), chestType);
        return this;
    }

    @Override
    public int getSize() {
        return 4;
    }
}

