/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment;

import com.github.srwaggon.minecraft.block.normal.StairsBlock;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.dungeon.DungeonLevel;
import greymerk.roguelike.dungeon.segment.ISegment;
import greymerk.roguelike.dungeon.segment.Segment;
import greymerk.roguelike.theme.ThemeBase;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SegmentGenerator {
    protected Segment arch;
    protected WeightedRandomizer<Segment> segments;

    public SegmentGenerator() {
        this(Segment.ARCH);
    }

    public SegmentGenerator(Segment arch) {
        this.segments = new WeightedRandomizer();
        this.arch = arch;
    }

    public SegmentGenerator(JsonObject json) {
        String archType = json.get("arch").getAsString();
        this.arch = Segment.valueOf(archType);
        this.segments = new WeightedRandomizer();
        JsonArray segmentList = json.get("segments").getAsJsonArray();
        for (JsonElement jsonElement : segmentList) {
            if (jsonElement.isJsonNull()) continue;
            JsonObject segData = jsonElement.getAsJsonObject();
            this.add(segData);
        }
    }

    public static SegmentGenerator getRandom(Random rand, int count) {
        SegmentGenerator segments = new SegmentGenerator(Segment.ARCH);
        for (int i = 0; i < count; ++i) {
            segments.add(Segment.getRandom(rand), 1);
        }
        return segments;
    }

    public void add(JsonObject entry) {
        String segType = entry.get("type").getAsString();
        Segment segment = Segment.valueOf(segType);
        if (entry.has("arch")) {
            boolean a = entry.get("arch").getAsBoolean();
            if (a) {
                this.arch = segment;
            }
            return;
        }
        int weight = entry.has("weight") ? entry.get("weight").getAsInt() : 1;
        this.segments.add(new WeightedChoice<Segment>(segment, weight));
    }

    public SegmentGenerator inherit(SegmentGenerator toInherit) {
        SegmentGenerator segmentGenerator = new SegmentGenerator();
        segmentGenerator.add(toInherit);
        segmentGenerator.add(this);
        return segmentGenerator;
    }

    public void add(SegmentGenerator segmentGenerator) {
        this.arch = segmentGenerator.arch;
        this.segments.merge(segmentGenerator.segments);
    }

    public void add(Segment segment, int weight) {
        this.segments.add(new WeightedChoice<Segment>(segment, weight));
    }

    public Segment getArch() {
        return this.arch;
    }

    public WeightedRandomizer<Segment> getSegments() {
        return this.segments;
    }

    public List<ISegment> genSegment(WorldEditor editor, Random rand, DungeonLevel level, Direction dir, Coord pos) {
        ArrayList<ISegment> segments = new ArrayList<ISegment>();
        for (Direction orthogonals : dir.orthogonals()) {
            ISegment segment = this.pickSegment(rand, dir, pos);
            if (segment == null) {
                return segments;
            }
            segment.generate(editor, rand, level, orthogonals, level.getSettings().getTheme(), pos.copy());
            segments.add(segment);
        }
        if (!level.hasNearbyNode(pos) && rand.nextInt(3) == 0) {
            this.addSupport(editor, level.getSettings().getTheme(), pos.copy());
        }
        return segments;
    }

    private ISegment pickSegment(Random random, Direction dir, Coord pos) {
        int z = pos.getZ();
        if ((dir == Direction.NORTH || dir == Direction.SOUTH) && z % 3 == 0) {
            return this.pickSegment(z % 6 == 0, random);
        }
        int x = pos.getX();
        if ((dir == Direction.WEST || dir == Direction.EAST) && x % 3 == 0) {
            return this.pickSegment(x % 6 == 0, random);
        }
        return null;
    }

    private ISegment pickSegment(boolean isArch, Random random) {
        return isArch ? Segment.getSegment(this.getArch()) : (this.getSegments().isEmpty() ? Segment.getSegment(Segment.WALL) : Segment.getSegment(this.getSegments().get(random)));
    }

    private void addSupport(WorldEditor editor, ThemeBase theme, Coord origin) {
        Coord beneathWalkway = origin.copy().down(2);
        if (!editor.isAirBlock(beneathWalkway)) {
            return;
        }
        editor.fillDown(beneathWalkway, theme.getPrimary().getPillar());
        StairsBlock stair = theme.getPrimary().getStair().setUpsideDown(true);
        stair.setFacing(Direction.WEST).stroke(editor, beneathWalkway.copy().west());
        stair.setFacing(Direction.EAST).stroke(editor, beneathWalkway.copy().east());
        stair.setFacing(Direction.SOUTH).stroke(editor, beneathWalkway.copy().south());
        stair.setFacing(Direction.NORTH).stroke(editor, beneathWalkway.copy().north());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentGenerator)) {
            return false;
        }
        SegmentGenerator other = (SegmentGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Segment this$arch = this.getArch();
        Segment other$arch = other.getArch();
        if (this$arch == null ? other$arch != null : !((Object)((Object)this$arch)).equals((Object)other$arch)) {
            return false;
        }
        WeightedRandomizer<Segment> this$segments = this.getSegments();
        WeightedRandomizer<Segment> other$segments = other.getSegments();
        return !(this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SegmentGenerator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Segment $arch = this.getArch();
        result = result * 59 + ($arch == null ? 43 : ((Object)((Object)$arch)).hashCode());
        WeightedRandomizer<Segment> $segments = this.getSegments();
        result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
        return result;
    }

    public String toString() {
        return "SegmentGenerator(arch=" + (Object)((Object)this.getArch()) + ", segments=" + this.getSegments() + ")";
    }
}

