/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment.part;

import com.github.srwaggon.minecraft.block.BlockType;
import com.github.srwaggon.minecraft.block.SingleBlockBrush;
import com.github.srwaggon.minecraft.block.normal.StairsBlock;
import greymerk.roguelike.dungeon.DungeonLevel;
import greymerk.roguelike.dungeon.segment.part.SegmentBase;
import greymerk.roguelike.theme.ThemeBase;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.Random;

public class SegmentSewerDrain
extends SegmentBase {
    @Override
    protected void genWall(WorldEditor editor, Random rand, DungeonLevel level, Direction dir, ThemeBase theme, Coord origin) {
        Coord cursor;
        SingleBlockBrush water = BlockType.WATER_FLOWING.getBrush();
        StairsBlock stair = theme.getSecondary().getStair();
        SingleBlockBrush bars = BlockType.IRON_BAR.getBrush();
        Direction[] orthogonals = dir.orthogonals();
        Coord start = origin.copy();
        start.down();
        Coord end = start.copy();
        start.translate(orthogonals[0]);
        end.translate(orthogonals[1]);
        RectSolid.newRect(start, end).fill(editor, SingleBlockBrush.AIR);
        start.down();
        end.down();
        RectSolid.newRect(start, end).fill(editor, water, false, true);
        start = origin.copy();
        start.translate(dir, 2);
        end = start.copy();
        start.translate(orthogonals[0]);
        end.translate(orthogonals[1]);
        end.up(2);
        RectSolid.newRect(start, end).fill(editor, SingleBlockBrush.AIR);
        start.translate(dir);
        end.translate(dir);
        RectSolid.newRect(start, end).fill(editor, theme.getPrimary().getWall());
        for (Direction o : orthogonals) {
            cursor = origin.copy();
            cursor.translate(dir, 2);
            cursor.translate(o);
            stair.setUpsideDown(false).setFacing(o.reverse()).stroke(editor, cursor);
            cursor.up();
            bars.stroke(editor, cursor);
            cursor.up();
            stair.setUpsideDown(true).setFacing(o.reverse()).stroke(editor, cursor);
        }
        start = origin.copy();
        start.up();
        end = start.copy();
        end.translate(dir, 5);
        RectSolid.newRect(start, end).fill(editor, SingleBlockBrush.AIR);
        water.stroke(editor, end);
        cursor = origin.copy();
        cursor.down();
        cursor.translate(dir);
        SingleBlockBrush.AIR.stroke(editor, cursor);
    }
}

