/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment.part;

import com.github.srwaggon.minecraft.block.BlockType;
import com.github.srwaggon.minecraft.block.SingleBlockBrush;
import com.github.srwaggon.minecraft.block.normal.StairsBlock;
import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.DungeonLevel;
import greymerk.roguelike.dungeon.segment.part.SegmentBase;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ThemeBase;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.spawners.MobType;
import greymerk.roguelike.worldgen.spawners.SpawnerSettings;
import java.util.List;
import java.util.Random;

public class SegmentTomb
extends SegmentBase {
    private static void tomb(WorldEditor editor, Random rand, LevelSettings level, ThemeBase theme, Direction dir, Coord pos) {
        Direction[] orthogonals = dir.orthogonals();
        Coord start = pos.copy();
        start.translate(dir, 3);
        Coord end = start.copy();
        start.translate(orthogonals[0]);
        end.translate(orthogonals[1]);
        end.up(3);
        end.translate(dir, 3);
        List<Coord> box = new RectHollow(start, end).get();
        for (Coord c : box) {
            if (editor.isSolidBlock(c)) continue;
            return;
        }
        RectHollow.newRect(start, end).fill(editor, theme.getPrimary().getWall());
        if (rand.nextInt(3) != 0) {
            return;
        }
        Coord cursor = pos.copy();
        cursor.up();
        cursor.translate(dir, 4);
        SpawnerSettings spawners = level.getSpawners().isEmpty() ? MobType.newSpawnerSetting(MobType.UNDEAD_MOBS) : level.getSpawners();
        spawners.generateSpawner(editor, cursor, level.getDifficulty(cursor));
        cursor.translate(dir);
        editor.getTreasureChestEditor().createChest(cursor, false, Dungeon.getLevel(cursor.getY()), ChestType.chooseRandomAmong(rand, ChestType.COMMON_TREASURES));
    }

    @Override
    protected void genWall(WorldEditor editor, Random rand, DungeonLevel level, Direction dir, ThemeBase theme, Coord origin) {
        StairsBlock stair = theme.getPrimary().getStair();
        Coord cursor = origin.copy();
        Direction[] orthogonals = dir.orthogonals();
        cursor.translate(dir, 2);
        Coord start = cursor.copy();
        start.translate(orthogonals[0], 1);
        Coord end = cursor.copy();
        end.translate(orthogonals[1], 1);
        end.up(2);
        RectSolid.newRect(start, end).fill(editor, SingleBlockBrush.AIR);
        start.translate(dir, 1);
        end.translate(dir, 1);
        RectSolid.newRect(start, end).fill(editor, theme.getSecondary().getWall(), false, true);
        cursor.up(2);
        for (Direction d : orthogonals) {
            Coord c = cursor.copy();
            c.translate(d, 1);
            stair.setUpsideDown(true).setFacing(d.reverse());
            stair.stroke(editor, c);
        }
        SegmentTomb.tomb(editor, rand, level.getSettings(), theme, dir, origin.copy());
        cursor = origin.copy();
        cursor.up();
        cursor.translate(dir, 3);
        BlockType.QUARTZ.getBrush().stroke(editor, cursor);
    }
}

