/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.DungeonSettingsParser;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.base.SettingsBase;
import greymerk.roguelike.dungeon.settings.base.SettingsLayout;
import greymerk.roguelike.dungeon.settings.base.SettingsLootRules;
import greymerk.roguelike.dungeon.settings.base.SettingsRooms;
import greymerk.roguelike.dungeon.settings.base.SettingsSecrets;
import greymerk.roguelike.dungeon.settings.base.SettingsSegments;
import greymerk.roguelike.dungeon.settings.base.SettingsTheme;
import greymerk.roguelike.dungeon.settings.builtin.SettingsDesertTheme;
import greymerk.roguelike.dungeon.settings.builtin.SettingsForestTheme;
import greymerk.roguelike.dungeon.settings.builtin.SettingsGrasslandTheme;
import greymerk.roguelike.dungeon.settings.builtin.SettingsIceTheme;
import greymerk.roguelike.dungeon.settings.builtin.SettingsJungleTheme;
import greymerk.roguelike.dungeon.settings.builtin.SettingsMesaTheme;
import greymerk.roguelike.dungeon.settings.builtin.SettingsMountainTheme;
import greymerk.roguelike.dungeon.settings.builtin.SettingsSwampTheme;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SettingsContainer {
    public static final String DEFAULT_NAMESPACE = "default";
    public static final String BUILTIN_NAMESPACE = "builtin";
    private final Map<String, Map<String, DungeonSettings>> settingsByNamespace = new HashMap<String, Map<String, DungeonSettings>>();

    public SettingsContainer(DungeonSettings ... dungeonSettings) {
        this.put(new SettingsRooms(), new SettingsSecrets(), new SettingsSegments(), new SettingsLayout(), new SettingsTheme(), new SettingsLootRules(), new SettingsBase(), new SettingsDesertTheme(), new SettingsGrasslandTheme(), new SettingsJungleTheme(), new SettingsSwampTheme(), new SettingsMountainTheme(), new SettingsForestTheme(), new SettingsMesaTheme(), new SettingsIceTheme());
        this.put(dungeonSettings);
    }

    public void put(Map<String, String> dungeonSettingsJsonByFileName) throws Exception {
        for (String fileName : dungeonSettingsJsonByFileName.keySet()) {
            try {
                String dungeonSettingsJson = dungeonSettingsJsonByFileName.get(fileName);
                this.put(dungeonSettingsJson);
            }
            catch (Exception e) {
                throw new Exception("Error in: " + fileName + ": " + e.getMessage(), e);
            }
        }
    }

    public void put(String dungeonSettingsJson) throws Exception {
        DungeonSettingsParser.parseJson(dungeonSettingsJson).ifPresent(this::put);
    }

    public void put(DungeonSettings ... dungeonSettings) {
        Arrays.stream(dungeonSettings).forEach(this::put);
    }

    public void put(List<DungeonSettings> dungeonSettings) {
        dungeonSettings.forEach(this::put);
    }

    private void put(DungeonSettings dungeonSettings) {
        String namespace = dungeonSettings.getNamespace();
        if (!this.containsNamespace(namespace)) {
            this.settingsByNamespace.put(namespace, new HashMap());
        }
        this.settingsByNamespace.get(namespace).put(dungeonSettings.getName(), dungeonSettings);
    }

    public Collection<DungeonSettings> getByNamespace(String namespace) {
        if (this.containsNamespace(namespace)) {
            return this.settingsByNamespace.get(namespace).values();
        }
        return new ArrayList<DungeonSettings>();
    }

    public Collection<DungeonSettings> getBuiltinSettings() {
        return this.settingsByNamespace.entrySet().stream().filter(this::isBuiltIn).map(Map.Entry::getValue).map(Map::values).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private boolean isBuiltIn(Map.Entry<String, Map<String, DungeonSettings>> entry) {
        return BUILTIN_NAMESPACE.equals(entry.getKey());
    }

    public Collection<DungeonSettings> getCustomSettings() {
        return this.settingsByNamespace.entrySet().stream().filter(((Predicate<Map.Entry>)this::isBuiltIn).negate()).map(Map.Entry::getValue).map(Map::values).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public DungeonSettings get(SettingIdentifier id) {
        if (!this.contains(id)) {
            throw new RuntimeException("Setting not found: " + id.toString());
        }
        return this.getNamespace(id).get(id.getName());
    }

    private boolean contains(SettingIdentifier id) {
        return this.containsNamespace(id.getNamespace()) && this.getNamespace(id).containsKey(id.getName());
    }

    private boolean containsNamespace(String namespace) {
        return this.settingsByNamespace.containsKey(namespace);
    }

    private Map<String, DungeonSettings> getNamespace(SettingIdentifier id) {
        return this.settingsByNamespace.get(id.getNamespace());
    }

    public String toString() {
        return this.settingsByNamespace.values().stream().map(Map::values).flatMap(Collection::stream).map(DungeonSettings::getId).map(SettingIdentifier::toString).collect(Collectors.joining(" "));
    }
}

