/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.theme.ThemeBase;
import greymerk.roguelike.theme.ThemeParser;
import greymerk.roguelike.theme.ThemeTower;

public class TowerSettings {
    private Tower type;
    private ThemeBase theme;

    public TowerSettings(Tower type, Theme theme) {
        this.type = type;
        this.theme = theme.getThemeBase();
    }

    public TowerSettings(JsonElement e) throws Exception {
        JsonObject data = e.getAsJsonObject();
        this.type = data.has("type") ? Tower.get(data.get("type").getAsString()) : null;
        this.theme = data.has("theme") ? ThemeParser.parse(data.get("theme").getAsJsonObject()) : null;
    }

    public TowerSettings(TowerSettings base, TowerSettings override) {
        if (base == null) {
            this.type = override.type;
            this.theme = override.theme;
            return;
        }
        if (override == null) {
            this.type = base.type;
            this.theme = base.theme;
            return;
        }
        this.type = override.type == null ? base.type : override.type;
        this.theme = override.theme == null ? base.theme : override.theme;
    }

    public TowerSettings(TowerSettings toCopy) {
        this.type = toCopy.type;
        this.theme = toCopy.theme;
    }

    public Tower getType() {
        if (this.type == null) {
            return Tower.ROGUE;
        }
        return this.type;
    }

    public ThemeBase getTheme() {
        if (this.theme == null) {
            return new ThemeTower();
        }
        return this.theme;
    }
}

